/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.collections;

import com.almworks.tracker.eapi.alpha.CollectionData;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.collections.CollectionsCache;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsCacheImpl
implements CollectionsCache {
    private static final String COLLECTIONS_ELEM = "Collections";
    private static final String COLLECTION_ELEM = "Collection";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String ARTIFACT_INFO_ELEM = "ArtifactInfo";
    private static final String URL_ATTR = "url";
    private final ArtifactInfoCache myArtifactInfoCache;
    @Property
    public Map<String, Set<String>> myURLsMap = new HashMap();
    @Property
    public Map<String, String> myCollectionNameMap = new HashMap();
    @Transient
    private Map<String, CollectionData> myCollectionDataMap = new HashMap();

    public CollectionsCacheImpl() {
        this.myArtifactInfoCache = null;
    }

    public CollectionsCacheImpl(ArtifactInfoCache cache) {
        this.myArtifactInfoCache = cache;
    }

    @Override
    public void store(CollectionData collectionData, Collection<String> infoURLs) {
        this.put(collectionData, new HashSet<String>(infoURLs));
    }

    private CollectionData put(CollectionData data, Set<String> urls) {
        String id = data.getCollectionId();
        this.myURLsMap.put(id, urls);
        this.myCollectionNameMap.put(id, (String)data.getProperty(CollectionData.COLLECTION_NAME));
        return this.myCollectionDataMap.put(id, data);
    }

    @Override
    @Nullable
    public Pair<CollectionData, ? extends Set<String>> restore(String collectionID) {
        if (this.myURLsMap.containsKey(collectionID)) {
            return Pair.create((Object)this.myCollectionDataMap.get(collectionID), this.myURLsMap.get(collectionID));
        }
        return null;
    }

    private CollectionData remove(String id) {
        this.myURLsMap.remove(id);
        this.myCollectionNameMap.remove(id);
        return this.myCollectionDataMap.remove(id);
    }

    @Override
    public synchronized void forgetCollection(String collectionID) {
        Set<String> urls = this.myURLsMap.get(collectionID);
        this.remove(collectionID);
        HashSet<String> toRemoveFromCache = new HashSet<String>(urls);
        for (String url : urls) {
            if (!this.otherCollectionContainsUrl(url)) continue;
            toRemoveFromCache.remove(url);
        }
        this.myArtifactInfoCache.removeArtifacts(toRemoveFromCache);
    }

    private boolean otherCollectionContainsUrl(String url) {
        for (Set<String> urls : this.myURLsMap.values()) {
            if (!urls.contains(url)) continue;
            return true;
        }
        return false;
    }

    public void loadState(CollectionsCacheImpl state) {
        for (String id : state.myCollectionNameMap.keySet()) {
            CollectionData collectionData = new CollectionData(id, true, Collections.singletonMap(CollectionData.COLLECTION_NAME, state.myCollectionNameMap.get(id)));
            this.put(collectionData, state.myURLsMap.get(id));
        }
    }
}

