/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.internal.id.ConfigurationCacheableIdFactory;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
@ThreadSafe
public class TaskIdentityFactory {
    private final ConfigurationCacheableIdFactory idFactory;

    public TaskIdentityFactory(ConfigurationCacheableIdFactory idFactory) {
        this.idFactory = idFactory;
    }

    public <T extends Task> TaskIdentity<T> create(String name, Class<T> type, ProjectInternal project) {
        long id = this.idFactory.createId();
        return TaskIdentityFactory.doCreate(name, type, project, id);
    }

    public <T extends Task> TaskIdentity<T> recreate(String name, Class<T> type, ProjectInternal project, long uniqueId) {
        this.idFactory.idRecreated();
        return TaskIdentityFactory.doCreate(name, type, project, uniqueId);
    }

    private static <T extends Task> TaskIdentity<T> doCreate(String name, Class<T> type, ProjectInternal project, long uniqueId) {
        return new TaskIdentity<T>(type, name, project.projectPath(name), project.identityPath(name), project.getGradle().getIdentityPath(), uniqueId);
    }
}

