/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.build.ExecutionResult;

public class SelectedTaskExecutionAction
implements BuildWorkExecutor {
    @Override
    public ExecutionResult<Void> execute(GradleInternal gradle, FinalizedExecutionPlan plan) {
        TaskExecutionGraphInternal taskGraph = gradle.getTaskGraph();
        this.bindAllReferencesOfProject(plan);
        return taskGraph.execute(plan);
    }

    private void bindAllReferencesOfProject(FinalizedExecutionPlan plan) {
        HashSet seen = Sets.newHashSet();
        plan.getContents().getScheduledNodes().visitNodes(nodes -> {
            for (Node node : nodes) {
                ProjectInternal taskProject;
                if (!(node instanceof LocalTaskNode) || !seen.add(taskProject = node.getOwningProject())) continue;
                taskProject.bindAllModelRules();
            }
        });
    }
}

