/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JunitLibrarySetupKt;
import com.intellij.execution.junit.codeInspection.JUnitIgnoredTestVisitor;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitIgnoredTestInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "onlyReportWithoutReason", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "shouldInspect", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.junit"})
public final class JUnitIgnoredTestInspection
extends AbstractBaseUastLocalInspectionTool {
    @JvmField
    public boolean onlyReportWithoutReason = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"onlyReportWithoutReason", (String)JUnitBundle.message("jvm.inspections.junit.ignored.test.ignore.reason.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    private final boolean shouldInspect(PsiFile file) {
        return JunitLibrarySetupKt.isJUnit4InScope(file) || JunitLibrarySetupKt.isJUnit5InScope(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!this.shouldInspect(psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UClass.class, UMethod.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new JUnitIgnoredTestVisitor(holder, this.onlyReportWithoutReason), classArray, true);
    }
}

