/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.AbstractButtonArmedQuery;
import org.assertj.swing.driver.AbstractButtonSelectedQuery;
import org.assertj.swing.driver.AbstractButtonTextQuery;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.driver.TextDisplayDriver;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class AbstractButtonDriver
extends JComponentDriver
implements TextDisplayDriver<AbstractButton> {
    private static final String SELECTED_PROPERTY = "selected";
    private static final String ARMED_PROPERTY = "armed";
    private static final String TEXT_PROPERTY = "text";

    public AbstractButtonDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull AbstractButton button2, @Nullable String expected) {
        ((TextAssert)TextAssert.verifyThat(this.textOf(button2)).as(AbstractButtonDriver.propertyName(button2, TEXT_PROPERTY))).isEqualOrMatches(expected);
    }

    @Override
    public void requireText(@Nonnull AbstractButton button2, @Nonnull Pattern pattern) {
        ((TextAssert)TextAssert.verifyThat(this.textOf(button2)).as(AbstractButtonDriver.propertyName(button2, TEXT_PROPERTY))).matches(pattern);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public String textOf(@Nonnull AbstractButton button2) {
        return AbstractButtonTextQuery.textOf(button2);
    }

    @RunsInEDT
    public void select(@Nonnull AbstractButton button2) {
        if (AbstractButtonDriver.checkSelected(button2)) {
            return;
        }
        this.robot.click(button2);
    }

    @RunsInEDT
    public void deselect(@Nonnull AbstractButton button2) {
        if (!AbstractButtonDriver.checkSelected(button2)) {
            return;
        }
        this.robot.click(button2);
    }

    @RunsInEDT
    private static boolean checkSelected(@Nonnull AbstractButton button2) {
        Boolean result = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(button2);
            return button2.isSelected();
        });
        return Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    public void requireSelected(@Nonnull AbstractButton button2) {
        this.assertThatButtonIsSelected(button2, true);
    }

    @RunsInEDT
    public void requireNotSelected(@Nonnull AbstractButton button2) {
        this.assertThatButtonIsSelected(button2, false);
    }

    @RunsInEDT
    private void assertThatButtonIsSelected(@Nonnull AbstractButton button2, boolean selected) {
        ((AbstractBooleanAssert)Assertions.assertThat(AbstractButtonSelectedQuery.isSelected(button2)).as(AbstractButtonDriver.selectedProperty(button2))).isEqualTo(selected);
    }

    @Nonnull
    @RunsInEDT
    private static Description selectedProperty(@Nonnull AbstractButton button2) {
        return AbstractButtonDriver.propertyName(button2, SELECTED_PROPERTY);
    }

    @RunsInEDT
    public void requireArmed(@Nonnull AbstractButton button2) {
        this.assertThatButtonIsArmed(button2, true);
    }

    @RunsInEDT
    public void requireNotArmed(@Nonnull AbstractButton button2) {
        this.assertThatButtonIsArmed(button2, false);
    }

    @RunsInEDT
    private void assertThatButtonIsArmed(@Nonnull AbstractButton button2, boolean armed) {
        ((AbstractBooleanAssert)Assertions.assertThat(AbstractButtonArmedQuery.isArmed(button2)).as(AbstractButtonDriver.armedProperty(button2))).isEqualTo(armed);
    }

    @Nonnull
    @RunsInEDT
    private static Description armedProperty(@Nonnull AbstractButton button2) {
        return AbstractButtonDriver.propertyName(button2, ARMED_PROPERTY);
    }
}

