/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.AbstractButtonTextQuery;

public class JMenuItemMatcher
implements ComponentMatcher {
    private static final String SEPARATOR = "|";
    private final String label;

    public JMenuItemMatcher(String ... path) {
        this.label = Strings.join(path).with(SEPARATOR);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (!(c instanceof JMenuItem)) {
            return false;
        }
        JMenuItem menuItem = (JMenuItem)c;
        String text = menuItem.getText();
        return Objects.areEqual(this.label, text) || Objects.areEqual(this.label, this.pathOf(menuItem));
    }

    @RunsInCurrentThread
    private String pathOf(@Nonnull JMenuItem menuItem) {
        Component parent = this.parentOrInvokerOf(menuItem);
        if (parent instanceof JMenuItem) {
            return Strings.concat(this.pathOf((JMenuItem)parent), SEPARATOR, AbstractButtonTextQuery.textOf(menuItem));
        }
        return AbstractButtonTextQuery.textOf(menuItem);
    }

    @RunsInCurrentThread
    private Component parentOrInvokerOf(@Nonnull JMenuItem menuItem) {
        Component parent = menuItem.getParent();
        if (parent instanceof JPopupMenu) {
            parent = ((JPopupMenu)parent).getInvoker();
        }
        return parent;
    }

    public String toString() {
        return String.format("%s[label=%s]", this.getClass().getName(), Strings.quote(this.label));
    }
}

