/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import java.util.regex.Pattern;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.util.Patterns;
import org.assertj.swing.util.Strings;
import org.assertj.swing.util.TextMatcher;

public class PatternTextMatcher
implements TextMatcher {
    private final Pattern[] patterns;

    public PatternTextMatcher(Pattern ... patterns) {
        this.patterns = Preconditions.checkNotNullOrEmpty(patterns);
    }

    @Override
    public boolean isMatching(@Nullable String text) {
        for (Pattern pattern : this.patterns) {
            if (!Strings.match(pattern, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String description() {
        return this.patterns.length == 1 ? "pattern" : "patterns";
    }

    @Override
    @Nonnull
    public String formattedValues() {
        if (this.patterns.length == 1) {
            return Preconditions.checkNotNull(org.assertj.core.util.Strings.quote(this.patterns[0].pattern()));
        }
        return Patterns.format(this.patterns);
    }
}

