/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.util.SetMultimap;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u001f\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0002R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyDeclarationCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "declaredVariablesInLoop", "Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/util/SetMultimap;)V", "getDeclaredVariablesInLoop", "()Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitRepeatable", "loop", "checkers"})
final class PropertyDeclarationCollector
extends FirVisitor<Unit, FirStatement> {
    @NotNull
    private final SetMultimap<FirStatement, FirVariableSymbol<?>> declaredVariablesInLoop;

    public PropertyDeclarationCollector(@NotNull SetMultimap<FirStatement, FirVariableSymbol<?>> declaredVariablesInLoop) {
        Intrinsics.checkNotNullParameter(declaredVariablesInLoop, (String)"declaredVariablesInLoop");
        this.declaredVariablesInLoop = declaredVariablesInLoop;
    }

    @NotNull
    public final SetMultimap<FirStatement, FirVariableSymbol<?>> getDeclaredVariablesInLoop() {
        return this.declaredVariablesInLoop;
    }

    @Override
    public void visitElement(@NotNull FirElement element, @Nullable FirStatement data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this, data);
    }

    @Override
    public void visitProperty(@NotNull FirProperty property, @Nullable FirStatement data) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (property.isLocal() && data != null) {
            this.declaredVariablesInLoop.put(data, property.getSymbol());
        }
        this.visitElement((FirElement)property, data);
    }

    @Override
    public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @Nullable FirStatement data) {
        Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
        this.visitRepeatable(whileLoop, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @Nullable FirStatement data) {
        Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
        this.visitRepeatable(doWhileLoop, data);
    }

    @Override
    public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @Nullable FirStatement data) {
        Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
        EventOccurrencesRange eventOccurrencesRange = anonymousFunction.getInvocationKind();
        boolean bl = eventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited((EventOccurrencesRange)eventOccurrencesRange) : false;
        if (bl) {
            this.visitRepeatable(anonymousFunction, data);
        } else {
            this.visitElement((FirElement)anonymousFunction, data);
        }
    }

    private final void visitRepeatable(FirStatement loop, FirStatement data) {
        this.visitElement((FirElement)loop, loop);
        if (data != null) {
            this.declaredVariablesInLoop.putAll(data, (Collection<FirVariableSymbol<?>>)this.declaredVariablesInLoop.get(loop));
        }
    }
}

