/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared;

import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetectorKt;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/KotlinRunLineMarkerContributor;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "<init>", "()V", "isDumbAware", "", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "getSlowInfo", "hasSingleMain", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "mainFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin.code-insight.line-markers.shared"})
public final class KotlinRunLineMarkerContributor
extends RunLineMarkerContributor {
    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    @Nullable
    public RunLineMarkerContributor.Info getSlowInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function = ktNamedFunction;
        if (!Intrinsics.areEqual((Object)function.getNameIdentifier(), (Object)element)) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinMainFunctionDetector detector = KotlinMainFunctionDetector.Companion.getInstanceDumbAware(project);
        if (!KotlinMainFunctionDetector.isMain$default(detector, function, null, 2, null)) {
            return null;
        }
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project2) && !this.hasSingleMain(detector, function)) {
            return null;
        }
        KtFile ktFile2 = function.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        Module module = GenericPsiUtils.getModule((PsiElement)ktFile2);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (KotlinFacetUtils.isTestModule(module2)) {
            return null;
        }
        if (!IdePlatformKindToolingKt.getTooling(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)TargetPlatformDetectorUtils.getPlatform(module2))).acceptsAsEntryPoint((KtFunction)function)) {
            return null;
        }
        Icon icon2 = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.TestStateRun);
        return new RunLineMarkerContributor.Info(icon2, ExecutorAction.Companion.getActions(Integer.MAX_VALUE), null);
    }

    private final boolean hasSingleMain(KotlinMainFunctionDetector $this$hasSingleMain, KtNamedFunction mainFunction) {
        return KotlinMainFunctionDetectorKt.findMainOwner($this$hasSingleMain, (PsiElement)mainFunction) != null;
    }
}

