/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotificationState;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "notificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;)V", "getNotificationState", "()Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "equals", "", "other", "", "hashCode", "", "Companion", "kotlin.project-configuration"})
public final class ConfigureKotlinNotification
extends Notification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigureKotlinNotificationState notificationState;

    public ConfigureKotlinNotification(@NotNull Project project, @NotNull List<? extends Module> excludeModules, @NotNull ConfigureKotlinNotificationState notificationState) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        Intrinsics.checkNotNullParameter((Object)notificationState, (String)"notificationState");
        super("Configure Kotlin in Project", KotlinProjectConfigurationBundle.message("configure.kotlin", new Object[0]), notificationState.getNotificationString(), NotificationType.WARNING);
        this.notificationState = notificationState;
        this.setListener((arg_0, arg_1) -> ConfigureKotlinNotification._init_$lambda$0(project, excludeModules, arg_0, arg_1));
        this.setSuggestionType(true);
    }

    @NotNull
    public final ConfigureKotlinNotificationState getNotificationState() {
        return this.notificationState;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConfigureKotlinNotification)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getContent(), (Object)((ConfigureKotlinNotification)((Object)other)).getContent());
    }

    public int hashCode() {
        return this.getContent().hashCode();
    }

    private static final void _init_$lambda$0(Project $project, List $excludeModules, Notification notification, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            String string = event.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            KotlinProjectConfigurator kotlinProjectConfigurator = ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(string);
            if (kotlinProjectConfigurator == null) {
                throw new AssertionError((Object)("Missed action: " + event.getDescription()));
            }
            KotlinProjectConfigurator configurator = kotlinProjectConfigurator;
            notification.expire();
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logClickConfigureKtNotification($project);
            configurator.configure($project, $excludeModules);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion;", "", "<init>", "()V", "getNotificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "getLink", "", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "isOnlyOneModule", "", "kotlin.project-configuration"})
    @SourceDebugExtension(value={"SMAP\nConfigureKotlinNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureKotlinNotification.kt\norg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1557#2:98\n1628#2,3:99\n1#3:102\n*S KotlinDebug\n*F\n+ 1 ConfigureKotlinNotification.kt\norg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion\n*L\n84#1:98\n84#1:99,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ConfigureKotlinNotificationState getNotificationState(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string;
            boolean isOnlyOneModule;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
            Pair<Collection<ModuleSourceRootGroup>, Collection<KotlinProjectConfigurator>> pair = ConfigureKotlinInProjectUtilsKt.getConfigurationPossibilitiesForConfigureNotification(project, excludeModules);
            Collection configurableModules = (Collection)pair.component1();
            Collection ableToRunConfigurators = (Collection)pair.component2();
            if (ableToRunConfigurators.isEmpty() || configurableModules.isEmpty()) {
                return null;
            }
            boolean bl = isOnlyOneModule = configurableModules.size() == 1;
            if (isOnlyOneModule) {
                Object[] objectArray = new Object[]{((ModuleSourceRootGroup)CollectionsKt.first((Iterable)configurableModules)).getBaseModule().getName()};
                string = KotlinProjectConfigurationBundle.message("configure.0.module", objectArray);
            } else {
                string = KotlinProjectConfigurationBundle.message("configure.modules", new Object[0]);
            }
            String modulesString = string;
            String links = CollectionsKt.joinToString$default((Iterable)ableToRunConfigurators, (CharSequence)"<br/>", null, null, (int)0, null, arg_0 -> Companion.getNotificationState$lambda$0(isOnlyOneModule, arg_0), (int)30, null);
            String string2 = project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            Object object = new Object[]{modulesString, project.getName(), links};
            String string3 = KotlinProjectConfigurationBundle.message("configure.0.in.1.project.br.2", object);
            object = configurableModules;
            String string4 = string3;
            String string5 = string2;
            boolean $i$f$map = false;
            void var11_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ModuleSourceRootGroup moduleSourceRootGroup = (ModuleSourceRootGroup)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string6 = it.getBaseModule().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                collection.add(string6);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            String string7 = string4;
            String string8 = string5;
            return new ConfigureKotlinNotificationState(string8, string7, collection2);
        }

        private final String getLink(KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
            Object[] objectArray = new Object[2];
            objectArray[0] = configurator.getPresentableText();
            Integer n = 1;
            int n2 = ((Number)n).intValue();
            int n3 = 1;
            Object[] objectArray2 = objectArray;
            String string = "as.kotlin.1.module";
            String string2 = configurator.getName();
            boolean bl = false;
            boolean bl2 = isOnlyOneModule;
            Integer n4 = bl2 ? n : null;
            if (n4 == null) {
                n4 = 2;
            }
            objectArray2[n3] = n4;
            return "<a href=\"" + string2 + "\">" + KotlinProjectConfigurationBundle.message(string, objectArray) + "</a>";
        }

        private static final CharSequence getNotificationState$lambda$0(boolean $isOnlyOneModule, KotlinProjectConfigurator configurator) {
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            return Companion.getLink(configurator, $isOnlyOneModule);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

