/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.CoroutineStateMachineVisitor;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.MockStackFrame;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005*\u00020\u0003\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005*\u00020\u0003\u001a&\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0080@\u00a2\u0006\u0002\u0010\u000e\u001a\u001e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0080@\u00a2\u0006\u0002\u0010\u0010\u001a$\u0010\u000f\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0014\u001a1\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u0017*\u00020\r2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u0001H\u00160\u0019\u00a2\u0006\u0002\u0010\u001b\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\nH\u0002\u001a\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020!H\u0002\u001a\u0010\u0010&\u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0002\u001a\n\u0010(\u001a\u00020\u0001*\u00020)\u001a\u000e\u0010*\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u000e\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-\u001a\u0012\u0010.\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a\u000e\u0010/\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0010\u00100\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a.\u00101\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010%\u001a\u0004\u0018\u00010!2\b\u00102\u001a\u0004\u0018\u00010!2\b\u00103\u001a\u0004\u0018\u00010!H\u0002\u001a\u0012\u00104\u001a\u0004\u0018\u00010\u00022\b\u00105\u001a\u0004\u0018\u00010\u0002\u001a\u0012\u00106\u001a\u0004\u0018\u00010\u00022\b\u00107\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u00108\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0018\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001d\u001a\u000e\u0010>\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u001c\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020A0@*\u00020-\u001a\u0010\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130C*\u00020-\"\u000e\u0010'\u001a\u00020!X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010D\u001a\u00020\u0001*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010F\"\u0015\u0010G\u001a\u00020\u0001*\u00020!8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\"\u0015\u0010I\u001a\u00020\u0001*\u00020!8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010H\u00a8\u0006J"}, d2={"isInKotlinSources", "", "Lcom/sun/jdi/Location;", "Lcom/sun/jdi/ReferenceType;", "isInKotlinSourcesAsync", "Ljava/util/concurrent/CompletableFuture;", "containsKotlinStrata", "containsKotlinStrataAsync", "isInsideInlineArgument", "inlineArgument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "location", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/sun/jdi/Location;Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isInlinedArgument", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/sun/jdi/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "localVariables", "", "Lcom/sun/jdi/LocalVariable;", "(Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function1;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "lambdaOrdinalByArgument", "", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionNameByArgument", "", "argument", "visibleVariables", "lambdaOrdinalByLocalVariable", "name", "functionNameByLocalVariable", "INVOKE_SUSPEND_SIGNATURE", "isOnSuspensionPoint", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "isInSuspendMethod", "isInvokeSuspendMethod", "method", "Lcom/sun/jdi/Method;", "getFirstMethodLocation", "isOnSuspendReturnOrReenter", "doesMethodHaveSwitcher", "checkContinuationLabelField", "descriptor", "owner", "getLocationOfCoroutineSuspendReturn", "resumedLocation", "getLocationOfNextInstructionAfterResume", "resumeLocation", "isOneLineMethod", "findElementAtLine", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "isKotlinFakeLineNumber", "getInlineFunctionAndArgumentVariablesToBordersMap", "", "Lkotlin/ranges/ClosedRange;", "getInlineFunctionOrArgumentVariables", "Lkotlin/sequences/Sequence;", "canRunEvaluation", "getCanRunEvaluation", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)Z", "isInlineFunctionMarkerVariableName", "(Ljava/lang/String;)Z", "isInlineLambdaMarkerVariableName", "kotlin.jvm-debugger.core"})
@JvmName(name="DebuggerUtil")
@SourceDebugExtension(value={"SMAP\ndebuggerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,556:1\n1557#2:557\n1628#2,3:558\n774#2:561\n865#2,2:562\n1611#2,9:564\n1863#2:573\n1755#2,3:574\n1864#2:578\n1620#2:579\n1557#2:581\n1628#2,3:582\n1755#2,3:585\n1#3:577\n1#3:580\n*S KotlinDebug\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n*L\n91#1:557\n91#1:558,3\n92#1:561\n92#1:562,2\n476#1:564,9\n476#1:573\n478#1:574,3\n476#1:578\n476#1:579\n99#1:581\n99#1:582,3\n100#1:585,3\n476#1:577\n*E\n"})
public final class DebuggerUtil {
    @NotNull
    private static final String INVOKE_SUSPEND_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";

    public static final boolean isInKotlinSources(@NotNull Location $this$isInKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
        ReferenceType referenceType = $this$isInKotlinSources.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
        return DebuggerUtil.isInKotlinSources(referenceType);
    }

    public static final boolean isInKotlinSources(@NotNull ReferenceType $this$isInKotlinSources) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
                string = SafeUtilKt.safeSourceName($this$isInKotlinSources);
                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) break block2;
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        String fileExtension = string;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(fileExtension) || DebuggerUtil.containsKotlinStrata($this$isInKotlinSources);
    }

    @NotNull
    public static final CompletableFuture<Boolean> isInKotlinSourcesAsync(@NotNull ReferenceType $this$isInKotlinSourcesAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSourcesAsync, (String)"<this>");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)DebuggerUtilsAsync.sourceName((ReferenceType)$this$isInKotlinSourcesAsync).thenApply(arg_0 -> DebuggerUtil.isInKotlinSourcesAsync$lambda$1(DebuggerUtil::isInKotlinSourcesAsync$lambda$0, arg_0))).exceptionally(DebuggerUtil::isInKotlinSourcesAsync$lambda$2)).thenCombine(DebuggerUtil.containsKotlinStrataAsync($this$isInKotlinSourcesAsync), (arg_0, arg_1) -> DebuggerUtil.isInKotlinSourcesAsync$lambda$4(DebuggerUtil::isInKotlinSourcesAsync$lambda$3, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCombine(...)");
        return completionStage;
    }

    public static final boolean containsKotlinStrata(@NotNull ReferenceType $this$containsKotlinStrata) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrata, (String)"<this>");
        return $this$containsKotlinStrata.availableStrata().contains("Kotlin");
    }

    @NotNull
    public static final CompletableFuture<Boolean> containsKotlinStrataAsync(@NotNull ReferenceType $this$containsKotlinStrataAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrataAsync, (String)"<this>");
        CompletionStage completionStage = DebuggerUtilsAsync.availableStrata((ReferenceType)$this$containsKotlinStrataAsync).thenApply(arg_0 -> DebuggerUtil.containsKotlinStrataAsync$lambda$6(DebuggerUtil::containsKotlinStrataAsync$lambda$5, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Nullable
    public static final Object isInsideInlineArgument(@NotNull KtExpression inlineArgument, @NotNull Location location, @NotNull DebugProcessImpl debugProcess, @NotNull Continuation<? super Boolean> $completion) {
        return DebuggerUtil.isInlinedArgument(DebuggerUtil.visibleVariables(location, debugProcess), inlineArgument, $completion);
    }

    @Nullable
    public static final Object isInlinedArgument(@NotNull KtExpression inlineArgument, @NotNull Location location, @NotNull Continuation<? super Boolean> $completion) {
        Method method = location.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        List list2 = SafeUtilKt.safeVariables(method);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return DebuggerUtil.isInlinedArgument(list2, inlineArgument, $completion);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object isInlinedArgument(List<? extends LocalVariable> localVariables, KtExpression inlineArgument, Continuation<? super Boolean> $completion) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (!(inlineArgument instanceof KtFunction) && !(inlineArgument instanceof KtCallableReferenceExpression)) {
            return Boxing.boxBoolean((boolean)false);
        }
        Iterable iterable = localVariables;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LocalVariable localVariable = (LocalVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!StringsKt.startsWith$default((String)it, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List markerLocalVariables = (List)destination$iv$iv;
        return CoroutinesKt.readAction(() -> DebuggerUtil.isInlinedArgument$lambda$12(inlineArgument, markerLocalVariables), $completion);
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull DebugProcessImpl $this$invokeInManagerThread, @NotNull Function1<? super DebuggerContextImpl, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (DebuggerManagerThreadImpl.Companion.isManagerThread()) {
            DebuggerContextImpl debuggerContextImpl = $this$invokeInManagerThread.getDebuggerContext();
            Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
            return (T)f.invoke((Object)debuggerContextImpl);
        }
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        DebuggerContextImpl debuggerContextImpl = $this$invokeInManagerThread.getDebuggerContext();
        $this$invokeInManagerThread.getManagerThread().invokeAndWait((DebuggerCommandImpl)new DebuggerContextCommandImpl(result2, f, debuggerContextImpl){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function1<DebuggerContextImpl, T> $f;
            {
                this.$result = $result;
                this.$f = $f;
                super($super_call_param$1);
            }

            public void threadAction(SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                DebuggerContextImpl debuggerContextImpl = this.getDebuggerContext();
                Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
                this.$result.element = this.$f.invoke((Object)debuggerContextImpl);
            }
        });
        return (T)result2.element;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt) {
        String string = ClassNameCalculator.Companion.getClassName((KtElement)elementAt);
        if (string == null) {
            return 0;
        }
        String className = string;
        Integer n = StringsKt.toIntOrNull((String)StringsKt.substringAfterLast$default((String)className, (String)"$", null, (int)2, null));
        return n != null ? n : 0;
    }

    private static final String functionNameByArgument(KtExpression argument2) {
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)argument2, null, arg_0 -> DebuggerUtil.functionNameByArgument$lambda$13(argument2, arg_0));
    }

    private static final List<LocalVariable> visibleVariables(Location $this$visibleVariables, DebugProcessImpl debugProcess) {
        VirtualMachine virtualMachine = debugProcess.getVirtualMachineProxy().getVirtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
        MockStackFrame stackFrame = new MockStackFrame($this$visibleVariables, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name2) {
        int n;
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
            n = Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        return n;
    }

    private static final String functionNameByLocalVariable(String name2) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final boolean isOnSuspensionPoint(@NotNull StackFrameProxyImpl $this$isOnSuspensionPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnSuspensionPoint, (String)"<this>");
        Location location = SafeUtilKt.safeLocation((StackFrameProxy)$this$isOnSuspensionPoint);
        if (location == null) {
            return false;
        }
        Location location2 = location;
        if (DebuggerUtil.isInSuspendMethod(location2)) {
            Location location3 = DebuggerUtil.getFirstMethodLocation(location2);
            if (location3 == null) {
                return false;
            }
            Location firstLocation = location3;
            return SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location2) && firstLocation.codeIndex() != location2.codeIndex();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInSuspendMethod(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Method method = location.method();
        String signature = method.signature();
        Intrinsics.checkNotNull((Object)signature);
        CharSequence charSequence = signature;
        String string = CoroutineUtilsKt.getCONTINUATION_TYPE().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) return true;
        Intrinsics.checkNotNull((Object)method);
        if (!DebuggerUtil.isInvokeSuspendMethod(method)) return false;
        return true;
    }

    public static final boolean isInvokeSuspendMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)method.signature(), (Object)INVOKE_SUSPEND_SIGNATURE);
    }

    private static final Location getFirstMethodLocation(Location location) {
        Mirror mirror = SafeUtilKt.safeMethod(location);
        if (mirror == null || (mirror = mirror.location()) == null) {
            return null;
        }
        Mirror firstLocation = mirror;
        if (SafeUtilKt.safeLineNumber((Location)firstLocation) < 0) {
            return null;
        }
        return firstLocation;
    }

    public static final boolean isOnSuspendReturnOrReenter(@NotNull Location location) {
        boolean isAtFirstLine;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Location location2 = DebuggerUtil.getFirstMethodLocation(location);
        if (location2 == null) {
            return false;
        }
        Location firstLocation = location2;
        boolean bl = isAtFirstLine = SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location);
        if (isAtFirstLine) {
            return DebuggerUtil.doesMethodHaveSwitcher(location);
        }
        return false;
    }

    private static final boolean doesMethodHaveSwitcher(Location location) {
        VirtualMachine virtualMachine = location.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return false;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        MethodBytecodeUtil.visit((Method)location.method(), (MethodVisitor)new MethodVisitor(result2, location){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ Location $location;
            {
                this.$result = $result;
                this.$location = $location;
                super(589824);
            }

            public void visitFieldInsn(int opcode, String owner, String name2, String descriptor2) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (!this.$result.element && DebuggerUtil.access$checkContinuationLabelField(this.$location, name2, descriptor2, owner)) {
                    this.$result.element = true;
                }
            }
        }, (boolean)false);
        return result2.element;
    }

    private static final boolean checkContinuationLabelField(Location location, String name2, String descriptor2, String owner) {
        if (name2 == null || descriptor2 == null || owner == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"label") && Intrinsics.areEqual((Object)descriptor2, (Object)"I")) {
            String className = Type.getObjectType((String)owner).getClassName();
            String methodClassName = location.method().declaringType().name();
            if (DebuggerUtil.isInSuspendMethod(location)) {
                Intrinsics.checkNotNull((Object)className);
                Intrinsics.checkNotNull((Object)methodClassName);
                if (StringsKt.startsWith$default((String)className, (String)methodClassName, (boolean)false, (int)2, null)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static final Location getLocationOfCoroutineSuspendReturn(@Nullable Location resumedLocation) {
        Comparable<Location> comparable = resumedLocation;
        if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return null;
        }
        Comparable<Location> resumedMethod = comparable;
        VirtualMachine virtualMachine = resumedMethod.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return null;
        }
        CoroutineStateMachineVisitor visitor2 = new CoroutineStateMachineVisitor((Method)resumedMethod, resumedLocation);
        MethodBytecodeUtil.visit(resumedMethod, (MethodVisitor)((MethodVisitor)visitor2), (boolean)true);
        return resumedMethod.locationOfCodeIndex(visitor2.getFirstReturnAfterSuspensionOffset());
    }

    @Nullable
    public static final Location getLocationOfNextInstructionAfterResume(@Nullable Location resumeLocation) {
        Comparable<Location> comparable = resumeLocation;
        if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return null;
        }
        Comparable<Location> resumedMethod = comparable;
        VirtualMachine virtualMachine = resumedMethod.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return null;
        }
        CoroutineStateMachineVisitor visitor2 = new CoroutineStateMachineVisitor((Method)resumedMethod, resumeLocation);
        MethodBytecodeUtil.visit(resumedMethod, (MethodVisitor)((MethodVisitor)visitor2), (boolean)true);
        return resumedMethod.locationOfCodeIndex(visitor2.getNextCallOffset());
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean isOneLineMethod(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        v0 = SafeUtilKt.safeMethod(location);
        if (v0 == null) {
            return false;
        }
        method = v0;
        allLineLocations = SafeUtilKt.safeAllLineLocations(method);
        if (allLineLocations.isEmpty()) {
            return false;
        }
        if (allLineLocations.size() == 1) {
            return true;
        }
        inlineFunctionBorders = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method).values();
        var4_4 = allLineLocations;
        $i$f$mapNotNull = false;
        var6_6 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var11_11 = $this$forEach$iv$iv$iv.iterator();
        while (var11_11.hasNext()) {
            block9: {
                element$iv$iv = element$iv$iv$iv = var11_11.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                loc = (Location)element$iv$iv;
                $i$a$-mapNotNull-DebuggerUtil$isOneLineMethod$1 = false;
                if (DebuggerUtil.isKotlinFakeLineNumber(loc)) ** GOTO lbl-1000
                $this$any$iv = inlineFunctionBorders;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (ClosedRange)element$iv;
                        $i$a$-any-DebuggerUtil$isOneLineMethod$1$1 = false;
                        if (!it.contains((Comparable)loc)) continue;
                        v1 = true;
                        break block9;
                    }
                    v1 = false;
                }
            }
            if (!v1) {
                v2 = loc.lineNumber();
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    @Nullable
    public static final PsiElement findElementAtLine(@NotNull KtFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, line);
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file, line);
        if (n2 == null) {
            return null;
        }
        int lineEndOffset = n2;
        return (PsiElement)ActionsKt.runReadAction(() -> DebuggerUtil.findElementAtLine$lambda$16(lineStartOffset, lineEndOffset, file));
    }

    public static final boolean isKotlinFakeLineNumber(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        try {
            if (location.lineNumber("Kotlin") == 1 && Intrinsics.areEqual((Object)location.sourceName("Kotlin"), (Object)"fake.kt") && Intrinsics.areEqual((Object)Path.of(location.sourcePath("Kotlin"), new String[0]), (Object)Path.of("kotlin/jvm/internal/FakeKt", new String[0]))) {
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public static final Map<LocalVariable, ClosedRange<Location>> getInlineFunctionAndArgumentVariablesToBordersMap(@NotNull Method $this$getInlineFunctionAndArgumentVariablesToBordersMap) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionAndArgumentVariablesToBordersMap, (String)"<this>");
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionAndArgumentVariablesToBordersMap), DebuggerUtil::getInlineFunctionAndArgumentVariablesToBordersMap$lambda$17));
    }

    @NotNull
    public static final Sequence<LocalVariable> getInlineFunctionOrArgumentVariables(@NotNull Method $this$getInlineFunctionOrArgumentVariables) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionOrArgumentVariables, (String)"<this>");
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionOrArgumentVariables);
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<LocalVariable> localVariables = list2;
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)localVariables), DebuggerUtil::getInlineFunctionOrArgumentVariables$lambda$18);
    }

    public static final boolean getCanRunEvaluation(@NotNull DebugProcessImpl $this$canRunEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$canRunEvaluation, (String)"<this>");
        return $this$canRunEvaluation.getSuspendManager().getPausedContext() != null;
    }

    public static final boolean isInlineFunctionMarkerVariableName(@NotNull String $this$isInlineFunctionMarkerVariableName) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineFunctionMarkerVariableName, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isInlineFunctionMarkerVariableName, (String)"$i$f$", (boolean)false, (int)2, null);
    }

    public static final boolean isInlineLambdaMarkerVariableName(@NotNull String $this$isInlineLambdaMarkerVariableName) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineLambdaMarkerVariableName, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isInlineLambdaMarkerVariableName, (String)"$i$a$", (boolean)false, (int)2, null);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$0(String it) {
        String string;
        block3: {
            block2: {
                string = it;
                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) break block2;
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        String fileExtension = string;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(fileExtension);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$2(Throwable it) {
        if (!(DebuggerUtilsAsync.unwrap((Throwable)it) instanceof AbsentInformationException)) {
            throw it;
        }
        return false;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$3(Boolean kotlinExt, Boolean kotlinStrata) {
        return kotlinExt != false || kotlinStrata != false;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final Boolean containsKotlinStrataAsync$lambda$5(List it) {
        return it.contains("Kotlin");
    }

    private static final Boolean containsKotlinStrataAsync$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isInlinedArgument$lambda$12(KtExpression $inlineArgument, List $markerLocalVariables) {
        boolean bl;
        block11: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string;
            Integer lambdaOrdinal;
            KtFunction ktFunction = $inlineArgument instanceof KtFunction ? (KtFunction)$inlineArgument : null;
            if (ktFunction != null) {
                KtFunction it = ktFunction;
                boolean bl2 = false;
                v1 = DebuggerUtil.lambdaOrdinalByArgument(it);
            } else {
                v1 = lambdaOrdinal = null;
            }
            if ((string = DebuggerUtil.functionNameByArgument($inlineArgument)) == null) {
                string = "unknown";
            }
            String functionName = string;
            Iterable iterable = $markerLocalVariables;
            boolean $i$f$map = false;
            void bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(StringsKt.drop((String)it, (int)5));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl4;
                    String variableName = (String)element$iv;
                    boolean bl5 = false;
                    if (StringsKt.startsWith$default((String)variableName, (String)"-", (boolean)false, (int)2, null)) {
                        String string3 = ClassNameCalculator.Companion.getClassName((KtElement)$inlineArgument);
                        if (string3 == null || (string3 = StringsKt.substringAfterLast$default((String)string3, (char)'.', null, (int)2, null)) == null) {
                            bl4 = false;
                        } else {
                            String lambdaClassName = string3;
                            bl4 = Intrinsics.areEqual((Object)InlineScopeUtilsKt.dropInlineScopeInfo((String)InlineUtilsKt.dropInlineSuffix(variableName)), (Object)("-" + functionName + "-" + lambdaClassName));
                        }
                    } else {
                        Integer n = lambdaOrdinal;
                        bl4 = n != null && DebuggerUtil.lambdaOrdinalByLocalVariable(variableName) == n && Intrinsics.areEqual((Object)DebuggerUtil.functionNameByLocalVariable(variableName), (Object)functionName);
                    }
                    if (!bl4) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String functionNameByArgument$lambda$13(KtExpression $argument, KaSession $this$f) {
        Intrinsics.checkNotNullParameter((Object)$this$f, (String)"$this$f");
        KaFunctionSymbol kaFunctionSymbol = org.jetbrains.kotlin.idea.codeinsight.utils.InlineUtilsKt.getFunctionSymbol($this$f, $argument);
        KaNamedFunctionSymbol kaNamedFunctionSymbol = kaFunctionSymbol instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaFunctionSymbol : null;
        if (kaNamedFunctionSymbol == null) {
            return null;
        }
        KaNamedFunctionSymbol function = kaNamedFunctionSymbol;
        return function.getName().asString();
    }

    private static final PsiElement findElementAtLine$lambda$16(int $lineStartOffset, int $lineEndOffset, KtFile $file) {
        PsiElement topMostElement = null;
        PsiElement elementAt = null;
        for (int offset = $lineStartOffset; !(offset >= $lineEndOffset || (elementAt = $file.findElementAt(offset)) != null && (topMostElement = KotlinPsiUtils.getTopmostElementAtOffset(elementAt, offset)) instanceof KtElement); ++offset) {
        }
        return topMostElement;
    }

    private static final Pair getInlineFunctionAndArgumentVariablesToBordersMap$lambda$17(LocalVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClosedRange<Location> borders = DebuggerUtils.INSTANCE.getBorders(it);
        return borders == null ? null : TuplesKt.to((Object)it, borders);
    }

    private static final boolean getInlineFunctionOrArgumentVariables$lambda$18(LocalVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return JvmAbi.isFakeLocalVariableForInline((String)string);
    }

    public static final /* synthetic */ boolean access$checkContinuationLabelField(Location location, String name2, String descriptor2, String owner) {
        return DebuggerUtil.checkContinuationLabelField(location, name2, descriptor2, owner);
    }

    public static final /* synthetic */ Object access$isInlinedArgument(List localVariables, KtExpression inlineArgument, Continuation $completion) {
        return DebuggerUtil.isInlinedArgument(localVariables, inlineArgument, (Continuation<? super Boolean>)$completion);
    }
}

