/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\b\u0004\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\"\u0010\t\u001a\u00020\u00042\u0018\u0010\n\u001a\u00140\u000bR\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fH\u0014J\u0016\u0010\t\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u001f\u001a\u00020\u0019*\u00020 H\u0004R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "id", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "()V", "getGeneralDescription", "variant", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaMethodBreakpointProperties;", "kotlin.jvm.PlatformType", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getPriority", "", "createJavaBreakpoint", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "isKtFileWithCommonOrJvmPlatform", "isFunctionBreakpointApplicable", "isComposable", "Lorg/jetbrains/kotlin/psi/KtFunction;", "COMPOSABLE_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.jvm-debugger.core"})
public class KotlinFunctionBreakpointType
extends JavaMethodBreakpointType
implements KotlinBreakpointType {
    @NotNull
    private final FqName COMPOSABLE_FQ_NAME;

    protected KotlinFunctionBreakpointType(@NotNull String id, @Nls @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(id, message2);
        this.COMPOSABLE_FQ_NAME = new FqName("androidx.compose.runtime.Composable");
    }

    public KotlinFunctionBreakpointType() {
        this("kotlin-function", KotlinDebuggerCoreBundle.message("function.breakpoint.tab.title", new Object[0]));
    }

    @NotNull
    protected String getGeneralDescription(@NotNull XLineBreakpointType.XLineBreakpointVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return KotlinDebuggerCoreBundle.message("function.breakpoint.description", new Object[0]);
    }

    @NotNull
    public String getGeneralDescription(@NotNull XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return KotlinDebuggerCoreBundle.message("function.breakpoint.description", new Object[0]);
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public KotlinFunctionBreakpoint createJavaBreakpoint(@NotNull Project project, @NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return new KotlinFunctionBreakpoint(project, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.isKtFileWithCommonOrJvmPlatform(file, project) && this.isFunctionBreakpointApplicable(file, line, project);
    }

    private final boolean isKtFileWithCommonOrJvmPlatform(VirtualFile file, Project project) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return false;
        }
        KtFile psiFile2 = ktFile2;
        TargetPlatform platform = TargetPlatformDetectorUtils.getPlatform((KtElement)psiFile2);
        return TargetPlatformKt.isCommon((TargetPlatform)platform) || JvmPlatformKt.isJvm((TargetPlatform)platform);
    }

    public boolean isFunctionBreakpointApplicable(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file, line, project, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)arg_0 -> KotlinFunctionBreakpointType.isFunctionBreakpointApplicable$lambda$0(this, arg_0)));
    }

    protected final boolean isComposable(@NotNull KtFunction $this$isComposable) {
        Intrinsics.checkNotNullParameter((Object)$this$isComposable, (String)"<this>");
        return KotlinPsiHeuristics.hasAnnotation$default((KtAnnotated)$this$isComposable, this.COMPOSABLE_FQ_NAME, null, 4, null);
    }

    private static final ApplicabilityResult isFunctionBreakpointApplicable$lambda$0(KotlinFunctionBreakpointType this$0, PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        return psiElement instanceof KtConstructor ? ApplicabilityResult.DEFINITELY_YES : (psiElement instanceof KtFunction ? ApplicabilityResult.Companion.maybe(!KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)element)) && !BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)element) && !this$0.isComposable((KtFunction)element)) : (psiElement instanceof KtPropertyAccessor ? ApplicabilityResult.Companion.maybe(((KtPropertyAccessor)element).hasBody() && !KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)((KtPropertyAccessor)element).getProperty()))) : (psiElement instanceof KtClass ? ApplicabilityResult.Companion.maybe(!(element instanceof KtEnumEntry) && !((KtClass)element).isAnnotation() && !((KtClass)element).isInterface() && ((KtClass)element).hasPrimaryConstructor()) : ApplicabilityResult.UNKNOWN)));
    }
}

