/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ExistingVariables;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.PendingValue;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ThisLabelUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001a\u0010\u0006\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a%\u0010\u000f\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0082\u0010\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"attachCapturedValues", "", "containerValue", "Lcom/sun/jdi/ObjectReference;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/ExistingVariables;", "collector", "Lkotlin/Function1;", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "collectPendingValues", "", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue;", "container", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/PendingValue$Container;", "collectValuesBfs", "queue", "Ljava/util/Deque;", "consumer", "", "createPendingValue", "field", "Lcom/sun/jdi/Field;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nCapturedValuesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturedValuesSearcher.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/CapturedValuesSearcherKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class CapturedValuesSearcherKt {
    public static final void attachCapturedValues(@NotNull ObjectReference containerValue, @NotNull ExistingVariables existingVariables, @NotNull Function1<? super DescriptorData<? extends ValueDescriptorImpl>, Unit> collector2) {
        Intrinsics.checkNotNullParameter((Object)containerValue, (String)"containerValue");
        Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
        Intrinsics.checkNotNullParameter(collector2, (String)"collector");
        List<PendingValue> values2 = CapturedValuesSearcherKt.collectPendingValues(new PendingValue.Container(containerValue));
        for (PendingValue value : values2) {
            DescriptorData<? extends ValueDescriptorImpl> descriptorData;
            if (value.addTo(existingVariables) == null) continue;
            collector2.invoke(descriptorData);
        }
    }

    private static final List<PendingValue> collectPendingValues(PendingValue.Container container) {
        ArrayDeque<PendingValue.Container> queue = new ArrayDeque<PendingValue.Container>();
        queue.offer(container);
        List values2 = new ArrayList();
        CapturedValuesSearcherKt.collectValuesBfs((Deque<PendingValue>)queue, values2);
        return values2;
    }

    private static final void collectValuesBfs(Deque<PendingValue> queue, List<PendingValue> consumer) {
        while (true) {
            ArrayDeque deeperValues = new ArrayDeque();
            while (!((Collection)queue).isEmpty() && queue.removeFirst() != null) {
                PendingValue value;
                if (value instanceof PendingValue.Container) {
                    List<PendingValue> children = ((PendingValue.Container)value).getChildren();
                    deeperValues.addAll(children);
                    continue;
                }
                ((Collection)consumer).add(value);
            }
            if (!(!((Collection)deeperValues).isEmpty())) break;
            List<PendingValue> list2 = consumer;
            queue = deeperValues;
            consumer = list2;
        }
    }

    private static final PendingValue createPendingValue(PendingValue.Container container, Field field2) {
        String string;
        String name2 = field2.name();
        if (Intrinsics.areEqual((Object)name2, (Object)"this$0")) {
            Value value = container.getValue().getValue(field2);
            ObjectReference objectReference = value instanceof ObjectReference ? (ObjectReference)value : null;
            if (objectReference == null) {
                return null;
            }
            ObjectReference value2 = objectReference;
            String label2 = ThisLabelUtilsKt.getThisValueLabel(value2);
            return label2 == null ? (PendingValue)new PendingValue.Container(value2) : (PendingValue)new PendingValue.This(label2, value2);
        }
        Intrinsics.checkNotNull((Object)name2);
        if (StringsKt.startsWith$default((String)name2, (String)"$this_", (boolean)false, (int)2, null)) {
            String string2;
            Value value = container.getValue().getValue(field2);
            String it = string2 = StringsKt.drop((String)name2, (int)6);
            boolean bl = false;
            String string3 = ((CharSequence)it).length() > 0 ? string2 : null;
            if (string3 == null) {
                return null;
            }
            String label3 = string3;
            return new PendingValue.This(label3, value);
        }
        boolean value = StringsKt.startsWith$default((String)name2, (String)"$", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !value) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        String it = string = StringsKt.removeSuffix((String)StringsKt.drop((String)name2, (int)1), (CharSequence)"$inlined");
        boolean bl = false;
        String string5 = ((CharSequence)it).length() > 0 ? string : null;
        if (string5 == null) {
            return null;
        }
        String capturedValueName = string5;
        return new PendingValue.Ordinary(capturedValueName, field2, container);
    }

    public static final /* synthetic */ PendingValue access$createPendingValue(PendingValue.Container container, Field field2) {
        return CapturedValuesSearcherKt.createPendingValue(container, field2);
    }
}

