/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.SimpleDisplayKey;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/LabeledThisData;", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "label", "", "name", "value", "Lcom/sun/jdi/Value;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getLabel", "()Ljava/lang/String;", "getName", "getValue", "()Lcom/sun/jdi/Value;", "createDescriptorImpl", "project", "Lcom/intellij/openapi/project/Project;", "getDisplayKey", "Lcom/intellij/debugger/impl/descriptors/data/DisplayKey;", "equals", "", "other", "", "hashCode", "", "kotlin.jvm-debugger.core"})
public final class LabeledThisData
extends DescriptorData<ValueDescriptorImpl> {
    @NotNull
    private final String label;
    @NotNull
    private final String name;
    @Nullable
    private final Value value;

    public LabeledThisData(@NotNull String label2, @NotNull String name2, @Nullable Value value) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.label = label2;
        this.name = name2;
        this.value = value;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Value getValue() {
        return this.value;
    }

    @NotNull
    protected ValueDescriptorImpl createDescriptorImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Value value = this.value;
        return new ValueDescriptorImpl(project, this, value){
            final /* synthetic */ LabeledThisData this$0;
            {
                this.this$0 = $receiver;
                super($project, $super_call_param$1);
            }

            public String getName() {
                return this.this$0.getName();
            }

            public Value calcValue(EvaluationContextImpl evaluationContext) {
                return this.getValue();
            }

            public boolean canSetValue() {
                return false;
            }

            public PsiExpression getDescriptorEvaluation(DebuggerContext context2) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
                try {
                    PsiExpression psiExpression = elementFactory.createExpressionFromText("this", null);
                    Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
                    return psiExpression;
                }
                catch (IncorrectOperationException e) {
                    throw new EvaluateException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    @NotNull
    public DisplayKey<ValueDescriptorImpl> getDisplayKey() {
        return (DisplayKey)new SimpleDisplayKey((Object)this);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof LabeledThisData && Intrinsics.areEqual((Object)((LabeledThisData)((Object)other)).name, (Object)this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

