/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror;

import com.intellij.debugger.engine.JavaValue;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.DefaultCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolderKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.LocationCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfBaseContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfStackFrame;", "", "that", "Lcom/sun/jdi/ObjectReference;", "baseContinuationImpl", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfBaseContinuationImpl;", "<init>", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfBaseContinuationImpl;)V", "getThat", "()Lcom/sun/jdi/ObjectReference;", "getBaseContinuationImpl", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfBaseContinuationImpl;", "toCoroutineStackFrameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "locationCache", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LocationCache;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.coroutines"})
public final class MirrorOfStackFrame {
    @NotNull
    private final ObjectReference that;
    @NotNull
    private final MirrorOfBaseContinuationImpl baseContinuationImpl;

    public MirrorOfStackFrame(@NotNull ObjectReference that, @NotNull MirrorOfBaseContinuationImpl baseContinuationImpl) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        Intrinsics.checkNotNullParameter((Object)baseContinuationImpl, (String)"baseContinuationImpl");
        this.that = that;
        this.baseContinuationImpl = baseContinuationImpl;
    }

    @NotNull
    public final ObjectReference getThat() {
        return this.that;
    }

    @NotNull
    public final MirrorOfBaseContinuationImpl getBaseContinuationImpl() {
        return this.baseContinuationImpl;
    }

    @Nullable
    public final CoroutineStackFrameItem toCoroutineStackFrameItem(@NotNull DefaultExecutionContext context2, @NotNull LocationCache locationCache) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)locationCache, (String)"locationCache");
        Object object = this.baseContinuationImpl.getStackTraceElement();
        if (object == null || (object = ((MirrorOfStackTraceElement)object).stackTraceElement()) == null) {
            return null;
        }
        Object stackTraceElement = object;
        Location generatedLocation = locationCache.createLocation((StackTraceElement)stackTraceElement);
        List<JavaValue> spilledVariables = ContinuationHolderKt.spilledValues(this.baseContinuationImpl, context2);
        return new DefaultCoroutineStackFrameItem(generatedLocation, spilledVariables);
    }

    @NotNull
    public final ObjectReference component1() {
        return this.that;
    }

    @NotNull
    public final MirrorOfBaseContinuationImpl component2() {
        return this.baseContinuationImpl;
    }

    @NotNull
    public final MirrorOfStackFrame copy(@NotNull ObjectReference that, @NotNull MirrorOfBaseContinuationImpl baseContinuationImpl) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        Intrinsics.checkNotNullParameter((Object)baseContinuationImpl, (String)"baseContinuationImpl");
        return new MirrorOfStackFrame(that, baseContinuationImpl);
    }

    public static /* synthetic */ MirrorOfStackFrame copy$default(MirrorOfStackFrame mirrorOfStackFrame, ObjectReference objectReference, MirrorOfBaseContinuationImpl mirrorOfBaseContinuationImpl, int n, Object object) {
        if ((n & 1) != 0) {
            objectReference = mirrorOfStackFrame.that;
        }
        if ((n & 2) != 0) {
            mirrorOfBaseContinuationImpl = mirrorOfStackFrame.baseContinuationImpl;
        }
        return mirrorOfStackFrame.copy(objectReference, mirrorOfBaseContinuationImpl);
    }

    @NotNull
    public String toString() {
        return "MirrorOfStackFrame(that=" + this.that + ", baseContinuationImpl=" + this.baseContinuationImpl + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.that).hashCode();
        result2 = result2 * 31 + this.baseContinuationImpl.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MirrorOfStackFrame)) {
            return false;
        }
        MirrorOfStackFrame mirrorOfStackFrame = (MirrorOfStackFrame)other;
        if (!Intrinsics.areEqual((Object)this.that, (Object)mirrorOfStackFrame.that)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.baseContinuationImpl, (Object)mirrorOfStackFrame.baseContinuationImpl);
    }
}

