/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixUpdater;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.idea.highlighter.IdeErrorMessages;
import org.jetbrains.kotlin.idea.highlighter.RegisterQuickFixesLaterIntentionAction;
import org.jetbrains.kotlin.idea.inspections.suppress.CompilerWarningIntentionAction;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressableWarningProblemGroup;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJN\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010)H\u0002JJ\u0010*\u001a\u00020\u00162\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020!0 2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010%2\b\u0010-\u001a\u0004\u0018\u00010\u001e2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0010\u00100\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u001bH\u0003J\u0010\u00101\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u001bH\u0002J\u001a\u00102\u001a\u0002032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u000205H\u0002J\u001a\u00106\u001a\u0002032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u000205H\u0002J\u001c\u00107\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u000205H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo;", "", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "nonDefaultMessage", "", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "textAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "<init>", "(Ljava/util/List;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;Lcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "getRanges", "()Ljava/util/List;", "getNonDefaultMessage", "()Ljava/lang/String;", "getHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "getTextAttributes", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "processDiagnostics", "", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "highlightInfoByDiagnostic", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "fixesMap", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "calculatingInProgress", "", "create", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "diagnostic", "range", "group", "Lorg/jetbrains/kotlin/idea/inspections/suppress/KotlinSuppressableWarningProblemGroup;", "applyFixes", "quickFixes", "builder", "highlightInfo", "problemGroup", "Lcom/intellij/lang/annotation/ProblemGroup;", "getMessage", "getDefaultMessage", "toHighlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "convertSeverity", "convertSeverityTextAttributes", "Companion", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nAnnotationPresentationInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationPresentationInfo.kt\norg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,216:1\n1#2:217\n1#2:228\n11483#3,9:218\n13409#3:227\n13410#3:229\n11492#3:230\n81#4:231\n73#4:232\n81#4:233\n73#4:234\n*S KotlinDebug\n*F\n+ 1 AnnotationPresentationInfo.kt\norg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo\n*L\n144#1:228\n144#1:218,9\n144#1:227\n144#1:229\n144#1:230\n157#1:231\n157#1:232\n174#1:233\n174#1:234\n*E\n"})
public final class AnnotationPresentationInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TextRange> ranges;
    @Nullable
    private final String nonDefaultMessage;
    @Nullable
    private final ProblemHighlightType highlightType;
    @Nullable
    private final TextAttributesKey textAttributes;
    @NotNull
    private static final String KOTLIN_COMPILER_WARNING_ID = "KotlinCompilerWarningOptions";

    public AnnotationPresentationInfo(@NotNull List<? extends TextRange> ranges, @Nls @Nullable String nonDefaultMessage, @Nullable ProblemHighlightType highlightType, @Nullable TextAttributesKey textAttributes) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.ranges = ranges;
        this.nonDefaultMessage = nonDefaultMessage;
        this.highlightType = highlightType;
        this.textAttributes = textAttributes;
    }

    public /* synthetic */ AnnotationPresentationInfo(List list2, String string, ProblemHighlightType problemHighlightType, TextAttributesKey textAttributesKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            problemHighlightType = null;
        }
        if ((n & 8) != 0) {
            textAttributesKey = null;
        }
        this(list2, string, problemHighlightType, textAttributesKey);
    }

    @NotNull
    public final List<TextRange> getRanges() {
        return this.ranges;
    }

    @Nullable
    public final String getNonDefaultMessage() {
        return this.nonDefaultMessage;
    }

    @Nullable
    public final ProblemHighlightType getHighlightType() {
        return this.highlightType;
    }

    @Nullable
    public final TextAttributesKey getTextAttributes() {
        return this.textAttributes;
    }

    public final void processDiagnostics(@NotNull HighlightInfoHolder holder, @NotNull Collection<? extends Diagnostic> diagnostics, @Nullable Map<Diagnostic, HighlightInfo> highlightInfoByDiagnostic, @NotNull MultiMap<Diagnostic, IntentionAction> fixesMap, boolean calculatingInProgress) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Intrinsics.checkNotNullParameter(fixesMap, (String)"fixesMap");
        for (TextRange range2 : this.ranges) {
            for (Diagnostic diagnostic : diagnostics) {
                HighlightInfo highlightInfo;
                HighlightInfo existingInfo;
                KotlinSuppressableWarningProblemGroup group = diagnostic.getSeverity() == Severity.WARNING ? new KotlinSuppressableWarningProblemGroup(diagnostic.getFactory().getName()) : null;
                Map<Diagnostic, HighlightInfo> map = highlightInfoByDiagnostic;
                HighlightInfo highlightInfo2 = existingInfo = map != null ? map.get(diagnostic) : null;
                if (existingInfo != null) {
                    if (calculatingInProgress) continue;
                    this.applyFixes(fixesMap, diagnostic, range2, null, existingInfo, (ProblemGroup)group);
                    continue;
                }
                HighlightInfo.Builder builder2 = this.create(diagnostic, range2, group);
                if (!calculatingInProgress || !fixesMap.isEmpty()) {
                    this.applyFixes(fixesMap, diagnostic, range2, builder2, null, (ProblemGroup)group);
                }
                Intrinsics.checkNotNullExpressionValue((Object)builder2.createUnconditionally(), (String)"createUnconditionally(...)");
                holder.add(highlightInfo);
                Map<Diagnostic, HighlightInfo> map2 = highlightInfoByDiagnostic;
                if (map2 == null) continue;
                map2.put(diagnostic, highlightInfo);
            }
        }
    }

    private final HighlightInfo.Builder create(Diagnostic diagnostic, TextRange range2, KotlinSuppressableWarningProblemGroup group) {
        HighlightInfo.Builder builder2;
        HighlightInfo.Builder builder3;
        String string = this.nonDefaultMessage;
        if (string == null) {
            string = this.getDefaultMessage(diagnostic);
        }
        String message2 = string;
        TextAttributesKey textAttributesToApply = this.textAttributes != null ? this.textAttributes : this.convertSeverityTextAttributes(this.highlightType, diagnostic.getSeverity());
        HighlightInfo.Builder it = builder3 = HighlightInfo.newHighlightInfo((HighlightInfoType)this.toHighlightInfoType(this.highlightType, diagnostic.getSeverity())).range(range2).description(message2).escapedToolTip(this.getMessage(diagnostic));
        boolean bl = false;
        if (textAttributesToApply != null) {
            it.textAttributes(textAttributesToApply);
        }
        HighlightInfo.Builder builder4 = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"also(...)");
        HighlightInfo.Builder it2 = builder2 = builder4;
        boolean bl2 = false;
        if (group != null) {
            it2.problemGroup((ProblemGroup)group);
        }
        return builder2;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyFixes(MultiMap<Diagnostic, IntentionAction> quickFixes, Diagnostic diagnostic, TextRange range2, HighlightInfo.Builder builder2, HighlightInfo highlightInfo, ProblemGroup problemGroup) {
        boolean isWarning = diagnostic.getSeverity() == Severity.WARNING;
        PsiElement element = diagnostic.getPsiElement();
        Collection collection = quickFixes.get((Object)diagnostic);
        Collection it = collection;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Object object = !it.isEmpty() ? collection : null;
        if (object == null) {
            object = isWarning ? CollectionsKt.listOf((Object)((Object)new CompilerWarningIntentionAction(diagnostic.getFactory().getName()))) : CollectionsKt.emptyList();
        }
        Collection fixes = object;
        HighlightDisplayKey keyForSuppressOptions = isWarning ? HighlightDisplayKey.findOrRegister((String)KOTLIN_COMPILER_WARNING_ID, (String)KotlinBaseFe10HighlightingBundle.message("kotlin.compiler.warning", new Object[0])) : null;
        for (IntentionAction fix3 : fixes) {
            Collection collection2;
            if (fix3 == null) continue;
            if (Intrinsics.areEqual((Object)fix3, (Object)RegisterQuickFixesLaterIntentionAction.INSTANCE) && builder2 != null) {
                if (element.getReference() != null) {
                    PsiReference it2;
                    boolean bl2 = false;
                    UnresolvedReferenceQuickFixUpdater.getInstance((Project)element.getProject()).registerQuickFixesLater(it2, builder2);
                }
                continue;
            }
            List options2 = new ArrayList();
            if (fix3 instanceof IntentionActionWithOptions) {
                collection2 = options2;
                List list2 = ((IntentionActionWithOptions)fix3).getOptions();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOptions(...)");
                CollectionsKt.addAll((Collection)collection2, (Iterable)list2);
            }
            if (problemGroup instanceof SuppressableProblemGroup) {
                void $this$mapNotNullTo$iv$iv;
                collection2 = options2;
                SuppressIntentionAction[] suppressIntentionActionArray = ((SuppressableProblemGroup)problemGroup).getSuppressActions(element);
                Intrinsics.checkNotNullExpressionValue((Object)suppressIntentionActionArray, (String)"getSuppressActions(...)");
                Object $this$mapNotNull$iv = suppressIntentionActionArray;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                    boolean bl3 = false;
                    SuppressIntentionAction it3 = (SuppressIntentionAction)element$iv$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it3, (String)"null cannot be cast to non-null type com.intellij.codeInsight.intention.IntentionAction");
                    IntentionAction it$iv$iv = (IntentionAction)it3;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)collection2, (Iterable)$this$mapNotNull$iv);
            }
            boolean isError = diagnostic.getSeverity() == Severity.ERROR;
            String message2 = KotlinBaseFe10HighlightingBundle.message(isError ? "kotlin.compiler.error" : "kotlin.compiler.warning", new Object[0]);
            HighlightInfo.Builder builder3 = builder2;
            if (builder3 != null) {
                builder3.registerFix(fix3, options2, message2, range2, keyForSuppressOptions);
            }
            HighlightInfo highlightInfo2 = highlightInfo;
            if (highlightInfo2 == null) continue;
            highlightInfo2.registerFix(fix3, options2, message2, range2, keyForSuppressOptions);
        }
    }

    @NlsContexts.Tooltip
    private final String getMessage(Diagnostic diagnostic) {
        Object message2;
        block7: {
            block6: {
                String string = IdeErrorMessages.render((UnboundDiagnostic)diagnostic);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
                message2 = string;
                boolean $i$f$isApplicationInternalMode = false;
                if (ApplicationManager.getApplication().isInternal()) break block6;
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block7;
            }
            String factoryName = diagnostic.getFactory().getName();
            if (StringsKt.startsWith$default((String)message2, (String)"<html>", (boolean)false, (int)2, null)) {
                String string = ((String)message2).substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                v2 = "<html>[" + factoryName + "] " + string;
            } else {
                v2 = message2 = "[" + factoryName + "] " + (String)message2;
            }
        }
        if (!StringsKt.startsWith$default((String)message2, (String)"<html>", (boolean)false, (int)2, null)) {
            message2 = "<html><body>" + XmlStringUtil.escapeString((String)message2) + "</body></html>";
        }
        return message2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getDefaultMessage(Diagnostic diagnostic) {
        Object object;
        String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
        String message2 = string;
        boolean $i$f$isApplicationInternalMode = false;
        if (!ApplicationManager.getApplication().isInternal()) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                object = message2;
                return object;
            }
        }
        object = "[" + diagnostic.getFactory().getName() + "] " + message2;
        return object;
    }

    private final HighlightInfoType toHighlightInfoType(ProblemHighlightType highlightType, Severity severity) {
        HighlightInfoType highlightInfoType;
        ProblemHighlightType problemHighlightType = highlightType;
        switch (problemHighlightType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[problemHighlightType.ordinal()]) {
            case 1: {
                HighlightInfoType highlightInfoType2 = HighlightInfoType.UNUSED_SYMBOL;
                highlightInfoType = highlightInfoType2;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType2, (String)"UNUSED_SYMBOL");
                break;
            }
            case 2: {
                HighlightInfoType highlightInfoType3 = HighlightInfoType.WRONG_REF;
                highlightInfoType = highlightInfoType3;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType3, (String)"WRONG_REF");
                break;
            }
            case 3: {
                HighlightInfoType highlightInfoType4 = HighlightInfoType.DEPRECATED;
                highlightInfoType = highlightInfoType4;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType4, (String)"DEPRECATED");
                break;
            }
            case 4: {
                HighlightInfoType highlightInfoType5 = HighlightInfoType.MARKED_FOR_REMOVAL;
                highlightInfoType = highlightInfoType5;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType5, (String)"MARKED_FOR_REMOVAL");
                break;
            }
            default: {
                highlightInfoType = this.convertSeverity(highlightType, severity);
            }
        }
        return highlightInfoType;
    }

    private final HighlightInfoType convertSeverity(ProblemHighlightType highlightType, Severity severity) {
        HighlightInfoType highlightInfoType;
        switch (WhenMappings.$EnumSwitchMapping$1[severity.ordinal()]) {
            case 1: {
                HighlightInfoType highlightInfoType2 = HighlightInfoType.ERROR;
                highlightInfoType = highlightInfoType2;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType2, (String)"ERROR");
                break;
            }
            case 2: {
                HighlightInfoType highlightInfoType3 = highlightType == ProblemHighlightType.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : HighlightInfoType.WARNING;
                Intrinsics.checkNotNull((Object)highlightInfoType3);
                highlightInfoType = highlightInfoType3;
                break;
            }
            case 3: {
                HighlightInfoType highlightInfoType4 = HighlightInfoType.WEAK_WARNING;
                highlightInfoType = highlightInfoType4;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType4, (String)"WEAK_WARNING");
                break;
            }
            default: {
                HighlightInfoType highlightInfoType5 = HighlightInfoType.INFORMATION;
                highlightInfoType = highlightInfoType5;
                Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType5, (String)"INFORMATION");
            }
        }
        return highlightInfoType;
    }

    private final TextAttributesKey convertSeverityTextAttributes(ProblemHighlightType highlightType, Severity severity) {
        ProblemHighlightType problemHighlightType = highlightType;
        return switch (problemHighlightType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[problemHighlightType.ordinal()]) {
            case -1, 5 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[severity.ordinal()]) {
                    case 1: {
                        yield CodeInsightColors.ERRORS_ATTRIBUTES;
                    }
                    case 2: {
                        yield CodeInsightColors.WARNINGS_ATTRIBUTES;
                    }
                    case 3: {
                        yield CodeInsightColors.WARNINGS_ATTRIBUTES;
                    }
                }
                yield null;
            }
            case 6 -> CodeInsightColors.ERRORS_ATTRIBUTES;
            default -> null;
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo$Companion;", "", "<init>", "()V", "KOTLIN_COMPILER_WARNING_ID", "", "kotlin.highlighting.k1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProblemHighlightType.values().length];
            try {
                nArray[ProblemHighlightType.LIKE_UNUSED_SYMBOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemHighlightType.LIKE_UNKNOWN_SYMBOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemHighlightType.LIKE_DEPRECATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemHighlightType.GENERIC_ERROR_OR_WARNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemHighlightType.GENERIC_ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Severity.values().length];
            try {
                nArray[Severity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

