/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.inspections.AddKotlinLibQuickFix;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix;", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getText", "", "getFamilyName", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "kotlin.jvm"})
public final class AddTestLibQuickFix
extends AddKotlinLibQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> KOTLIN_TEST_UNRESOLVED;

    public AddTestLibQuickFix(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element, LibraryJarDescriptor.TEST_JAR, DependencyScope.TEST);
    }

    @NotNull
    public String getText() {
        return KotlinJvmBundle.message("classpath.add.kotlin.test", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    protected AddKotlinLibQuickFix.MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
        if (ideKotlinVersion == null) {
            ideKotlinVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        }
        return AddKotlinLibQuickFix.MavenExternalLibraryDescriptor.Companion.create("org.jetbrains.kotlin", "kotlin-test", ideKotlinVersion);
    }

    static {
        Object[] objectArray = new String[]{"Asserter", "assertFailsWith", "currentStackTrace", "failsWith", "todo", "assertEquals", "assertFails", "assertNot", "assertNotEquals", "assertNotNull", "assertNull", "assertTrue", "expect", "fail", "fails"};
        KOTLIN_TEST_UNRESOLVED = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "KOTLIN_TEST_UNRESOLVED", "", "", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nAddKotlinLibQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddKotlinLibQuickFix.kt\norg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 quickfixUtil.kt\norg/jetbrains/kotlin/idea/util/QuickfixUtilKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,164:1\n774#2:165\n865#2,2:166\n23#3:168\n154#4:169\n*S KotlinDebug\n*F\n+ 1 AddKotlinLibQuickFix.kt\norg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix$Companion\n*L\n101#1:165\n101#1:166,2\n114#1:168\n114#1:169\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 unresolvedReference = (DiagnosticWithParameters1)Errors.UNRESOLVED_REFERENCE.cast((UnboundDiagnostic)diagnostic);
            if (PsiTreeUtil.getParentOfType((PsiElement)diagnostic.getPsiElement(), KtImportDirective.class) != null) {
                return null;
            }
            String unresolvedText = ((KtReferenceExpression)unresolvedReference.getA()).getText();
            if (KOTLIN_TEST_UNRESOLVED.contains(unresolvedText)) {
                void $this$filterTo$iv$iv;
                PsiFile psiFile = diagnostic.getPsiElement().getContainingFile();
                KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
                if (ktFile2 == null) {
                    return null;
                }
                KtFile ktFile3 = ktFile2;
                FqName exactImportFqName = new FqName("kotlin.test." + unresolvedText);
                FqName kotlinTestAllUnder = new FqName("kotlin.test");
                boolean hasExactImport = false;
                boolean hasKotlinTestAllUnder = false;
                Iterable $this$filter$iv = ktFile3.getImportDirectives();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtImportDirective it = (KtImportDirective)element$iv$iv;
                    boolean bl = false;
                    String string = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"kotlin.test.", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (KtImportDirective importDirective : (List)destination$iv$iv) {
                    if (Intrinsics.areEqual((Object)importDirective.getImportedFqName(), (Object)exactImportFqName)) {
                        hasExactImport = true;
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)importDirective.getImportedFqName(), (Object)kotlinTestAllUnder) || !importDirective.isAllUnder()) continue;
                    hasKotlinTestAllUnder = true;
                    break;
                }
                if (hasExactImport || hasKotlinTestAllUnder) {
                    KotlinQuickFixAction kotlinQuickFixAction;
                    Diagnostic $this$createIntentionForFirstParentOfType$iv = diagnostic;
                    boolean $i$f$createIntentionForFirstParentOfType = false;
                    PsiElement $this$getNonStrictParentOfType$iv$iv = $this$createIntentionForFirstParentOfType$iv.getPsiElement();
                    boolean $i$f$getNonStrictParentOfType = false;
                    PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtElement.class, (boolean)false);
                    if (psiElement != null) {
                        KtElement p0 = (KtElement)psiElement;
                        boolean $i$f$createAction$stub_for_inlining = false;
                        boolean bl = false;
                        kotlinQuickFixAction = new AddTestLibQuickFix(p0);
                    } else {
                        kotlinQuickFixAction = null;
                    }
                    return kotlinQuickFixAction;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

