/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfFix;
import org.jetbrains.kotlin.idea.inspections.RemoveFix;
import org.jetbrains.kotlin.idea.inspections.SimplifyFix;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0003\u001a'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00022\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a$\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0001\u00a8\u0006\u0011"}, d2={"getConditionConstantValueIfAny", "", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/lang/Boolean;", "collectFixes", "", "Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfFix;", "expression", "constantValue", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Ljava/lang/Boolean;)Ljava/util/List;", "branch", "Lorg/jetbrains/kotlin/psi/KtExpression;", "thenBranch", "replaceWithBranch", "", "isUsedAsExpression", "keepBraces", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConstantConditionIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantConditionIfInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,196:1\n1#2:197\n26#3,7:198\n26#3,7:205\n26#3,7:212\n*S KotlinDebug\n*F\n+ 1 ConstantConditionIfInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspectionKt\n*L\n159#1:198,7\n161#1:205,7\n168#1:212,7\n*E\n"})
public final class ConstantConditionIfInspectionKt {
    private static final Boolean getConditionConstantValueIfAny(KtIfExpression $this$getConditionConstantValueIfAny) {
        KtExpression expr = $this$getConditionConstantValueIfAny.getCondition();
        while (expr instanceof KtParenthesizedExpression) {
            expr = ((KtParenthesizedExpression)expr).getExpression();
        }
        if (!(expr instanceof KtConstantExpression)) {
            return null;
        }
        KtExpression ktExpression = $this$getConditionConstantValueIfAny.getCondition();
        if (ktExpression == null || (ktExpression = ResolutionUtils.analyze((KtElement)ktExpression, BodyResolveMode.PARTIAL_WITH_CFA)) == null) {
            return null;
        }
        KtExpression context2 = ktExpression;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)expr, (BindingContext)context2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expr, (BindingContext)context2);
        if (compileTimeConstant == null || (compileTimeConstant = compileTimeConstant.toConstantValue(type2)) == null) {
            return null;
        }
        CompileTimeConstant constant = compileTimeConstant;
        Object object = constant.getValue();
        return object instanceof Boolean ? (Boolean)object : null;
    }

    private static final List<ConstantConditionIfFix> collectFixes(KtIfExpression expression, Boolean constantValue) {
        if (constantValue == null) {
            return CollectionsKt.emptyList();
        }
        List fixes = new ArrayList();
        if (ConstantConditionIfInspectionKt.branch(expression, constantValue) != null) {
            boolean keepBraces = IfThenUtilsKt.isElseIf((KtExpression)expression) && ConstantConditionIfInspectionKt.branch(expression, constantValue) instanceof KtBlockExpression;
            ((Collection)fixes).add(new SimplifyFix(constantValue, BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)expression), (BindingContext)ResolutionUtils.analyze((KtElement)expression, BodyResolveMode.PARTIAL_WITH_CFA)), keepBraces));
        }
        if (!constantValue.booleanValue() && expression.getElse() == null) {
            ((Collection)fixes).add(new RemoveFix());
        }
        return fixes;
    }

    static /* synthetic */ List collectFixes$default(KtIfExpression ktIfExpression, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = ConstantConditionIfInspectionKt.getConditionConstantValueIfAny(ktIfExpression);
        }
        return ConstantConditionIfInspectionKt.collectFixes(ktIfExpression, bl);
    }

    private static final KtExpression branch(KtIfExpression $this$branch, boolean thenBranch) {
        return thenBranch ? $this$branch.getThen() : $this$branch.getElse();
    }

    public static final void replaceWithBranch(@NotNull KtExpression $this$replaceWithBranch, @NotNull KtExpression branch, boolean isUsedAsExpression, boolean keepBraces) {
        block41: {
            PsiElement replaced;
            KtWhenExpression ktWhenExpression;
            KtWhenExpression property;
            Intrinsics.checkNotNullParameter((Object)$this$replaceWithBranch, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            Editor editor = EditorUtilsKt.findExistingEditor((PsiElement)$this$replaceWithBranch);
            CaretModel caretModel = editor != null ? editor.getCaretModel() : null;
            KtWhenExpression ktWhenExpression2 = $this$replaceWithBranch instanceof KtWhenExpression ? (KtWhenExpression)$this$replaceWithBranch : null;
            if (ktWhenExpression2 != null && (ktWhenExpression2 = ktWhenExpression2.getSubjectVariable()) != null) {
                property = ktWhenExpression2;
                boolean bl = false;
                List list2 = property.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
                if (!((Collection)list2).isEmpty()) {
                    ktWhenExpression = property;
                } else {
                    KtExpression ktExpression = property.getInitializer();
                    if (ktExpression == null) {
                        ktWhenExpression = property;
                    } else {
                        KtExpression initializer2 = ktExpression;
                        Query query = ReferencesSearch.search((PsiElement)((PsiElement)property), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)$this$replaceWithBranch)));
                        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                        List references = CollectionsKt.toList((Iterable)((Iterable)query));
                        switch (references.size()) {
                            case 0: {
                                KtWhenExpression ktWhenExpression3;
                                KtWhenExpression it = ktWhenExpression3 = property;
                                boolean bl2 = false;
                                if (!ExpressionExtKt.hasNoSideEffects(initializer2)) {
                                    ktWhenExpression = ktWhenExpression3;
                                    break;
                                }
                                ktWhenExpression = null;
                                break;
                            }
                            case 1: {
                                if (ExpressionExtKt.hasNoSideEffects(initializer2)) {
                                    ((PsiReference)CollectionsKt.first((List)references)).getElement().replace((PsiElement)initializer2);
                                    ktWhenExpression = null;
                                    break;
                                }
                                ktWhenExpression = property;
                                break;
                            }
                            default: {
                                ktWhenExpression = property;
                            }
                        }
                    }
                }
            } else {
                ktWhenExpression = null;
            }
            KtWhenExpression subjectVariable = ktWhenExpression;
            Project project = $this$replaceWithBranch.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            PsiElement parent = $this$replaceWithBranch.getParent();
            if (!(branch instanceof KtBlockExpression)) {
                KtExpression ktExpression;
                if (subjectVariable != null) {
                    PsiElement psiElement;
                    property = (PsiElement)$this$replaceWithBranch;
                    Object[] bl = new Object[]{subjectVariable, branch};
                    PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"run { $0\n$1 }", (Object[])bl, (boolean)false, (int)4, null);
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement = newElement$iv;
                    } else {
                        result$iv = $this$replaced$iv.replace(newElement$iv);
                        if (result$iv instanceof KtExpression) {
                            psiElement = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement = (PsiElement)ktExpression2;
                        }
                    }
                    ktExpression = (KtExpression)psiElement;
                } else {
                    PsiElement psiElement;
                    $this$replaced$iv = (PsiElement)$this$replaceWithBranch;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)branch))) {
                        psiElement = (PsiElement)branch;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)branch);
                        if (result$iv instanceof KtExpression) {
                            psiElement = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement = (PsiElement)ktExpression3;
                        }
                    }
                    ktExpression = (KtExpression)psiElement;
                }
                v12 = (PsiElement)ktExpression;
            } else if (isUsedAsExpression) {
                if (subjectVariable != null) {
                    KtBlockExpression ktBlockExpression = (KtBlockExpression)branch;
                    PsiElement psiElement = psiFactory.createNewLine();
                    KtBlockExpression ktBlockExpression2 = (KtBlockExpression)branch;
                    PsiElement psiElement2 = (PsiElement)subjectVariable;
                    List list3 = ((KtBlockExpression)branch).getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getStatements(...)");
                    ktBlockExpression.addAfter(psiElement, ktBlockExpression2.addBefore(psiElement2, (PsiElement)CollectionsKt.firstOrNull((List)list3)));
                }
                $this$replaced$iv = (PsiElement)$this$replaceWithBranch;
                Object[] $i$f$replaced = new Object[]{((KtBlockExpression)branch).getText()};
                PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"run $0", (Object[])$i$f$replaced, (boolean)false, (int)4, null);
                boolean $i$f$replaced2 = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                    v12 = newElement$iv;
                } else {
                    result$iv = $this$replaced$iv.replace(newElement$iv);
                    if (result$iv instanceof KtExpression) {
                        v12 = result$iv;
                    } else {
                        Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                        if (ktExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                        v12 = (PsiElement)ktExpression;
                    }
                }
            } else {
                PsiElement psiElement;
                PsiElement lastChild;
                PsiElement firstChildSibling = ((KtBlockExpression)branch).getFirstChild().getNextSibling();
                if (!Intrinsics.areEqual((Object)firstChildSibling, (Object)(lastChild = ((KtBlockExpression)branch).getLastChild()))) {
                    if (keepBraces) {
                        psiElement = parent.addAfter((PsiElement)branch, (PsiElement)$this$replaceWithBranch);
                    } else if (subjectVariable != null) {
                        ((KtBlockExpression)branch).addAfter((PsiElement)subjectVariable, ((KtBlockExpression)branch).getLBrace());
                        psiElement = parent.addAfter((PsiElement)psiFactory.createExpression("run " + ((KtBlockExpression)branch).getText()), (PsiElement)$this$replaceWithBranch);
                    } else {
                        psiElement = parent.addRangeAfter(firstChildSibling, lastChild.getPrevSibling(), (PsiElement)$this$replaceWithBranch);
                    }
                } else {
                    psiElement = null;
                }
                PsiElement replaced2 = psiElement;
                $this$replaceWithBranch.delete();
                v12 = replaced = replaced2;
            }
            if (replaced == null) break block41;
            CaretModel caretModel2 = caretModel;
            if (caretModel2 != null) {
                caretModel2.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)replaced));
            }
        }
    }

    public static /* synthetic */ void replaceWithBranch$default(KtExpression ktExpression, KtExpression ktExpression2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        ConstantConditionIfInspectionKt.replaceWithBranch(ktExpression, ktExpression2, bl, bl2);
    }

    public static final /* synthetic */ Boolean access$getConditionConstantValueIfAny(KtIfExpression $receiver) {
        return ConstantConditionIfInspectionKt.getConditionConstantValueIfAny($receiver);
    }

    public static final /* synthetic */ List access$collectFixes(KtIfExpression expression, Boolean constantValue) {
        return ConstantConditionIfInspectionKt.collectFixes(expression, constantValue);
    }

    public static final /* synthetic */ KtExpression access$branch(KtIfExpression $receiver, boolean thenBranch) {
        return ConstantConditionIfInspectionKt.branch($receiver, thenBranch);
    }
}

