/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.AddNamesInCommentToJavaCallArgumentsIntention;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/InconsistentCommentForJavaParameterInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "CorrectNamesInCommentsToJavaCallArgumentsFix", "kotlin.idea"})
public final class InconsistentCommentForJavaParameterInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitCallExpression(KtCallExpression callExpression) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                this.check((KtCallElement)callExpression);
            }

            public void visitSuperTypeCallEntry(KtSuperTypeCallEntry call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                this.check((KtCallElement)call2);
            }

            public void visitConstructorDelegationCall(KtConstructorDelegationCall call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                this.check((KtCallElement)call2);
            }

            public void visitAnnotationEntry(KtAnnotationEntry annotationEntry2) {
                Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
                this.check((KtCallElement)annotationEntry2);
            }

            private final void check(KtCallElement $this$check) {
                List<Pair<KtValueArgument, ValueParameterDescriptor>> list2 = AddNamesInCommentToJavaCallArgumentsIntention.Holder.INSTANCE.resolveValueParameterDescriptors($this$check, false);
                if (list2 == null) {
                    return;
                }
                List<Pair<KtValueArgument, ValueParameterDescriptor>> valueDescriptorByValueArgument = list2;
                for (Pair<KtValueArgument, ValueParameterDescriptor> pair : valueDescriptorByValueArgument) {
                    PsiComment comment;
                    KtValueArgument argument2 = (KtValueArgument)pair.component1();
                    ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component2();
                    if (AddNamesInCommentToJavaCallArgumentsIntention.Holder.INSTANCE.blockCommentWithName(argument2) == null || AddNamesInCommentToJavaCallArgumentsIntention.Holder.INSTANCE.isParameterNameComment(comment, descriptor2)) continue;
                    Object[] objectArray = new Object[]{descriptor2.getName().asString()};
                    String string = KotlinBundle.message((String)"inspection.message.inconsistent.parameter.name.for.0", (Object[])objectArray);
                    objectArray = new LocalQuickFix[]{new CorrectNamesInCommentsToJavaCallArgumentsFix(AddNamesInCommentToJavaCallArgumentsIntention.Holder.INSTANCE.toParameterNameComment(descriptor2))};
                    this.$holder.registerProblem((PsiElement)comment, string, (LocalQuickFix[])objectArray);
                }
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/InconsistentCommentForJavaParameterInspection$CorrectNamesInCommentsToJavaCallArgumentsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "commentedParameterName", "", "<init>", "(Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nInconsistentCommentForJavaParameterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InconsistentCommentForJavaParameterInspection.kt\norg/jetbrains/kotlin/idea/inspections/InconsistentCommentForJavaParameterInspection$CorrectNamesInCommentsToJavaCallArgumentsFix\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,59:1\n119#2:60\n*S KotlinDebug\n*F\n+ 1 InconsistentCommentForJavaParameterInspection.kt\norg/jetbrains/kotlin/idea/inspections/InconsistentCommentForJavaParameterInspection$CorrectNamesInCommentsToJavaCallArgumentsFix\n*L\n53#1:60\n*E\n"})
    public static final class CorrectNamesInCommentsToJavaCallArgumentsFix
    implements LocalQuickFix {
        @NotNull
        private final String commentedParameterName;

        public CorrectNamesInCommentsToJavaCallArgumentsFix(@NotNull String commentedParameterName) {
            Intrinsics.checkNotNullParameter((Object)commentedParameterName, (String)"commentedParameterName");
            this.commentedParameterName = commentedParameterName;
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"intention.name.use.correct.parameter.name", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement $this$safeAs$iv = descriptor2.getPsiElement();
            boolean $i$f$safeAs = false;
            PsiElement psiElement = $this$safeAs$iv;
            if (!(psiElement instanceof PsiComment)) {
                psiElement = null;
            }
            PsiComment psiComment = (PsiComment)psiElement;
            if (psiComment == null) {
                return;
            }
            PsiComment comment = psiComment;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            comment.replace((PsiElement)factory2.createComment(this.commentedParameterName));
        }
    }
}

