/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.inference.mutability;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundType;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeCalculatorImpl;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.BoundTypeEnhancer;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.InferenceContext;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.mutability.CallResolver;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/mutability/MutabilityBoundTypeCalculator;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundTypeCalculatorImpl;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "enhancer", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundTypeEnhancer;", "<init>", "(Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundTypeEnhancer;)V", "callResolver", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/mutability/CallResolver;", "interceptCalculateBoundType", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/BoundType;", "inferenceContext", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/InferenceContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "kotlin.j2k.k1.new.post-processing"})
public final class MutabilityBoundTypeCalculator
extends BoundTypeCalculatorImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolutionFacade resolutionFacade;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private static final Set<FqName> PRESERVING_MUTABILITY_FQ_NAMES;

    public MutabilityBoundTypeCalculator(@NotNull ResolutionFacade resolutionFacade, @NotNull BoundTypeEnhancer enhancer) {
        Intrinsics.checkNotNullParameter((Object)resolutionFacade, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter((Object)enhancer, (String)"enhancer");
        super(resolutionFacade, enhancer);
        this.resolutionFacade = resolutionFacade;
        this.callResolver = new CallResolver(PRESERVING_MUTABILITY_FQ_NAMES);
    }

    @Override
    @Nullable
    public BoundType interceptCalculateBoundType(@NotNull InferenceContext inferenceContext, @NotNull KtExpression expression) {
        BoundType boundType;
        Intrinsics.checkNotNullParameter((Object)inferenceContext, (String)"inferenceContext");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (expression instanceof KtQualifiedExpression) {
            KtExpression ktExpression = ((KtQualifiedExpression)expression).getSelectorExpression();
            if (ktExpression == null) {
                return null;
            }
            KtExpression selector2 = ktExpression;
            boundType = this.callResolver.isNeededCall(selector2, this.resolutionFacade) ? this.boundType(((KtQualifiedExpression)expression).getReceiverExpression(), inferenceContext) : null;
        } else {
            boundType = null;
        }
        return boundType;
    }

    static {
        Object[] objectArray = new FqName[4];
        Name name2 = Name.identifier((String)"iterator");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        objectArray[0] = StandardNames.FqNames.collection.child(name2);
        Name name3 = Name.identifier((String)"listIterator");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        objectArray[1] = StandardNames.FqNames.list.child(name3);
        Name name4 = Name.identifier((String)"entries");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        objectArray[2] = StandardNames.FqNames.map.child(name4);
        Name name5 = Name.identifier((String)"values");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        objectArray[3] = StandardNames.FqNames.map.child(name5);
        PRESERVING_MUTABILITY_FQ_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/mutability/MutabilityBoundTypeCalculator$Companion;", "", "<init>", "()V", "PRESERVING_MUTABILITY_FQ_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.j2k.k1.new.post-processing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

