/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.branchedTransformations.BranchedTransformationUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u001b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/EliminateWhenSubjectIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtWhenExpression;)Ljava/lang/Boolean;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.intentions.k2"})
@SourceDebugExtension(value={"SMAP\nEliminateWhenSubjectIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EliminateWhenSubjectIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/EliminateWhenSubjectIntention\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,72:1\n11165#2:73\n11500#2,3:74\n*S KotlinDebug\n*F\n+ 1 EliminateWhenSubjectIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/EliminateWhenSubjectIntention\n*L\n56#1:73\n56#1:74,3\n*E\n"})
public final class EliminateWhenSubjectIntention
extends KotlinApplicableModCommandAction<KtWhenExpression, Boolean>
implements LowPriorityAction {
    public EliminateWhenSubjectIntention() {
        super(Reflection.getOrCreateKotlinClass(KtWhenExpression.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"inline.when.argument", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public Boolean prepareContext(@NotNull KaSession $context_receiver_0, @NotNull KtWhenExpression element) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression subjectExpression = element.getSubjectExpression();
        if (!(subjectExpression instanceof KtNameReferenceExpression)) {
            return null;
        }
        List list2 = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
        KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.lastOrNull((List)list2);
        boolean bl = ktWhenEntry != null ? ktWhenEntry.isElse() : false;
        if (bl || !$context_receiver_0.isUsedAsExpression((KtExpression)element)) {
            KaType kaType = $context_receiver_0.getExpressionType(subjectExpression);
            return kaType != null ? $context_receiver_0.isMarkedNullable(kaType) : false;
        }
        return null;
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtWhenExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getOpenBrace();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        int endOffset = psiElement.getStartOffsetInParent();
        return CollectionsKt.listOf((Object)new TextRange(0, endOffset));
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtWhenExpression element, boolean elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtExpression ktExpression = element.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression subject = ktExpression;
        CommentSaver commentSaver = new CommentSaver((PsiElement)element, true);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression whenExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (boolean)false, arg_0 -> EliminateWhenSubjectIntention.invoke$lambda$1(element, subject, elementContext, arg_0), (int)1, null);
        PsiElement result2 = element.replace((PsiElement)whenExpression);
        CommentSaver.restore$default(commentSaver, result2, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit invoke$lambda$1(KtWhenExpression $element, KtExpression $subject, boolean $elementContext, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        $this$buildExpression.appendFixedText("when {\n");
        for (KtWhenEntry entry : $element.getEntries()) {
            KtExpression branchExpression = entry.getExpression();
            if (entry.isElse()) {
                v0 = $this$buildExpression.appendFixedText("else");
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
                Object[] objectArray = ktWhenConditionArray;
                BuilderByPattern builderByPattern = $this$buildExpression;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtWhenCondition ktWhenCondition = (KtWhenCondition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(BranchedTransformationUtilsKt.generateNewConditionWithSubject((KtWhenCondition)it, $subject, $elementContext));
                }
                v0 = builderByPattern.appendExpressions((Iterable)((List)destination$iv$iv), "||");
            }
            $this$buildExpression.appendFixedText("->");
            $this$buildExpression.appendExpression(branchExpression);
            $this$buildExpression.appendFixedText("\n");
        }
        $this$buildExpression.appendFixedText("}");
        return Unit.INSTANCE;
    }
}

