/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.dsl.builder.AlignKt;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveOperationDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveModel;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveModel;)V", "mainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "validateRefactorButton", "", "saveSettings", "doAction", "hasHelpAction", "", "kotlin.refactorings.move.k2"})
public final class K2MoveDialog
extends RefactoringDialog {
    @NotNull
    private final K2MoveModel model;
    private DialogPanel mainPanel;

    public K2MoveDialog(@NotNull Project project, @NotNull K2MoveModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(project, true, true);
        this.model = model2;
        this.setTitle(MoveHandler.getRefactoringName());
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.mainPanel = BuilderKt.panel(arg_0 -> K2MoveDialog.createCenterPanel$lambda$3(this, arg_0));
        DialogPanel dialogPanel = this.mainPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            dialogPanel = null;
        }
        return (JComponent)dialogPanel;
    }

    private final void validateRefactorButton() {
        this.getRefactorAction().setEnabled(this.model.isValidRefactoring());
    }

    private final void saveSettings() {
        DialogPanel dialogPanel = this.mainPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        KotlinCommonRefactoringSettings.Companion.getInstance().setMOVE_PREVIEW_USAGES(this.isPreviewUsages());
        PropertiesComponent.getInstance().setValue("MoveFile.OpenInEditor", this.isOpenInEditor());
    }

    protected void doAction() {
        this.saveSettings();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        K2MoveOperationDescriptor descriptor2 = (K2MoveOperationDescriptor)ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"preparing.move.descriptor", (Object[])new Object[0]), () -> K2MoveDialog.doAction$lambda$4(this));
        this.invokeRefactoring(descriptor2.refactoringProcessor());
    }

    protected boolean hasHelpAction() {
        return false;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$2$lambda$0(K2MoveDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        K2MoveModel.Setting.createComboBox$default(this$0.model.getSearchForText(), $this$panel, false, 2, null);
        this$0.model.getSearchReferences().createComboBox($this$panel, this$0.model.getInSourceRoot());
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$2$lambda$1(K2MoveDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        K2MoveModel.Setting.createComboBox$default(this$0.model.getSearchInComments(), $this$panel, false, 2, null);
        this$0.model.getMppDeclarations().createComboBox($this$panel, this$0.model.getInSourceRoot() && this$0.model instanceof K2MoveModel.Declarations);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$2(K2MoveDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> K2MoveDialog.createCenterPanel$lambda$3$lambda$2$lambda$0(this$0, arg_0)).align(AlignKt.plus((AlignY)((AlignY)AlignY.TOP.INSTANCE), (AlignX)((AlignX)AlignX.LEFT.INSTANCE)));
        $this$row.panel(arg_0 -> K2MoveDialog.createCenterPanel$lambda$3$lambda$2$lambda$1(this$0, arg_0)).align(AlignKt.plus((AlignY)((AlignY)AlignY.TOP.INSTANCE), (AlignX)((AlignX)AlignX.RIGHT.INSTANCE)));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3(K2MoveDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.model.getTarget().buildPanel($this$panel, (Function2<? super String, ? super JComponent, Unit>)((Function2)new Function2<String, JComponent, Unit>((Object)this$0){

            public final void invoke(String p0, JComponent p1) {
                K2MoveDialog.access$setErrorText((K2MoveDialog)((Object)this.receiver), p0, p1);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                K2MoveDialog.access$validateRefactorButton((K2MoveDialog)((Object)this.receiver));
            }
        }));
        this$0.model.getSource().buildPanel($this$panel, (Function2<String, JComponent, Unit>)((Function2)new Function2<String, JComponent, Unit>((Object)this$0){

            public final void invoke(String p0, JComponent p1) {
                K2MoveDialog.access$setErrorText((K2MoveDialog)((Object)this.receiver), p0, p1);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                K2MoveDialog.access$validateRefactorButton((K2MoveDialog)((Object)this.receiver));
            }
        }));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> K2MoveDialog.createCenterPanel$lambda$3$lambda$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final K2MoveOperationDescriptor doAction$lambda$4(K2MoveDialog this$0) {
        return this$0.model.toDescriptor();
    }

    public static final /* synthetic */ void access$setErrorText(K2MoveDialog $this, String p0, JComponent p1) {
        $this.setErrorText(p0, p1);
    }

    public static final /* synthetic */ void access$validateRefactorButton(K2MoveDialog $this) {
        $this.validateRefactorButton();
    }
}

