/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0003\u001a\u00020\u0002H\u0094\u0002J\u001e\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0017\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "addArgumentToExistingAnnotation", "annotationEntry", "argumentText", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAddFileAnnotationFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFileAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public class AddFileAnnotationFix
extends KotlinQuickFixAction<KtFile> {
    @NotNull
    private final FqName annotationFqName;
    @Nullable
    private final FqName argumentClassFqName;
    @Nullable
    private final SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry;

    public AddFileAnnotationFix(@NotNull KtFile file, @NotNull FqName annotationFqName, @Nullable FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        super((PsiElement)file);
        this.annotationFqName = annotationFqName;
        this.argumentClassFqName = argumentClassFqName;
        this.existingAnnotationEntry = existingAnnotationEntry;
    }

    public /* synthetic */ AddFileAnnotationFix(KtFile ktFile2, FqName fqName2, FqName fqName3, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fqName3 = null;
        }
        if ((n & 8) != 0) {
            smartPsiElementPointer = null;
        }
        this(ktFile2, fqName2, fqName3, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
    }

    @NotNull
    public String getText() {
        Object object;
        String annotationName;
        block5: {
            block4: {
                String string = this.annotationFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                annotationName = string;
                object = this.argumentClassFqName;
                if (object == null || (object = object.shortName()) == null || (object = object.asString()) == null) break block4;
                Object it = object;
                boolean bl = false;
                String string2 = (String)it + "::class";
                object = string2;
                if (string2 != null) break block5;
            }
            object = "";
        }
        Object innerText = object;
        String annotationText = annotationName + "(" + (String)innerText + ")";
        Object[] objectArray = new Object[2];
        objectArray[0] = annotationText;
        Object object2 = (KtFile)this.getElement();
        if (object2 == null || (object2 = object2.getName()) == null) {
            object2 = "";
        }
        objectArray[1] = object2;
        return KotlinBundle.message((String)"fix.add.annotation.text.containing.file", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.add.annotation.family", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtFile ktFile2 = (KtFile)this.getElement();
        if (ktFile2 == null) {
            return;
        }
        KtFile fileToAnnotate = ktFile2;
        Object object = this.argumentClassFqName;
        if (object != null && (object = RenderingUtilsKt.render((FqName)object)) != null) {
            Object it = object;
            boolean bl = false;
            string = (String)it + "::class";
        } else {
            string = null;
        }
        String innerText = string;
        String annotationText = innerText == null ? RenderingUtilsKt.render((FqName)this.annotationFqName) : RenderingUtilsKt.render((FqName)this.annotationFqName) + "(" + innerText + ")";
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        if (fileToAnnotate.getFileAnnotationList() == null) {
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(annotationText);
            KtFileAnnotationList createdAnnotationList = PsiUtilsKt.replaceFileAnnotationList((KtFile)fileToAnnotate, (KtFileAnnotationList)newAnnotationList);
            fileToAnnotate.addAfter(psiFactory.createWhiteSpace("\n"), (PsiElement)createdAnnotationList);
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)createdAnnotationList);
        } else {
            KtFileAnnotationList ktFileAnnotationList = fileToAnnotate.getFileAnnotationList();
            if (ktFileAnnotationList == null) {
                return;
            }
            KtFileAnnotationList annotationList = ktFileAnnotationList;
            if (this.existingAnnotationEntry == null) {
                KtAnnotationEntry newAnnotation = psiFactory.createFileAnnotation(annotationText);
                annotationList.add(psiFactory.createWhiteSpace("\n"));
                annotationList.add((PsiElement)newAnnotation);
                ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)annotationList);
            } else if (innerText != null) {
                this.addArgumentToExistingAnnotation(this.existingAnnotationEntry, innerText);
            }
        }
    }

    private final void addArgumentToExistingAnnotation(SmartPsiElementPointer<KtAnnotationEntry> annotationEntry2, String argumentText) {
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)annotationEntry2.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry entry = ktAnnotationEntry;
        KtValueArgumentList existingArgumentList = entry.getValueArgumentList();
        Project project = entry.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtValueArgumentList newArgumentList = psiFactory.createCallArguments("(" + argumentText + ")");
        PsiElement psiElement = existingArgumentList == null ? entry.addAfter((PsiElement)newArgumentList, entry.getLastChild()) : (existingArgumentList.getArguments().isEmpty() ? existingArgumentList.replace((PsiElement)newArgumentList) : (PsiElement)existingArgumentList.addArgument((KtValueArgument)newArgumentList.getArguments().get(0)));
        ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)entry);
    }
}

