/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixFE10;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.QuickFixUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "declarationName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;)V", "getText", "Companion", "UnresolvedReferenceFactory", "kotlin.idea"})
public final class AddSuspendModifierFix
extends AddModifierFixFE10 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String declarationName;

    public AddSuspendModifierFix(@NotNull KtModifierListOwner element, @Nullable String declarationName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"SUSPEND_KEYWORD");
        super(element, ktModifierKeywordToken);
        this.declarationName = declarationName;
    }

    @Override
    @NotNull
    public String getText() {
        String string;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner instanceof KtNamedFunction) {
            if (this.declarationName != null) {
                Object[] objectArray = new Object[]{this.declarationName};
                string = KotlinBundle.message((String)"fix.add.suspend.modifier.function", (Object[])objectArray);
            } else {
                string = KotlinBundle.message((String)"fix.add.suspend.modifier.function.generic", (Object[])new Object[0]);
            }
        } else if (ktModifierListOwner instanceof KtTypeReference) {
            if (this.declarationName != null) {
                Object[] objectArray = new Object[]{this.declarationName};
                string = KotlinBundle.message((String)"fix.add.suspend.modifier.receiver", (Object[])objectArray);
            } else {
                string = KotlinBundle.message((String)"fix.add.suspend.modifier.receiver.generic", (Object[])new Object[0]);
            }
        } else {
            string = super.getText();
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (ktElement == null) {
                return null;
            }
            KtElement element = ktElement;
            KtNamedFunction ktNamedFunction = QuickFixUtilsKt.containingFunction(element);
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function = ktNamedFunction;
            String string = function.getName();
            if (string == null) {
                return null;
            }
            String functionName = string;
            return new AddSuspendModifierFix((KtModifierListOwner)function, functionName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix$UnresolvedReferenceFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "suspendExtensionNames", "", "", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class UnresolvedReferenceFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final UnresolvedReferenceFactory INSTANCE = new UnresolvedReferenceFactory();
        @NotNull
        private static final Set<String> suspendExtensionNames;

        private UnresolvedReferenceFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtNameReferenceExpression ktNameReferenceExpression = psiElement instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement : null;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression refExpr = ktNameReferenceExpression;
            if (!suspendExtensionNames.contains(refExpr.getReferencedName())) {
                return null;
            }
            PsiElement psiElement2 = refExpr.getParent();
            KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression callParent = ktCallExpression;
            PsiElement psiElement3 = callParent.getParent();
            KtQualifiedExpression ktQualifiedExpression = psiElement3 instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement3 : null;
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression qualifiedGrandParent = ktQualifiedExpression;
            if (callParent != qualifiedGrandParent.getSelectorExpression() || refExpr != callParent.getCalleeExpression()) {
                return null;
            }
            KtExpression ktExpression = qualifiedGrandParent.getReceiverExpression();
            KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
            if (ktNameReferenceExpression2 == null) {
                return null;
            }
            KtNameReferenceExpression receiver2 = ktNameReferenceExpression2;
            ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)receiver2, null, 1, null);
            CallableDescriptor callableDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
            ValueDescriptor valueDescriptor = callableDescriptor instanceof ValueDescriptor ? (ValueDescriptor)callableDescriptor : null;
            if (valueDescriptor == null) {
                return null;
            }
            ValueDescriptor receiverDescriptor = valueDescriptor;
            KotlinType kotlinType = receiverDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (!FunctionTypesKt.isFunctionType((KotlinType)kotlinType)) {
                return null;
            }
            PsiElement psiElement4 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)receiverDescriptor));
            KtCallableDeclaration ktCallableDeclaration = psiElement4 instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement4 : null;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration declaration = ktCallableDeclaration;
            if (declaration instanceof KtFunction) {
                return null;
            }
            KtTypeReference ktTypeReference = declaration.getTypeReference();
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference variableTypeReference = ktTypeReference;
            return new AddSuspendModifierFix((KtModifierListOwner)variableTypeReference, declaration.getName());
        }

        static {
            Object[] objectArray = new String[]{"startCoroutine", "createCoroutine"};
            suspendExtensionNames = SetsKt.setOf((Object[])objectArray);
        }
    }
}

