/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToLabeledReturnFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "element", "labeledReturn", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Ljava/lang/String;)V", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "kotlin.fir.frontend-independent"})
public final class ChangeToLabeledReturnFix
extends PsiUpdateModCommandAction<KtReturnExpression> {
    @NotNull
    private final String labeledReturn;

    public ChangeToLabeledReturnFix(@NotNull KtReturnExpression element, @NotNull String labeledReturn) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)labeledReturn, (String)"labeledReturn");
        super((PsiElement)element);
        this.labeledReturn = labeledReturn;
    }

    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtReturnExpression element, @NotNull ModPsiUpdater updater2) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Project project = actionContext.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        KtExpression returnedExpression = element.getReturnedExpression();
        if (returnedExpression == null) {
            ktExpression = factory2.createExpression(this.labeledReturn);
        } else {
            Object[] objectArray = new Object[]{this.labeledReturn, returnedExpression};
            ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0 $1", (Object[])objectArray, (boolean)false, (int)4, null);
        }
        KtExpression newExpression = ktExpression;
        element.replace((PsiElement)newExpression);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.change.to.labeled.return.family", (Object[])new Object[0]);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtReturnExpression element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[]{this.labeledReturn};
        Presentation presentation = Presentation.of((String)KotlinBundle.message((String)"fix.change.to.labeled.return.text", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }
}

