/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.run.LocalFileHyperlinkInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinConsoleFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "Companion", "kotlin.run-configurations.jvm"})
@SourceDebugExtension(value={"SMAP\nKotlinConsoleFilterProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinConsoleFilterProvider.kt\norg/jetbrains/kotlin/idea/run/KotlinConsoleFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class KotlinConsoleFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private static final Regex pattern = new Regex("(\\.kts?): \\((\\d+), (\\d+)\\):");

    public KotlinConsoleFilter(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GlobalSearchScope getScope() {
        return this.scope;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        int n;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        MatchResult matchResult = Regex.find$default((Regex)pattern, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult messageSuffix = matchResult;
        MatchGroup matchGroup = messageSuffix.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        int pathEnd = matchGroup.getRange().getLast() + 1;
        String string = line.substring(0, pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String pathWithPrefix = string;
        Integer n2 = StringsKt.indexOf$default((CharSequence)pathWithPrefix, (String)":\\", (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n2).intValue();
        boolean bl2 = false;
        Integer n3 = it >= 0 ? n2 : null;
        if (n3 != null) {
            n = n3 - 1;
        } else {
            Integer bl2 = StringsKt.indexOf$default((CharSequence)pathWithPrefix, (String)"/", (int)0, (boolean)false, (int)6, null);
            int it2 = ((Number)bl2).intValue();
            boolean bl3 = false;
            Integer n4 = it2 >= 0 ? bl2 : null;
            if (n4 != null) {
                n = n4;
            } else {
                return null;
            }
        }
        int pathStart = n;
        String string2 = pathWithPrefix.substring(pathStart);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String path2 = string2;
        int lineNumber = Integer.parseInt((String)messageSuffix.getGroupValues().get(2)) - 1;
        int column = Integer.parseInt((String)messageSuffix.getGroupValues().get(3)) - 1;
        TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
        int offset = entireLength - line.length();
        return new Filter.Result(offset + pathStart, offset + messageSuffix.getRange().getLast(), (HyperlinkInfo)new LocalFileHyperlinkInfo(path2, lineNumber, column), attrs);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinConsoleFilter$Companion;", "", "<init>", "()V", "pattern", "Lkotlin/text/Regex;", "kotlin.run-configurations.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

