/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0017\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/KtScratchFile;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getExpressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "psiFile", "Lcom/intellij/psi/PsiFile;", "hasErrors", "", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nKtScratchFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtScratchFile.kt\norg/jetbrains/kotlin/idea/scratch/KtScratchFile\n+ 2 ResolutionUtils.kt\norg/jetbrains/kotlin/idea/caches/resolve/ResolutionUtils\n+ 3 ExtendedResolutionApi.kt\norg/jetbrains/kotlin/idea/caches/resolve/ExtendedResolutionApiKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n154#2:91\n152#3:92\n1755#4,3:93\n*S KotlinDebug\n*F\n+ 1 KtScratchFile.kt\norg/jetbrains/kotlin/idea/scratch/KtScratchFile\n*L\n83#1:91\n83#1:92\n83#1:93,3\n*E\n"})
public final class KtScratchFile
extends ScratchFile {
    public KtScratchFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(project, file);
    }

    @Override
    @NotNull
    public List<ScratchExpression> getExpressions(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getLastCommittedDocument(psiFile);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document doc = document;
        int line = 0;
        ArrayList<ScratchExpression> result2 = new ArrayList<ScratchExpression>();
        while (line < doc.getLineCount()) {
            KtElement ktElement;
            PsiElement element;
            int start2;
            block9: {
                block8: {
                    start2 = 0;
                    start2 = doc.getLineStartOffset(line);
                    element = psiFile.findElementAt(start2);
                    if (element instanceof PsiWhiteSpace) break block8;
                    if (!(element instanceof PsiComment)) break block9;
                }
                Class[] classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class};
                PsiElement psiElement = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])classArray);
                start2 = psiElement != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement) : start2;
                element = psiFile.findElementAt(start2);
            }
            if (element != null) {
                PsiElement it;
                boolean bl = false;
                Class[] classArray = new Class[]{KtImportDirective.class, KtDeclaration.class};
                ktElement = (KtElement)KotlinPsiUtils.getTopmostElementAtOffset(it, start2, classArray);
            } else {
                ktElement = null;
            }
            element = (PsiElement)ktElement;
            if (element == null) {
                ++line;
                continue;
            }
            ScratchExpression scratchExpression = new ScratchExpression(element, doc.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)element)), doc.getLineNumber(PsiUtilsKt.getEndOffset((PsiElement)element)));
            result2.add(scratchExpression);
            line = scratchExpression.getLineEnd() + 1;
        }
        return result2;
    }

    @Override
    @RequiresBackgroundThread
    public boolean hasErrors() {
        KtFile ktFile2 = this.getKtScratchFile();
        if (ktFile2 == null) {
            return false;
        }
        KtFile psiFile = ktFile2;
        Object object = ReadAction.nonBlocking(() -> KtScratchFile.hasErrors$lambda$2(psiFile)).inSmartMode(this.getProject()).expireWith((Disposable)KotlinPluginDisposable.Companion.getInstance(this.getProject())).expireWhen(() -> KtScratchFile.hasErrors$lambda$3(this)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Boolean hasErrors$lambda$2(KtFile $psiFile) {
        boolean bl;
        block5: {
            void $this$analyzeWithContent$iv$iv;
            try {
                AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)$psiFile));
            }
            catch (IllegalArgumentException e) {
                return true;
            }
            KtDeclarationContainer $this$analyzeWithContent$iv = (KtDeclarationContainer)$psiFile;
            boolean $i$f$analyzeWithContent = false;
            KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
            ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)$this$analyzeWithContent$iv);
            boolean $i$f$analyzeWithContent2 = false;
            Diagnostics diagnostics = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade$iv$iv, (KtElement)$this$analyzeWithContent$iv$iv, null, 2, null).getBindingContext().getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"getDiagnostics(...)");
            Iterable $this$any$iv = (Iterable)diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasErrors$lambda$3(KtScratchFile this$0) {
        return this$0.getProject().isDisposed();
    }
}

