/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchFromHereAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchRunLineMarkerContributor$getInfo$lambda$1$;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchRunLineMarkerContributor;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "<init>", "()V", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "isLastExecutedExpression", "getLastExecutedExpression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "getSingleOpenedTextEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nScratchRunLineMarkerContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchRunLineMarkerContributor.kt\norg/jetbrains/kotlin/idea/scratch/actions/ScratchRunLineMarkerContributor\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,87:1\n119#2:88\n150#3:89\n133#3:90\n332#3,11:91\n355#3:102\n*S KotlinDebug\n*F\n+ 1 ScratchRunLineMarkerContributor.kt\norg/jetbrains/kotlin/idea/scratch/actions/ScratchRunLineMarkerContributor\n*L\n29#1:88\n34#1:89\n39#1:90\n40#1:91,11\n40#1:102\n*E\n"})
public final class ScratchRunLineMarkerContributor
extends RunLineMarkerContributor {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        block11: {
            block12: {
                KtExpression ktExpression;
                void $this$getParentOfType$iv;
                block10: {
                    block9: {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiFile $this$safeAs$iv = element.getContainingFile();
                        boolean $i$f$safeAs = false;
                        PsiFile psiFile = $this$safeAs$iv;
                        if (!(psiFile instanceof KtFile)) {
                            psiFile = null;
                        }
                        if ((object = (KtFile)psiFile) == null) break block9;
                        KtFile it = $i$f$safeAs = object;
                        boolean bl = false;
                        VirtualFile file = it.getVirtualFile();
                        Intrinsics.checkNotNull((Object)file);
                        object = ScratchUtilsKt.isKotlinWorksheet(file) || ScratchUtilsKt.isKotlinScratch(file) || it.isScript() ? $i$f$safeAs : null;
                        if (object != null) break block10;
                    }
                    return null;
                }
                PsiElement $this$getStrictParentOfType$iv = element;
                boolean $i$f$getStrictParentOfType22 = false;
                KtNamedDeclaration declaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedDeclaration.class, (boolean)true);
                if (declaration != null && !(declaration instanceof KtParameter) && Intrinsics.areEqual((Object)declaration.getNameIdentifier(), (Object)element)) {
                    return this.isLastExecutedExpression(element);
                }
                PsiElement $i$f$getStrictParentOfType22 = element;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                KtScriptInitializer ktScriptInitializer = (KtScriptInitializer)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtScriptInitializer.class, (boolean)strict$iv);
                if (ktScriptInitializer != null && (ktExpression = ktScriptInitializer.getBody()) != null) {
                    KtExpression scriptInitializer = ktExpression;
                    boolean bl = false;
                    PsiElement $this$findDescendantOfType_u24default$iv = (PsiElement)scriptInitializer;
                    Function1 predicate$iv = getInfo$lambda$1$$inlined$findDescendantOfType$default$1.INSTANCE;
                    boolean $i$f$findDescendantOfType = false;
                    PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                    boolean $i$f$findDescendantOfType2 = false;
                    PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
                    Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                    $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Ref.ObjectRef $result;
                        {
                            this.$predicate = $predicate;
                            this.$result = $result;
                        }

                        public void visitElement(PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            if (element instanceof LeafPsiElement && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                                this.$result.element = element;
                                this.stopWalking();
                                return;
                            }
                            PsiElement it = element;
                            boolean bl = false;
                            super.visitElement(element);
                        }
                    });
                    return Intrinsics.areEqual((Object)((PsiElement)result$iv$iv.element), (Object)element) ? this.isLastExecutedExpression(element) : null;
                }
                if (!(declaration instanceof KtScript) || !(element instanceof PsiWhiteSpace)) break block11;
                if (this.getLastExecutedExpression(element) == null) break block11;
                boolean bl = false;
                int n = PsiLinesUtilsKt.getLineNumber$default(element, false, 1, null);
                PsiFile psiFile = ((PsiWhiteSpace)element).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                if (n == PsiLinesUtilsKt.getLineCount((PsiElement)psiFile)) break block12;
                int n2 = PsiLinesUtilsKt.getLineNumber(element, false);
                PsiFile psiFile2 = ((PsiWhiteSpace)element).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                if (n2 != PsiLinesUtilsKt.getLineCount((PsiElement)psiFile2)) break block11;
            }
            return new RunLineMarkerContributor.Info((AnAction)new RunScratchFromHereAction());
        }
        return null;
    }

    private final RunLineMarkerContributor.Info isLastExecutedExpression(PsiElement element) {
        ScratchExpression scratchExpression = this.getLastExecutedExpression(element);
        if (scratchExpression == null) {
            return null;
        }
        ScratchExpression expression = scratchExpression;
        if (PsiLinesUtilsKt.getLineNumber(element, true) != expression.getLineStart()) {
            return null;
        }
        return PsiTreeUtil.isAncestor((PsiElement)expression.getElement(), (PsiElement)element, (boolean)false) ? new RunLineMarkerContributor.Info((AnAction)new RunScratchFromHereAction()) : null;
    }

    private final ScratchExpression getLastExecutedExpression(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Object object = this.getSingleOpenedTextEditor(psiFile);
        if (object == null || (object = ScratchUtilsKt.getScratchFile((TextEditor)object)) == null) {
            return null;
        }
        Object scratchFile = object;
        if (!((ScratchFile)scratchFile).getOptions().isRepl()) {
            return null;
        }
        SequentialScratchExecutor sequentialScratchExecutor = ((ScratchFile)scratchFile).getReplScratchExecutor();
        if (sequentialScratchExecutor == null) {
            return null;
        }
        SequentialScratchExecutor replExecutor = sequentialScratchExecutor;
        return replExecutor.getFirstNewExpression();
    }

    private final TextEditor getSingleOpenedTextEditor(PsiFile psiFile) {
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getCachedDocument(psiFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Editor[] editorArray = EditorFactory.getInstance().getEditors(document2, psiFile.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        Editor editor = (Editor)ArraysKt.singleOrNull((Object[])editorArray);
        if (editor == null) {
            return null;
        }
        Editor singleOpenedEditor = editor;
        return TextEditorProvider.Companion.getInstance().getTextEditor(singleOpenedEditor);
    }
}

