/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.gradle;

import com.intellij.ide.projectWizard.NewProjectWizardCollector;
import com.intellij.ide.projectWizard.generators.AssetsJava;
import com.intellij.ide.projectWizard.generators.AssetsNewProjectWizardStep;
import com.intellij.ide.projectWizard.generators.AssetsOnboardingTips;
import com.intellij.ide.wizard.NewProjectWizardChainStep;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.observable.util.BindUtil;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.DefinedKotlinPluginManagementVersion;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptSupport;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinGradleCodeInsightUtils;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.gradleJava.KotlinGradlePluginVersionKt;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinGradlePluginVersion;
import org.jetbrains.kotlin.tools.projectWizard.BuildSystemKotlinNewProjectWizard;
import org.jetbrains.kotlin.tools.projectWizard.BuildSystemKotlinNewProjectWizardData;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizard;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizardBundle;
import org.jetbrains.kotlin.tools.projectWizard.KotlinWizardUtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.Versions;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinGradleCompatibilityStore;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinLibrariesCompatibilityStore;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinWizardVersionState;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinWizardVersionStore;
import org.jetbrains.kotlin.tools.projectWizard.core.KotlinAssetsProvider;
import org.jetbrains.kotlin.tools.projectWizard.gradle.GradleKotlinModuleBuilder;
import org.jetbrains.kotlin.tools.projectWizard.gradle.GradleKotlinNewProjectWizard;
import org.jetbrains.kotlin.tools.projectWizard.gradle.GradleKotlinNewProjectWizardData;
import org.jetbrains.kotlin.tools.projectWizard.gradle.GradleKotlinNewProjectWizardKt;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.wizard.AssetsKotlinKt;
import org.jetbrains.kotlin.tools.projectWizard.wizard.KotlinNewProjectWizardUIBundle;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaKotlinVersionProviderService;
import org.jetbrains.plugins.gradle.frameworkSupport.buildscript.GradleBuildScriptBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleNewProjectWizardStep;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard;", "Lorg/jetbrains/kotlin/tools/projectWizard/BuildSystemKotlinNewProjectWizard;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "ordinal", "", "getOrdinal", "()I", "createStep", "Lcom/intellij/ide/wizard/NewProjectWizardStep;", "parent", "Lorg/jetbrains/kotlin/tools/projectWizard/KotlinNewProjectWizard$Step;", "Step", "AssetsStep", "kotlin.project-wizard.gradle"})
public final class GradleKotlinNewProjectWizard
implements BuildSystemKotlinNewProjectWizard {
    @NotNull
    private final String name;
    private final int ordinal;

    public GradleKotlinNewProjectWizard() {
        this.name = "Gradle";
        this.ordinal = 200;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public NewProjectWizardStep createStep(@NotNull KotlinNewProjectWizard.Step parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return (NewProjectWizardStep)NewProjectWizardChainStep.Companion.nextStep((NewProjectWizardStep)new Step(parent), (Function1)createStep.1.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$AssetsStep;", "Lcom/intellij/ide/projectWizard/generators/AssetsNewProjectWizardStep;", "parent", "Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;", "<init>", "(Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;)V", "setupAssets", "", "project", "Lcom/intellij/openapi/project/Project;", "setupProject", "setupSingleModuleProjectAssets", "setupMultiModuleProjectAssets", "kotlin.project-wizard.gradle"})
    private static final class AssetsStep
    extends AssetsNewProjectWizardStep {
        @NotNull
        private final Step parent;

        public AssetsStep(@NotNull Step parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super((NewProjectWizardStep)parent);
            this.parent = parent;
        }

        public void setupAssets(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (this.parent.getShouldGenerateMultipleModules$kotlin_project_wizard_gradle()) {
                this.setupMultiModuleProjectAssets(project);
            } else {
                this.setupSingleModuleProjectAssets(project);
            }
        }

        public void setupProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super.setupProject(project);
            if (this.parent.getShouldGenerateMultipleModules$kotlin_project_wizard_gradle()) {
                GradleKotlinModuleBuilder moduleBuilder = new GradleKotlinModuleBuilder();
                moduleBuilder.setCreateEmptyContentRoots(false);
                moduleBuilder.setCreatingSettingsScriptFile(false);
                moduleBuilder.setCreatingBuildScriptFile(false);
                this.parent.setupBuilder(moduleBuilder);
                this.parent.setupProject(project, moduleBuilder);
            }
        }

        private final void setupSingleModuleProjectAssets(Project project) {
            if (this.getContext().isCreatingNewProject()) {
                this.addAssets(KotlinAssetsProvider.INSTANCE.getKotlinGradleIgnoreAssets());
                this.addTemplateAsset("gradle.properties", "KotlinCodeStyleProperties", new Pair[0]);
            }
            this.addEmptyDirectoryAsset("src/main/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("src/main/resources", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("src/test/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("src/test/resources", new PosixFilePermission[0]);
            if (this.parent.getAddSampleCode()) {
                if (this.parent.getGenerateOnboardingTips()) {
                    AssetsKotlinKt.prepareKotlinSampleOnboardingTips(this, project);
                }
                AssetsKotlinKt.withKotlinSampleCode$default(this, "src/main/kotlin", this.parent.getGroupId(), this.parent.getGenerateOnboardingTips(), false, 8, null);
            }
        }

        private final void setupMultiModuleProjectAssets(Project project) {
            String string;
            String coroutinesVersion;
            String string2;
            String datetimeVersion;
            boolean bl = this.getContext().isCreatingNewProject();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            KotlinLibrariesCompatibilityStore librariesVersionStore = KotlinLibrariesCompatibilityStore.Companion.getInstance();
            String string4 = librariesVersionStore.getLatestVersion("org.jetbrains.kotlinx", "kotlinx-datetime");
            if (string4 == null) {
                string4 = datetimeVersion = "";
            }
            if ((string2 = librariesVersionStore.getLatestVersion("org.jetbrains.kotlinx", "kotlinx-coroutines-core")) == null) {
                string2 = coroutinesVersion = "";
            }
            if ((string = librariesVersionStore.getLatestVersion("org.jetbrains.kotlinx", "kotlinx-serialization-json")) == null) {
                string = "";
            }
            String serializationJsonVersion = string;
            Pair[] pairArray = new Pair[8];
            pairArray[0] = TuplesKt.to((Object)"PROJECT_NAME", (Object)this.parent.getName());
            pairArray[1] = TuplesKt.to((Object)"PACKAGE_NAME", (Object)this.parent.getGroupId());
            pairArray[2] = TuplesKt.to((Object)"KOTLIN_VERSION", (Object)Versions.INSTANCE.getKOTLIN());
            pairArray[3] = TuplesKt.to((Object)"FOOJAY_VERSION", (Object)Versions.GRADLE_PLUGINS.INSTANCE.getFOOJAY_VERSION());
            Object object = this.parent.getSelectedJdkJvmTarget();
            if (object == null || (object = ((Integer)object).toString()) == null) {
                object = "21";
            }
            pairArray[4] = TuplesKt.to((Object)"JVM_VERSION", (Object)object);
            pairArray[5] = TuplesKt.to((Object)"KOTLINX_DATETIME_VERSION", (Object)datetimeVersion);
            pairArray[6] = TuplesKt.to((Object)"KOTLINX_SERIALIZATION_JSON_VERSION", (Object)serializationJsonVersion);
            pairArray[7] = TuplesKt.to((Object)"KOTLINX_COROUTINES_VERSION", (Object)coroutinesVersion);
            Map templateParameters = MapsKt.mapOf((Pair[])pairArray);
            this.addAssets(KotlinAssetsProvider.INSTANCE.getKotlinGradleIgnoreAssets());
            this.addTemplateAsset("gradle.properties", "KotlinSampleProperties", templateParameters);
            this.addTemplateAsset("gradle/libs.versions.toml", "KotlinSampleGradleToml", templateParameters);
            this.addTemplateAsset("settings.gradle.kts", "KotlinSampleSettings", templateParameters);
            this.addTemplateAsset("README.md", "KotlinSampleReadme", templateParameters);
            this.addTemplateAsset("buildSrc/build.gradle.kts", "KotlinSampleBuildSrcBuildGradle", templateParameters);
            this.addTemplateAsset("buildSrc/settings.gradle.kts", "KotlinSampleBuildSrcSettings", templateParameters);
            this.addTemplateAsset("buildSrc/src/main/kotlin/kotlin-jvm.gradle.kts", "KotlinSampleConventionPlugin", templateParameters);
            this.addEmptyDirectoryAsset("app/src/main/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("app/src/main/resources", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("app/src/test/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("app/src/test/resources", new PosixFilePermission[0]);
            this.addTemplateAsset("app/build.gradle.kts", "KotlinSampleAppBuildGradle", templateParameters);
            if (this.parent.getAddSampleCode()) {
                if (this.parent.getGenerateOnboardingTips()) {
                    AssetsKotlinKt.prepareKotlinSampleOnboardingTips(this, project, "KotlinSampleApp", "App.kt");
                }
                String templateName = !this.parent.getGenerateOnboardingTips() ? "KotlinSampleApp" : (AssetsOnboardingTips.INSTANCE.shouldRenderOnboardingTips() ? "KotlinSampleAppWithRenderedOnboardingTips" : "KotlinSampleAppWithOnboardingTips");
                String sourcePath = AssetsJava.INSTANCE.getJavaSampleSourcePath("src/main/kotlin", null, "App.kt");
                AssetsKotlinKt.withKotlinSampleCode$default(this, "app/" + sourcePath, templateName, this.parent.getGroupId(), this.parent.getGenerateOnboardingTips(), false, 16, null);
            }
            this.addEmptyDirectoryAsset("utils/src/main/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("utils/src/main/resources", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("utils/src/test/kotlin", new PosixFilePermission[0]);
            this.addEmptyDirectoryAsset("utils/src/test/resources", new PosixFilePermission[0]);
            this.addTemplateAsset("utils/build.gradle.kts", "KotlinSampleUtilsBuildGradle", templateParameters);
            if (this.parent.getAddSampleCode()) {
                String utilitiesPath = AssetsJava.INSTANCE.getJavaSampleSourcePath("src/main/kotlin", null, "Utilities.kt");
                String utilitiesTestPath = AssetsJava.INSTANCE.getJavaSampleSourcePath("src/test/kotlin", null, "UtilitiesTest.kt");
                this.addTemplateAsset("utils/" + utilitiesPath, "KotlinSampleUtilsUtilities", templateParameters);
                this.addTemplateAsset("utils/" + utilitiesTestPath, "KotlinSampleUtilsUtilitiesTest", templateParameters);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0014J\"\u0010+\u001a\u0004\u0018\u00010.2\u0006\u0010&\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020\nH\u0014J\u0010\u00101\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\b\u00109\u001a\u00020%H\u0002J\b\u0010;\u001a\u00020%H\u0002J\u0010\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020%2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010B\u001a\u00020%2\u0006\u0010?\u001a\u00020@2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020\nH\u0002J\u000e\u0010F\u001a\u0004\u0018\u00010G*\u00020@H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010J\u001a\u00020\n2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010K\u001a\u00020%2\u0006\u0010?\u001a\u00020@H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR+\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR+\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001c\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012*\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u001e\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00108\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u0010:\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010L\u001a\u00020=X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020=0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bR\u0010\fR\u0014\u0010S\u001a\u00020=8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bT\u0010NR\u001c\u0010U\u001a\u00020=8\u0016@\u0016X\u0097\u000f\u00a2\u0006\f\u001a\u0004\bV\u0010N\"\u0004\bW\u0010PR\u001a\u0010X\u001a\b\u0012\u0004\u0012\u00020=0\t8\u0016X\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\bY\u0010\fR\u0018\u0010Z\u001a\u00020=X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b[\u0010N\"\u0004\b\\\u0010PR\u0018\u0010]\u001a\b\u0012\u0004\u0012\u00020=0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b^\u0010\fR\u0018\u0010_\u001a\u00020=X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b`\u0010N\"\u0004\ba\u0010PR\u0018\u0010b\u001a\b\u0012\u0004\u0012\u00020=0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bc\u0010\fR\u0014\u0010d\u001a\u00020e8VX\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\bf\u0010g\u00a8\u0006h"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;", "Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleNewProjectWizardStep;", "Lorg/jetbrains/kotlin/tools/projectWizard/KotlinNewProjectWizard$Step;", "Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizardData;", "Lorg/jetbrains/kotlin/tools/projectWizard/BuildSystemKotlinNewProjectWizardData;", "parent", "<init>", "(Lorg/jetbrains/kotlin/tools/projectWizard/KotlinNewProjectWizard$Step;)V", "addSampleCodeProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "getAddSampleCodeProperty", "()Lcom/intellij/openapi/observable/properties/GraphProperty;", "<set-?>", "addSampleCode", "getAddSampleCode", "()Z", "setAddSampleCode", "(Z)V", "addSampleCode$delegate", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "generateOnboardingTipsProperty", "getGenerateOnboardingTipsProperty", "generateOnboardingTips", "getGenerateOnboardingTips", "setGenerateOnboardingTips", "generateOnboardingTips$delegate", "generateMultipleModulesProperty", "generateMultipleModules", "getGenerateMultipleModules$delegate", "(Lorg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step;)Ljava/lang/Object;", "getGenerateMultipleModules", "setGenerateMultipleModules", "gradleVersionSupportsConventionPlugins", "shouldGenerateMultipleModules", "getShouldGenerateMultipleModules$kotlin_project_wizard_gradle", "setupSampleCodeUI", "", "builder", "Lcom/intellij/ui/dsl/builder/Panel;", "setupSampleCodeWithOnBoardingTipsUI", "setupMultipleModulesUI", "setupSettingsUI", "validateLanguageCompatibility", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "withDialog", "setupAdvancedSettingsUI", "selectedJdkJvmTarget", "", "getSelectedJdkJvmTarget", "()Ljava/lang/Integer;", "setSelectedJdkJvmTarget", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "findSelectedJvmTarget", "canUseFoojay", "checkCanUseFoojay", "kotlinVersionToUse", "", "findKotlinVersionToUse", "project", "Lcom/intellij/openapi/project/Project;", "initializeProjectValues", "configureSettingsFile", "settingsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCreatingNewRootModule", "findParentModule", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleSourceRootGroup;", "getPluginManagementKotlinVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "usesVersionCatalogVersionInBuildSrc", "setupProject", "buildSystem", "getBuildSystem", "()Ljava/lang/String;", "setBuildSystem", "(Ljava/lang/String;)V", "buildSystemProperty", "getBuildSystemProperty", "contentEntryPath", "getContentEntryPath", "language", "getLanguage", "setLanguage", "languageProperty", "getLanguageProperty", "name", "getName", "setName", "nameProperty", "getNameProperty", "path", "getPath", "setPath", "pathProperty", "getPathProperty", "projectPath", "Ljava/nio/file/Path;", "getProjectPath", "()Ljava/nio/file/Path;", "kotlin.project-wizard.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleKotlinNewProjectWizard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleKotlinNewProjectWizard.kt\norg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,467:1\n1#2:468\n1#2:479\n1611#3,9:469\n1863#3:478\n1864#3:480\n1620#3:481\n774#3:482\n865#3,2:483\n1971#3,14:485\n295#3,2:502\n295#3:504\n295#3,2:505\n296#3:507\n1310#4,2:499\n436#5:501\n*S KotlinDebug\n*F\n+ 1 GradleKotlinNewProjectWizard.kt\norg/jetbrains/kotlin/tools/projectWizard/gradle/GradleKotlinNewProjectWizard$Step\n*L\n290#1:479\n290#1:469,9\n290#1:478\n290#1:480\n290#1:481\n294#1:482\n294#1:483,2\n295#1:485,14\n319#1:502,2\n323#1:504\n325#1:505,2\n323#1:507\n313#1:499,2\n319#1:501\n*E\n"})
    public static final class Step
    extends GradleNewProjectWizardStep<KotlinNewProjectWizard.Step>
    implements GradleKotlinNewProjectWizardData,
    BuildSystemKotlinNewProjectWizardData {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        private final /* synthetic */ KotlinNewProjectWizard.Step $$delegate_0;
        @NotNull
        private final GraphProperty<Boolean> addSampleCodeProperty;
        @NotNull
        private final GraphProperty addSampleCode$delegate;
        @NotNull
        private final GraphProperty<Boolean> generateOnboardingTipsProperty;
        @NotNull
        private final GraphProperty generateOnboardingTips$delegate;
        @NotNull
        private final GraphProperty<Boolean> generateMultipleModulesProperty;
        @NotNull
        private final GraphProperty<Boolean> gradleVersionSupportsConventionPlugins;
        @Nullable
        private Integer selectedJdkJvmTarget;
        private boolean canUseFoojay;
        @NotNull
        private String kotlinVersionToUse;

        public Step(@NotNull KotlinNewProjectWizard.Step parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super((NewProjectWizardStep)parent);
            this.$$delegate_0 = parent;
            this.getData().putUserData(GradleKotlinNewProjectWizardData.Companion.getKEY(), (Object)this);
            this.addSampleCodeProperty = (GraphProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)this.getPropertyGraph().property((Object)true)), (String)"NewProjectWizard.addSampleCodeState");
            this.addSampleCode$delegate = this.getAddSampleCodeProperty();
            this.generateOnboardingTipsProperty = (GraphProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)this.getPropertyGraph().property((Object)AssetsOnboardingTips.INSTANCE.proposeToGenerateOnboardingTipsByDefault())), (String)"NewProjectWizard.generateOnboardingTips");
            this.generateOnboardingTips$delegate = this.getGenerateOnboardingTipsProperty();
            this.generateMultipleModulesProperty = (GraphProperty)BindUtil.bindBooleanStorage((ObservableMutableProperty)((ObservableMutableProperty)this.getPropertyGraph().property((Object)false)), (String)"NewProjectWizard.generateMultipleModules");
            this.gradleVersionSupportsConventionPlugins = this.getPropertyGraph().property((Object)false);
            PropertyGraph.dependsOn$default((PropertyGraph)this.getPropertyGraph(), (ObservableMutableProperty)((ObservableMutableProperty)this.gradleVersionSupportsConventionPlugins), (ObservableProperty)((ObservableProperty)this.getGradleVersionProperty()), (boolean)false, () -> Step._init_$lambda$1(this), (int)4, null);
            this.kotlinVersionToUse = "1.9.0";
        }

        @Override
        @NotNull
        public GraphProperty<Boolean> getAddSampleCodeProperty() {
            return this.addSampleCodeProperty;
        }

        @Override
        public boolean getAddSampleCode() {
            return (Boolean)this.addSampleCode$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @Override
        public void setAddSampleCode(boolean bl) {
            this.addSampleCode$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        @Override
        @NotNull
        public GraphProperty<Boolean> getGenerateOnboardingTipsProperty() {
            return this.generateOnboardingTipsProperty;
        }

        @Override
        public boolean getGenerateOnboardingTips() {
            return (Boolean)this.generateOnboardingTips$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        @Override
        public void setGenerateOnboardingTips(boolean bl) {
            this.generateOnboardingTips$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
        }

        @Override
        public boolean getGenerateMultipleModules() {
            return (Boolean)this.generateMultipleModulesProperty.getValue((Object)this, $$delegatedProperties[2]);
        }

        @Override
        public void setGenerateMultipleModules(boolean bl) {
            this.generateMultipleModulesProperty.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
        }

        private static Object getGenerateMultipleModules$delegate(Step step2) {
            return step2.generateMultipleModulesProperty;
        }

        public final boolean getShouldGenerateMultipleModules$kotlin_project_wizard_gradle() {
            return this.getGenerateMultipleModules() && this.getGradleDsl() == GradleNewProjectWizardStep.GradleDsl.KOTLIN && this.getContext().isCreatingNewProject() && (Boolean)this.gradleVersionSupportsConventionPlugins.get() != false;
        }

        private final void setupSampleCodeUI(Panel builder2) {
            Panel.row$default((Panel)builder2, null, arg_0 -> Step.setupSampleCodeUI$lambda$4(this, arg_0), (int)1, null);
        }

        private final void setupSampleCodeWithOnBoardingTipsUI(Panel builder2) {
            builder2.indent(arg_0 -> Step.setupSampleCodeWithOnBoardingTipsUI$lambda$8(this, arg_0)).enabledIf((ObservableProperty)this.getAddSampleCodeProperty());
        }

        private final void setupMultipleModulesUI(Panel builder2) {
            Panel.row$default((Panel)builder2, null, arg_0 -> Step.setupMultipleModulesUI$lambda$11(this, arg_0), (int)1, null).visibleIf(PropertyOperationUtil.and((ObservableProperty)PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this.getGradleDslProperty()), (Object)GradleNewProjectWizardStep.GradleDsl.KOTLIN), (ObservableProperty)((ObservableProperty)this.gradleVersionSupportsConventionPlugins)));
        }

        protected void setupSettingsUI(@NotNull Panel builder2) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            this.setupJavaSdkUI(builder2);
            this.setupGradleDslUI(builder2);
            this.setupParentsUI(builder2);
            this.setupSampleCodeUI(builder2);
            this.setupSampleCodeWithOnBoardingTipsUI(builder2);
            if (this.getContext().isCreatingNewProject()) {
                this.setupMultipleModulesUI(builder2);
                KotlinWizardUtilsKt.addMultiPlatformLink((NewProjectWizardStep)this, builder2);
            }
        }

        protected boolean validateLanguageCompatibility(@NotNull GradleVersion gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            String kotlinVersion = new IdeaKotlinVersionProviderService().getKotlinVersion(ProjectKind.Singleplatform).getVersion().getText();
            return KotlinGradleCompatibilityStore.Companion.kotlinVersionSupportsGradle(IdeKotlinVersion.Companion.get(kotlinVersion), gradleVersion);
        }

        @Nullable
        protected ValidationInfo validateLanguageCompatibility(@NotNull ValidationInfoBuilder builder2, @NotNull GradleVersion gradleVersion, boolean withDialog) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            if (this.validateLanguageCompatibility(gradleVersion)) {
                return null;
            }
            String kotlinVersion = new IdeaKotlinVersionProviderService().getKotlinVersion(ProjectKind.Singleplatform).getVersion().getText();
            Object[] objectArray = new Object[]{kotlinVersion, gradleVersion.getVersion()};
            String string = KotlinNewProjectWizardBundle.message("gradle.project.settings.distribution.version.kotlin.unsupported", objectArray);
            objectArray = new Object[]{this.getContext().isCreatingNewProjectInt()};
            String string2 = KotlinNewProjectWizardBundle.message("gradle.settings.wizard.unsupported.kotlin.title", objectArray);
            objectArray = new Object[]{kotlinVersion, gradleVersion.getVersion()};
            return this.validationWithDialog(builder2, withDialog, string, string2, KotlinNewProjectWizardBundle.message("gradle.settings.wizard.unsupported.kotlin.message", objectArray));
        }

        protected void setupAdvancedSettingsUI(@NotNull Panel builder2) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            this.setupGradleDistributionUI(builder2);
            this.setupGroupIdUI(builder2);
            this.setupArtifactIdUI(builder2);
        }

        @Nullable
        public final Integer getSelectedJdkJvmTarget() {
            return this.selectedJdkJvmTarget;
        }

        public final void setSelectedJdkJvmTarget(@Nullable Integer n) {
            this.selectedJdkJvmTarget = n;
        }

        /*
         * Unable to fully structure code
         */
        private final void findSelectedJvmTarget() {
            v0 = this;
            v1 = this.getSdk();
            if (v1 == null) ** GOTO lbl-1000
            it = v1;
            var3_2 = v0;
            $i$a$-let-GradleKotlinNewProjectWizard$Step$findSelectedJvmTarget$1 = false;
            v2 = JavaSdk.getInstance().getVersion(it);
            v0 = var3_2;
            v1 = v2;
            if (v2 != null) {
                v3 = v1.ordinal();
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            v0.selectedJdkJvmTarget = v3;
        }

        /*
         * Unable to fully structure code
         */
        private final void checkCanUseFoojay() {
            var2_1 = IdeKotlinVersion.Companion.parse-IoAF18A(this.kotlinVersionToUse);
            parsedKotlinVersionToUse = (IdeKotlinVersion)(Result.isFailure-impl((Object)var2_1) != false ? null : var2_1);
            var3_3 = IdeKotlinVersion.Companion.parse-IoAF18A(Versions.GRADLE_PLUGINS.INSTANCE.getMIN_KOTLIN_FOOJAY_VERSION().getText());
            parsedMinKotlinFoojayVersion = (IdeKotlinVersion)(Result.isFailure-impl((Object)var3_3) != false ? null : var3_3);
            if (parsedMinKotlinFoojayVersion != null && parsedKotlinVersionToUse != null && parsedKotlinVersionToUse.compareTo(parsedMinKotlinFoojayVersion) < 0) {
                this.canUseFoojay = false;
                return;
            }
            minGradleFoojayVersion = GradleVersion.version((String)Versions.GRADLE_PLUGINS.INSTANCE.getMIN_GRADLE_FOOJAY_VERSION().getText());
            v0 = parsedKotlinVersionToUse;
            if (v0 == null) ** GOTO lbl-1000
            it = v0;
            $i$a$-let-GradleKotlinNewProjectWizard$Step$checkCanUseFoojay$maxJvmTarget$1 = false;
            v1 = KotlinGradleCompatibilityStore.Companion.getMaxJvmTarget(it);
            v0 = v1;
            if (v1 != null) {
                v2 = v0.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v2 = 11;
            }
            maxJvmTarget = v2;
            v3 = this.selectedJdkJvmTarget;
            if (v3 != null) {
                it = ((Number)v3).intValue();
                $i$a$-let-GradleKotlinNewProjectWizard$Step$checkCanUseFoojay$1 = false;
                if (it > maxJvmTarget) {
                    this.canUseFoojay = false;
                    return;
                }
            }
            this.canUseFoojay = (currentGradleVersion = GradleVersion.version((String)this.getGradleVersion())).compareTo(minGradleFoojayVersion) >= 0;
        }

        private final void findKotlinVersionToUse(Project project) {
            Object object = (KotlinWizardVersionState)KotlinWizardVersionStore.Companion.getInstance().getState();
            if (object == null || (object = object.getKotlinPluginVersion()) == null) {
                object = "1.9.0";
            }
            Object latestKotlinVersion = object;
            this.kotlinVersionToUse = latestKotlinVersion;
            if (this.isCreatingNewRootModule()) {
                return;
            }
            ModuleSourceRootGroup moduleSourceRootGroup = this.findParentModule(project);
            if (moduleSourceRootGroup == null || (moduleSourceRootGroup = moduleSourceRootGroup.getBaseModule()) == null) {
                return;
            }
            ModuleSourceRootGroup parentModule = moduleSourceRootGroup;
            GradleVersion gradleVersion = GradleVersion.version((String)this.getGradleVersion());
            if (gradleVersion == null) {
                return;
            }
            GradleVersion parsedGradleVersion = gradleVersion;
            Object object2 = KotlinWithGradleConfigurator.Companion.findBestKotlinVersion((Module)parentModule, parsedGradleVersion);
            if (object2 == null || (object2 = ((IdeKotlinVersion)object2).getRawVersion()) == null) {
                object2 = latestKotlinVersion;
            }
            this.kotlinVersionToUse = object2;
        }

        private final void initializeProjectValues(Project project) {
            this.findSelectedJvmTarget();
            this.findKotlinVersionToUse(project);
            this.checkCanUseFoojay();
        }

        private final void configureSettingsFile(Project project, VirtualFile settingsFile) {
            if (!this.canUseFoojay) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> Step.configureSettingsFile$lambda$16(settingsFile, project), KotlinNewProjectWizardBundle.message("module.configurator.command", new Object[0]), null);
        }

        private final boolean isCreatingNewRootModule() {
            return this.getContext().isCreatingNewProject() || this.getParentData() == null;
        }

        /*
         * WARNING - void declaration
         */
        private final ModuleSourceRootGroup findParentModule(Project $this$findParentModule) {
            Object v0;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            if (this.isCreatingNewRootModule()) {
                return null;
            }
            ModuleSourceRootMap moduleGroups = new ModuleSourceRootMap($this$findParentModule);
            Iterable iterable = moduleGroups.groupByBaseModules(ArraysKt.toList((Object[])ProjectUtil.getModules((Project)$this$findParentModule)));
            boolean $i$f$mapNotNull = false;
            void var6_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Pair pair = $this$forEach$iv$iv$iv.iterator();
            while (pair.hasNext()) {
                Pair it$iv$iv;
                String externalPath;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = pair.next();
                boolean bl = false;
                ModuleSourceRootGroup it = (ModuleSourceRootGroup)element$iv$iv;
                boolean bl2 = false;
                if ((ExternalSystemApiUtil.getExternalProjectPath((Module)it.getBaseModule()) == null ? null : TuplesKt.to((Object)it, (Object)externalPath)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                pair = (Pair)element$iv$iv;
                boolean bl = false;
                String externalPath = (String)pair.component2();
                if (!StringsKt.startsWith$default((String)this.getPath(), (String)externalPath, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Pair $i$f$filterTo2 = (Pair)maxElem$iv;
                    boolean bl = false;
                    String externalPath2 = (String)$i$f$filterTo2.component2();
                    int maxValue$iv = StringsKt.commonPrefixWith$default((CharSequence)this.getPath(), (CharSequence)externalPath2, (boolean)false, (int)2, null).length();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair externalPath2 = (Pair)e$iv;
                        $i$a$-maxByOrNull-GradleKotlinNewProjectWizard$Step$findParentModule$3 = false;
                        String externalPath3 = (String)externalPath2.component2();
                        int v$iv = StringsKt.commonPrefixWith$default((CharSequence)this.getPath(), (CharSequence)externalPath3, (boolean)false, (int)2, null).length();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Pair pair2 = v0;
            return pair2 != null ? (ModuleSourceRootGroup)pair2.getFirst() : null;
        }

        private final IdeKotlinVersion getPluginManagementKotlinVersion(Project project) {
            if (this.isCreatingNewRootModule()) {
                return null;
            }
            ModuleSourceRootGroup moduleSourceRootGroup = this.findParentModule(project);
            if (moduleSourceRootGroup == null || (moduleSourceRootGroup = moduleSourceRootGroup.getBaseModule()) == null) {
                return null;
            }
            ModuleSourceRootGroup parentModule = moduleSourceRootGroup;
            DefinedKotlinPluginManagementVersion definedKotlinPluginManagementVersion = KotlinWithGradleConfigurator.Companion.getPluginManagementVersion((Module)parentModule);
            return definedKotlinPluginManagementVersion != null ? definedKotlinPluginManagementVersion.getParsedVersion() : null;
        }

        private final boolean usesVersionCatalogVersionInBuildSrc(Project project) {
            String string;
            TomlKey tomlKey;
            Object v13;
            PsiFile buildSrcBuildFile;
            block16: {
                Object v8;
                block14: {
                    Module module;
                    block13: {
                        if (this.isCreatingNewRootModule()) {
                            return false;
                        }
                        Module[] $this$firstOrNull$iv = ProjectUtil.getModules((Project)project);
                        boolean $i$f$firstOrNull = false;
                        int n = $this$firstOrNull$iv.length;
                        for (int j = 0; j < n; ++j) {
                            Module element$iv;
                            Module it = element$iv = $this$firstOrNull$iv[j];
                            boolean bl = false;
                            String string2 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                            if (!StringsKt.endsWith$default((String)string2, (String)".buildSrc", (boolean)false, (int)2, null)) continue;
                            module = element$iv;
                            break block13;
                        }
                        module = null;
                    }
                    if (module == null) {
                        return false;
                    }
                    Module buildSrcModule = module;
                    PsiFile psiFile = KotlinGradleCodeInsightUtils.getBuildScriptPsiFile(buildSrcModule);
                    if (psiFile == null) {
                        return false;
                    }
                    buildSrcBuildFile = psiFile;
                    VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
                    if (virtualFile == null || (virtualFile = virtualFile.findChild("gradle")) == null) {
                        return false;
                    }
                    VirtualFile gradleFolder = virtualFile;
                    VirtualFile virtualFile2 = gradleFolder.findChild("libs.versions.toml");
                    PsiFile psiFile2 = virtualFile2 != null ? PhysicalFileSystemUtilsKt.toPsiFile(virtualFile2, project) : null;
                    TomlFile tomlFile = psiFile2 instanceof TomlFile ? (TomlFile)psiFile2 : null;
                    if (tomlFile == null) {
                        return false;
                    }
                    TomlFile tomlFile2 = tomlFile;
                    PsiElement $this$childrenOfType$iv = (PsiElement)tomlFile2;
                    boolean $i$f$childrenOfType = false;
                    List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, TomlTable.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TomlTable it = (TomlTable)element$iv;
                        boolean bl = false;
                        TomlKey tomlKey2 = it.getHeader().getKey();
                        if (!Intrinsics.areEqual((Object)(tomlKey2 != null ? tomlKey2.getText() : null), (Object)"libraries")) continue;
                        v8 = element$iv;
                        break block14;
                    }
                    v8 = null;
                }
                TomlTable tomlTable = v8;
                if (tomlTable == null) {
                    return false;
                }
                TomlTable libraryTable = tomlTable;
                Iterable $this$firstOrNull$iv = libraryTable.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    TomlKeyValue entry = (TomlKeyValue)element$iv;
                    boolean bl2 = false;
                    TomlValue tomlValue = entry.getValue();
                    if ((tomlValue instanceof TomlInlineTable ? (TomlInlineTable)tomlValue : null) == null) {
                        bl = false;
                    } else {
                        TomlKeyValue moduleEntry;
                        Object object;
                        Object v11;
                        block15: {
                            TomlInlineTable entryValue;
                            entryValue = entryValue;
                            Iterable $this$firstOrNull$iv2 = entryValue.getEntries();
                            boolean $i$f$firstOrNull2 = false;
                            for (Object element$iv2 : $this$firstOrNull$iv2) {
                                TomlKeyValue it = (TomlKeyValue)element$iv2;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getKey().getText(), (Object)"module")) continue;
                                v11 = element$iv2;
                                break block15;
                            }
                            v11 = null;
                        }
                        bl = (TomlKeyValue)v11 == null ? false : ((object = moduleEntry.getValue()) != null && (object = object.getText()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"org.jetbrains.kotlin:kotlin-gradle-plugin", (boolean)false, (int)2, null) : false);
                    }
                    if (!bl) continue;
                    v13 = element$iv;
                    break block16;
                }
                v13 = null;
            }
            TomlKeyValue tomlKeyValue = v13;
            if (tomlKeyValue == null || (tomlKey = tomlKeyValue.getKey()) == null || (string = tomlKey.getText()) == null) {
                return false;
            }
            String gradlePluginKey = string;
            String string3 = buildSrcBuildFile.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            return StringsKt.contains$default((CharSequence)string3, (CharSequence)gradlePluginKey, (boolean)false, (int)2, null);
        }

        public void setupProject(@NotNull Project project) {
            String string;
            GradleKotlinModuleBuilder moduleBuilder;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.initializeProjectValues(project);
                if (this.getShouldGenerateMultipleModules$kotlin_project_wizard_gradle()) {
                    return;
                }
                moduleBuilder = new GradleKotlinModuleBuilder();
                moduleBuilder.configurePreImport((arg_0, arg_1) -> Step.setupProject$lambda$24(this, project, arg_0, arg_1));
                moduleBuilder.setCreateEmptyContentRoots(false);
                Object object = this.findParentModule(project);
                if (object != null && (object = ((ModuleSourceRootGroup)object).getSourceRootModules()) != null) {
                    for (Module it : (Iterable)object) {
                        boolean bl = false;
                        KotlinGradlePluginVersion kotlinGradlePluginVersion = KotlinGradlePluginVersionKt.getKotlinGradlePluginVersion(it);
                        String string2 = kotlinGradlePluginVersion != null ? kotlinGradlePluginVersion.getVersionString() : null;
                        if (string2 == null) continue;
                        string = string2;
                        break block4;
                    }
                    string = null;
                } else {
                    string = null;
                }
            }
            String parentKotlinVersion = string;
            IdeKotlinVersion pluginManagementVersion = this.getPluginManagementKotlinVersion(project);
            this.setupBuilder(moduleBuilder);
            this.setupBuildScript(moduleBuilder, arg_0 -> Step.setupProject$lambda$29(this, pluginManagementVersion, parentKotlinVersion, project, arg_0));
            this.setupProject(project, moduleBuilder);
        }

        @NotNull
        public GraphProperty<String> getBuildSystemProperty() {
            return this.$$delegate_0.getBuildSystemProperty();
        }

        @NotNull
        public String getBuildSystem() {
            return this.$$delegate_0.getBuildSystem();
        }

        public void setBuildSystem(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.$$delegate_0.setBuildSystem(value);
        }

        @NotNull
        public GraphProperty<String> getLanguageProperty() {
            return this.$$delegate_0.getLanguageProperty();
        }

        @NotNull
        public String getLanguage() {
            return this.$$delegate_0.getLanguage();
        }

        public void setLanguage(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.$$delegate_0.setLanguage(value);
        }

        @NotNull
        public GraphProperty<String> getNameProperty() {
            return this.$$delegate_0.getNameProperty();
        }

        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        public void setName(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.$$delegate_0.setName(value);
        }

        @NotNull
        public GraphProperty<String> getPathProperty() {
            return this.$$delegate_0.getPathProperty();
        }

        @NotNull
        public String getPath() {
            return this.$$delegate_0.getPath();
        }

        public void setPath(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.$$delegate_0.setPath(value);
        }

        @NotNull
        public String getContentEntryPath() {
            return this.$$delegate_0.getContentEntryPath();
        }

        @NotNull
        public Path getProjectPath() {
            return this.$$delegate_0.getProjectPath();
        }

        private static final boolean _init_$lambda$1(Step this$0) {
            Object object;
            Object object2 = this$0;
            try {
                Step $this$lambda_u241_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)GradleVersion.version((String)$this$lambda_u241_u24lambda_u240.getGradleVersion()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            GradleVersion gradleVersion = (GradleVersion)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (gradleVersion == null) {
                return false;
            }
            GradleVersion selectedGradleVersion = gradleVersion;
            return selectedGradleVersion.compareTo(GradleKotlinNewProjectWizardKt.access$getMIN_GRADLE_VERSION_BUILD_SRC$p()) >= 0;
        }

        private static final Unit setupSampleCodeUI$lambda$4$lambda$2(Step this$0, boolean it) {
            NewProjectWizardCollector.Base.INSTANCE.logAddSampleCodeChanged((NewProjectWizardStep)this$0, it);
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeUI$lambda$4$lambda$3(Step this$0) {
            NewProjectWizardCollector.Base.INSTANCE.logAddSampleCodeFinished((NewProjectWizardStep)this$0, this$0.getAddSampleCode());
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeUI$lambda$4(Step this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = UIBundle.message((String)"label.project.wizard.new.project.add.sample.code", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ButtonKt.whenStateChangedFromUi$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (ObservableMutableProperty)((ObservableMutableProperty)this$0.getAddSampleCodeProperty())), null, arg_0 -> Step.setupSampleCodeUI$lambda$4$lambda$2(this$0, arg_0), (int)1, null).onApply(() -> Step.setupSampleCodeUI$lambda$4$lambda$3(this$0));
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeWithOnBoardingTipsUI$lambda$8$lambda$7$lambda$5(Step this$0, boolean it) {
            NewProjectWizardCollector.Base.INSTANCE.logAddSampleOnboardingTipsChanged((NewProjectWizardStep)this$0, it);
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeWithOnBoardingTipsUI$lambda$8$lambda$7$lambda$6(Step this$0) {
            NewProjectWizardCollector.Base.INSTANCE.logAddSampleOnboardingTipsFinished((NewProjectWizardStep)this$0, this$0.getGenerateOnboardingTips());
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeWithOnBoardingTipsUI$lambda$8$lambda$7(Step this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = UIBundle.message((String)"label.project.wizard.new.project.generate.onboarding.tips", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ButtonKt.whenStateChangedFromUi$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (ObservableMutableProperty)((ObservableMutableProperty)this$0.getGenerateOnboardingTipsProperty())), null, arg_0 -> Step.setupSampleCodeWithOnBoardingTipsUI$lambda$8$lambda$7$lambda$5(this$0, arg_0), (int)1, null).onApply(() -> Step.setupSampleCodeWithOnBoardingTipsUI$lambda$8$lambda$7$lambda$6(this$0));
            return Unit.INSTANCE;
        }

        private static final Unit setupSampleCodeWithOnBoardingTipsUI$lambda$8(Step this$0, Panel $this$indent) {
            Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
            Panel.row$default((Panel)$this$indent, null, arg_0 -> Step.setupSampleCodeWithOnBoardingTipsUI$lambda$8$lambda$7(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit setupMultipleModulesUI$lambda$11$lambda$9(Step this$0, boolean it) {
            NewProjectWizardCollector.Kotlin.INSTANCE.logGenerateMultipleModulesChanged((NewProjectWizardStep)this$0, it);
            return Unit.INSTANCE;
        }

        private static final Unit setupMultipleModulesUI$lambda$11$lambda$10(Step this$0) {
            NewProjectWizardCollector.Kotlin.INSTANCE.logGenerateMultipleModulesFinished((NewProjectWizardStep)this$0, this$0.getGenerateMultipleModules());
            return Unit.INSTANCE;
        }

        private static final Unit setupMultipleModulesUI$lambda$11(Step this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.whenStateChangedFromUi$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(KotlinNewProjectWizardUIBundle.message("label.project.wizard.new.project.generate.multiple.modules", new Object[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.generateMultipleModulesProperty)).enabledIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this$0.getGradleDslProperty()), (Object)GradleNewProjectWizardStep.GradleDsl.KOTLIN)), null, arg_0 -> Step.setupMultipleModulesUI$lambda$11$lambda$9(this$0, arg_0), (int)1, null).onApply(() -> Step.setupMultipleModulesUI$lambda$11$lambda$10(this$0));
            Row.contextHelp$default((Row)$this$row, (String)KotlinNewProjectWizardUIBundle.message("tooltip.project.wizard.new.project.generate.multiple.modules", new Object[0]), null, (int)2, null);
            return Unit.INSTANCE;
        }

        private static final void configureSettingsFile$lambda$16$lambda$15(VirtualFile $settingsFile, Project $project) {
            PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)$settingsFile, (Project)$project);
            if (psiFile == null) {
                return;
            }
            PsiFile psiFile2 = psiFile;
            Document document = VirtualFileUtil.findDocument((VirtualFile)$settingsFile);
            if (document == null) {
                return;
            }
            Document document2 = document;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)$project);
            psiDocumentManager.commitDocument(document2);
            GradleBuildScriptManipulator buildScriptSupport = GradleBuildScriptSupport.Companion.getManipulator$default(GradleBuildScriptSupport.Companion, psiFile2, false, 2, null);
            buildScriptSupport.addFoojayPlugin(psiFile2);
        }

        private static final void configureSettingsFile$lambda$16(VirtualFile $settingsFile, Project $project) {
            ApplicationManager.getApplication().runWriteAction(() -> Step.configureSettingsFile$lambda$16$lambda$15($settingsFile, $project));
        }

        private static final void setupProject$lambda$24(Step this$0, Project $project, VirtualFile virtualFile, VirtualFile settingsScriptFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)settingsScriptFile, (String)"settingsScriptFile");
            this$0.configureSettingsFile($project, settingsScriptFile);
        }

        private static final Unit setupProject$lambda$29(Step this$0, IdeKotlinVersion $pluginManagementVersion, String $parentKotlinVersion, Project $project, GradleBuildScriptBuilder $this$setupBuildScript) {
            block1: {
                String string;
                Intrinsics.checkNotNullParameter((Object)$this$setupBuildScript, (String)"$this$setupBuildScript");
                String string2 = string = this$0.kotlinVersionToUse;
                GradleBuildScriptBuilder gradleBuildScriptBuilder = $this$setupBuildScript;
                boolean bl = false;
                boolean bl2 = $pluginManagementVersion != null || $parentKotlinVersion != null || this$0.usesVersionCatalogVersionInBuildSrc($project);
                gradleBuildScriptBuilder.withKotlinJvmPlugin(!bl2 ? string : null);
                $this$setupBuildScript.withKotlinTest();
                Integer n = this$0.selectedJdkJvmTarget;
                if (n == null) break block1;
                Integer n2 = n;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                n = this$0.canUseFoojay ? n2 : null;
                if (n != null) {
                    it = ((Number)n).intValue();
                    boolean bl4 = false;
                    $this$setupBuildScript.withKotlinJvmToolchain(it);
                }
            }
            return Unit.INSTANCE;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Step.class, "addSampleCode", "getAddSampleCode()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Step.class, "generateOnboardingTips", "getGenerateOnboardingTips()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Step.class, "generateMultipleModules", "getGenerateMultipleModules()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

