/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.templates;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.Dependencies;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizardBundle;
import org.jetbrains.kotlin.tools.projectWizard.WizardGradleRunConfiguration;
import org.jetbrains.kotlin.tools.projectWizard.WizardRunConfiguration;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.ListBuilder;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.TemplateSetting;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.ArtifactBasedLibraryDependencyIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.BuildSystemIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.DependencyIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.DependencyType;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.ModuleIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.RepositoryIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.TasksKt;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.ConfiguratorsKt;
import org.jetbrains.kotlin.tools.projectWizard.plugins.StructurePluginKt;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ModuleType;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.JavaPackageKt;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Module;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Repositories;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.SourcesetType;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptor;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptorKt;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileTemplateDescriptorWithPath;
import org.jetbrains.kotlin.tools.projectWizard.templates.Template;
import org.jetbrains.kotlin.tools.projectWizard.templates.TemplateEnvironment;
import org.jetbrains.kotlin.tools.projectWizard.templates.TemplateKt;
import org.jetbrains.kotlin.tools.projectWizard.transformers.interceptors.InterceptionPoint;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n0\u0011R\u00020\u0012j\u0002`\u0013H\u0016J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018*\n0\u001dR\u00020\u0012j\u0002`\u001e2\u0006\u0010\f\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0018*\n0\u001dR\u00020\u0012j\u0002`\u001e2\u0006\u0010\f\u001a\u00020\u001fH\u0016J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0018*\n0\u0011R\u00020\u0012j\u0002`\u00132\u0006\u0010\f\u001a\u00020\u001fH\u0016J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0018*\n0\u0011R\u00020\u0012j\u0002`\u00132\u0006\u0010\f\u001a\u00020\u001fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\u0014\u001a\u00020\u00058\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001d\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180'\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u001d\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180'\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R \u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0'0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001aR\"\u00101\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001a\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/templates/KtorServerTemplate;", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/Template;", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "description", "getDescription", "isApplicableTo", "", "module", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/buildsystem/Module;", "projectKind", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ProjectKind;", "reader", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "id", "getId", "fileToCreate", "filesToOpenInEditor", "", "getFilesToOpenInEditor", "()Ljava/util/List;", "getRequiredLibraries", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/DependencyIR;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Writer;", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/ModuleIR;", "getIrsToAddToBuildFile", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/BuildSystemIR;", "createRunConfigurations", "Lorg/jetbrains/kotlin/tools/projectWizard/WizardRunConfiguration;", "getFileTemplates", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileTemplateDescriptorWithPath;", "imports", "Lorg/jetbrains/kotlin/tools/projectWizard/transformers/interceptors/InterceptionPoint;", "getImports", "()Lorg/jetbrains/kotlin/tools/projectWizard/transformers/interceptors/InterceptionPoint;", "routes", "getRoutes", "elements", "getElements", "interceptionPoints", "", "getInterceptionPoints", "settings", "Lorg/jetbrains/kotlin/tools/projectWizard/core/entity/settings/TemplateSetting;", "getSettings", "kotlin.project-wizard.core"})
public final class KtorServerTemplate
extends Template {
    @NotNull
    public static final KtorServerTemplate INSTANCE = new KtorServerTemplate();
    @NotNull
    private static final String title = KotlinNewProjectWizardBundle.message("module.template.ktor.server.title", new Object[0]);
    @NotNull
    private static final String description = KotlinNewProjectWizardBundle.message("module.template.ktor.server.description", new Object[0]);
    @NonNls
    @NotNull
    private static final String id = "ktorServer";
    @NotNull
    private static final String fileToCreate = "Server.kt";
    @NotNull
    private static final List<String> filesToOpenInEditor = CollectionsKt.listOf((Object)"Server.kt");
    @NotNull
    private static final InterceptionPoint<List<String>> imports = new InterceptionPoint<List>("imports", CollectionsKt.emptyList());
    @NotNull
    private static final InterceptionPoint<List<String>> routes = new InterceptionPoint<List>("routes", CollectionsKt.emptyList());
    @NotNull
    private static final InterceptionPoint<List<String>> elements = new InterceptionPoint<List>("elements", CollectionsKt.emptyList());
    @NotNull
    private static final List<InterceptionPoint<Object>> interceptionPoints;
    @NotNull
    private static final List<TemplateSetting<?, ?>> settings;

    private KtorServerTemplate() {
    }

    @Override
    @NotNull
    public String getTitle() {
        return title;
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    public boolean isApplicableTo(@NotNull Module module, @NotNull ProjectKind projectKind, @NotNull Context.Reader reader) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return ConfiguratorsKt.getModuleType(module.getConfigurator()) == ModuleType.jvm;
    }

    @Override
    @NotNull
    public String getId() {
        return id;
    }

    @Override
    @NotNull
    public List<String> getFilesToOpenInEditor() {
        return filesToOpenInEditor;
    }

    @Override
    @NotNull
    public List<DependencyIR> getRequiredLibraries(@NotNull Context.Writer $this$getRequiredLibraries, @NotNull ModuleIR module) {
        Intrinsics.checkNotNullParameter((Object)$this$getRequiredLibraries, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (List)TemplateKt.withSettingsOf$default(module.getOriginalModule(), null, KtorServerTemplate::getRequiredLibraries$lambda$1, 2, null);
    }

    @Override
    @NotNull
    public List<BuildSystemIR> getIrsToAddToBuildFile(@NotNull Context.Writer $this$getIrsToAddToBuildFile, @NotNull ModuleIR module) {
        Intrinsics.checkNotNullParameter((Object)$this$getIrsToAddToBuildFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.buildList(arg_0 -> KtorServerTemplate.getIrsToAddToBuildFile$lambda$2(module, $this$getIrsToAddToBuildFile, arg_0));
    }

    @Override
    @NotNull
    public List<WizardRunConfiguration> createRunConfigurations(@NotNull Context.Reader $this$createRunConfigurations, @NotNull ModuleIR module) {
        Intrinsics.checkNotNullParameter((Object)$this$createRunConfigurations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.buildList(KtorServerTemplate::createRunConfigurations$lambda$3);
    }

    @Override
    @NotNull
    public List<FileTemplateDescriptorWithPath> getFileTemplates(@NotNull Context.Reader $this$getFileTemplates, @NotNull ModuleIR module) {
        Intrinsics.checkNotNullParameter((Object)$this$getFileTemplates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String packageName = JavaPackageKt.javaPackage(module.getOriginalModule(), StructurePluginKt.pomIR($this$getFileTemplates)).asCodePackage();
        return CollectionsKt.listOf((Object)FileTemplateDescriptorKt.asSrcOf(new FileTemplateDescriptor(this.getId() + "/server.kt.vm", UtilsKt.div(packageName, fileToCreate)), SourcesetType.main));
    }

    @NotNull
    public final InterceptionPoint<List<String>> getImports() {
        return imports;
    }

    @NotNull
    public final InterceptionPoint<List<String>> getRoutes() {
        return routes;
    }

    @NotNull
    public final InterceptionPoint<List<String>> getElements() {
        return elements;
    }

    @Override
    @NotNull
    public List<InterceptionPoint<Object>> getInterceptionPoints() {
        return interceptionPoints;
    }

    @Override
    @NotNull
    public List<TemplateSetting<?, ?>> getSettings() {
        return settings;
    }

    private static final Unit getRequiredLibraries$lambda$1$lambda$0(ListBuilder $this$buildList) {
        Intrinsics.checkNotNullParameter((Object)$this$buildList, (String)"$this$buildList");
        $this$buildList.unaryPlus(new ArtifactBasedLibraryDependencyIR(Dependencies.KTOR.INSTANCE.getKTOR_SERVER_NETTY(), DependencyType.MAIN, null, 4, null));
        $this$buildList.unaryPlus(new ArtifactBasedLibraryDependencyIR(Dependencies.KTOR.INSTANCE.getKTOR_SERVER_HTML_BUILDER(), DependencyType.MAIN, null, 4, null));
        $this$buildList.unaryPlus(new ArtifactBasedLibraryDependencyIR(Dependencies.KOTLINX.INSTANCE.getKOTLINX_HTML(), DependencyType.MAIN, null, 4, null));
        return Unit.INSTANCE;
    }

    private static final List getRequiredLibraries$lambda$1(TemplateEnvironment $this$withSettingsOf) {
        Intrinsics.checkNotNullParameter((Object)$this$withSettingsOf, (String)"$this$withSettingsOf");
        return UtilsKt.buildList(KtorServerTemplate::getRequiredLibraries$lambda$1$lambda$0);
    }

    private static final Unit getIrsToAddToBuildFile$lambda$2(ModuleIR $module, Context.Writer $this_getIrsToAddToBuildFile, ListBuilder $this$buildList) {
        Intrinsics.checkNotNullParameter((Object)$this$buildList, (String)"$this$buildList");
        $this$buildList.unaryPlus(new RepositoryIR(Repositories.INSTANCE.getKTOR()));
        String packageName = JavaPackageKt.javaPackage($module.getOriginalModule(), StructurePluginKt.pomIR($this_getIrsToAddToBuildFile)).asCodePackage();
        $this$buildList.unaryPlus(TasksKt.runTaskIrs$default(packageName + ".ServerKt", null, 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createRunConfigurations$lambda$3(ListBuilder $this$buildList) {
        Intrinsics.checkNotNullParameter((Object)$this$buildList, (String)"$this$buildList");
        $this$buildList.unaryPlus(new WizardGradleRunConfiguration(KotlinNewProjectWizardBundle.message("configuration.name.run", new Object[0]), "run", CollectionsKt.emptyList()));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new InterceptionPoint[3];
        objectArray[0] = imports;
        objectArray[1] = routes;
        objectArray[2] = elements;
        interceptionPoints = CollectionsKt.listOf((Object[])objectArray);
        settings = CollectionsKt.emptyList();
    }
}

