/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.internal;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/analysis/internal/DumpUastTreeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildDump", "", "file", "Lcom/intellij/psi/PsiFile;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.jvm.analysis.impl"})
public class DumpUastTreeAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String dump = (String)ActionsKt.runReadAction(() -> DumpUastTreeAction.actionPerformed$lambda$0(this, file));
        if (dump == null) {
            Notifications.Bus.notify((Notification)new Notification("UAST", JvmAnalysisBundle.message("title.uast", new Object[0]), JvmAnalysisBundle.message("can.t.build.uast.tree.for.file", new Object[0]) + " '" + file.getName() + "'", NotificationType.ERROR));
            return;
        }
        FileEditorManager.getInstance((Project)project2).openEditor(new OpenFileDescriptor(project2, (VirtualFile)new LightVirtualFile(file.getName() + ".uast-log", (Language)PlainTextLanguage.INSTANCE, (CharSequence)dump)), true);
    }

    @Nullable
    public String buildDump(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)file));
        return uElement != null ? UastUtils.asRecursiveLogString$default((UElement)uElement, null, (int)1, null) : null;
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        v0 = e.getPresentation();
        if (!ApplicationManager.getApplication().isInternal()) ** GOTO lbl-1000
        var2_2 = this;
        var5_3 = v0;
        $i$a$-run-DumpUastTreeAction$update$1 = false;
        v1 = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (v1 == null) {
            v2 = false;
        } else {
            file = v1;
            v3 = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getLanguage(...)");
            v2 = UastLanguagePlugin.Companion.byLanguage(v3) != null;
        }
        var6_6 = v2;
        v0 = var5_3;
        if (var6_6) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        v0.setEnabledAndVisible(v4);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final String actionPerformed$lambda$0(DumpUastTreeAction this$0, PsiFile $file) {
        return this$0.buildDump($file);
    }
}

