/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInspection/NonExtendableApiUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "ANNOTATION_NAME", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "NonExtendableApiUsageProcessor", "intellij.jvm.analysis.impl"})
public final class NonExtendableApiUsageInspection
extends LocalInspectionTool {
    @NotNull
    private final String ANNOTATION_NAME;

    public NonExtendableApiUsageInspection() {
        String string = ApiStatus.NonExtendable.class.getCanonicalName();
        Intrinsics.checkNotNull((Object)string);
        this.ANNOTATION_NAME = string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (AnnotatedApiUsageUtil.INSTANCE.canAnnotationBeUsedInFile(this.ANNOTATION_NAME, psiFile)) {
            psiElementVisitor = ApiUsageUastVisitor.Companion.createPsiElementVisitor((ApiUsageProcessor)new NonExtendableApiUsageProcessor(holder));
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInspection/NonExtendableApiUsageInspection$NonExtendableApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/NonExtendableApiUsageInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "isLibraryElement", "", "element", "Lcom/intellij/psi/PsiElement;", "isSuperClassReferenceInSubclassDeclaration", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "superClass", "Lcom/intellij/psi/PsiClass;", "processReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "processLambda", "Lorg/jetbrains/uast/ULambdaExpression;", "processMethodOverriding", "method", "Lorg/jetbrains/uast/UMethod;", "overriddenMethod", "Lcom/intellij/psi/PsiMethod;", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nNonExtendableApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonExtendableApiUsageInspection.kt\ncom/intellij/codeInspection/NonExtendableApiUsageInspection$NonExtendableApiUsageProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1755#2,3:82\n*S KotlinDebug\n*F\n+ 1 NonExtendableApiUsageInspection.kt\ncom/intellij/codeInspection/NonExtendableApiUsageInspection$NonExtendableApiUsageProcessor\n*L\n38#1:82,3\n*E\n"})
    private final class NonExtendableApiUsageProcessor
    implements ApiUsageProcessor {
        @NotNull
        private final ProblemsHolder problemsHolder;

        public NonExtendableApiUsageProcessor(ProblemsHolder problemsHolder) {
            Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
            this.problemsHolder = problemsHolder;
        }

        private final boolean isLibraryElement(PsiElement element) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            return virtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(virtualFile);
        }

        private final boolean isSuperClassReferenceInSubclassDeclaration(UClass subclassDeclaration, PsiClass superClass) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = subclassDeclaration.getUastSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UTypeReferenceExpression it = (UTypeReferenceExpression)element$iv;
                        boolean bl2 = false;
                        if (!superClass.getManager().areElementsEquivalent((PsiElement)superClass, (PsiElement)PsiTypesUtil.getPsiClass((PsiType)it.getType()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!(target instanceof PsiClass) || !((PsiClass)target).hasAnnotation(NonExtendableApiUsageInspection.this.ANNOTATION_NAME)) {
                return;
            }
            UClass classDeclaration = (UClass)UastUtils.findContaining((PsiElement)sourceNode.getSourcePsi(), UClass.class);
            if (classDeclaration == null || !this.isSuperClassReferenceInSubclassDeclaration(classDeclaration, (PsiClass)target)) {
                return;
            }
            PsiElement psiElement = sourceNode.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement elementToHighlight = psiElement;
            if (this.isLibraryElement((PsiElement)target)) {
                String string;
                String string2 = HighlightMessageUtil.getSymbolName((PsiElement)((PsiElement)target));
                if (string2 == null) {
                    return;
                }
                String className = string2;
                if (((PsiClass)target).isInterface()) {
                    if (classDeclaration.isInterface()) {
                        var8_7 = new Object[]{className};
                        string = JvmAnalysisBundle.message("jvm.inspections.api.no.extension.interface.extend.description", var8_7);
                    } else {
                        var8_7 = new Object[]{className};
                        string = JvmAnalysisBundle.message("jvm.inspections.api.no.extension.interface.implement.description", var8_7);
                    }
                } else {
                    var8_7 = new Object[]{className};
                    string = JvmAnalysisBundle.message("jvm.inspections.api.no.extension.class.description", var8_7);
                }
                String description = string;
                this.problemsHolder.registerProblem(elementToHighlight, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        public void processLambda(@NotNull ULambdaExpression sourceNode, @NotNull PsiModifierListOwner target) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.processReference((UElement)sourceNode, target, null);
        }

        public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)overriddenMethod, (String)"overriddenMethod");
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)method.getUastAnchor());
            if (psiElement == null) {
                return;
            }
            PsiElement elementToHighlight = psiElement;
            if (overriddenMethod.hasAnnotation(NonExtendableApiUsageInspection.this.ANNOTATION_NAME) && this.isLibraryElement((PsiElement)overriddenMethod)) {
                String string = HighlightMessageUtil.getSymbolName((PsiElement)((PsiElement)overriddenMethod));
                if (string == null) {
                    return;
                }
                String methodName = string;
                Object[] objectArray = new Object[]{methodName};
                String description = JvmAnalysisBundle.message("jvm.inspections.api.no.extension.method.overriding.description", objectArray);
                this.problemsHolder.registerProblem(elementToHighlight, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }
}

