/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"EXEC_MAVEN_PLUGIN_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "getExecArgsFromPomXml", "", "project", "Lcom/intellij/openapi/project/Project;", "runnerParameters", "Lorg/jetbrains/idea/maven/execution/MavenRunnerParameters;", "appendToClassPath", "", "execArgs", "Lcom/intellij/execution/configurations/ParametersList;", "classPath", "intellij.maven"})
public final class ExecRemoteConnectionCreatorKt {
    private static final Pattern EXEC_MAVEN_PLUGIN_PATTERN = Pattern.compile("org[.]codehaus[.]mojo:exec-maven-plugin(:[\\d.]+)?:exec");

    private static final String getExecArgsFromPomXml(Project project, MavenRunnerParameters runnerParameters) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)runnerParameters.getWorkingDirFile(), (boolean)false);
        if (virtualFile == null) {
            return "";
        }
        VirtualFile workingDir = virtualFile;
        String pomFileName = StringUtil.defaultIfEmpty((String)runnerParameters.getPomFileName(), (String)"pom.xml");
        VirtualFile virtualFile2 = workingDir.findChild(pomFileName);
        if (virtualFile2 == null) {
            return "";
        }
        VirtualFile pomFile = virtualFile2;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(project, pomFile);
        if (mavenDomProjectModel == null) {
            return "";
        }
        MavenDomProjectModel projectModel = mavenDomProjectModel;
        String string = MavenPropertyResolver.resolve("${exec.args}", projectModel);
        if (string == null) {
            return "";
        }
        return string;
    }

    private static final void appendToClassPath(ParametersList execArgs, String classPath) {
        List list = execArgs.getList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        List execArgsList = list;
        int classPathIndex = execArgsList.indexOf("-classpath");
        if (classPathIndex == -1) {
            classPathIndex = execArgsList.indexOf("-cp");
        }
        if (classPathIndex == -1) {
            String[] stringArray = new String[]{"-classpath", "%classpath" + File.pathSeparator + classPath};
            execArgs.prependAll(stringArray);
        } else if (classPathIndex + 1 == execArgsList.size()) {
            execArgs.add("%classpath" + File.pathSeparator + classPath);
        } else {
            String oldClassPath = execArgs.get(classPathIndex + 1);
            execArgs.set(classPathIndex + 1, oldClassPath + File.pathSeparator + classPath);
        }
    }

    public static final /* synthetic */ String access$getExecArgsFromPomXml(Project project, MavenRunnerParameters runnerParameters) {
        return ExecRemoteConnectionCreatorKt.getExecArgsFromPomXml(project, runnerParameters);
    }

    public static final /* synthetic */ void access$appendToClassPath(ParametersList execArgs, String classPath) {
        ExecRemoteConnectionCreatorKt.appendToClassPath(execArgs, classPath);
    }

    public static final /* synthetic */ Pattern access$getEXEC_MAVEN_PLUGIN_PATTERN$p() {
        return EXEC_MAVEN_PLUGIN_PATTERN;
    }
}

