/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenConfigOpenQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "mavenConfig", "Lcom/intellij/openapi/vfs/VirtualFile;", "errorMessage", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "id", "getId", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.maven"})
public final class MavenConfigOpenQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final VirtualFile mavenConfig;
    @NotNull
    private final String errorMessage;
    @NotNull
    private final String id;

    public MavenConfigOpenQuickFix(@NotNull VirtualFile mavenConfig, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)mavenConfig, (String)"mavenConfig");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.mavenConfig = mavenConfig;
        this.errorMessage = errorMessage;
        this.id = "open_maven_config_quick_fix";
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        String search2 = null;
        if (StringsKt.contains$default((CharSequence)this.errorMessage, (CharSequence)":", (boolean)false, (int)2, null)) {
            String string = this.errorMessage.substring(StringsKt.lastIndexOf$default((CharSequence)this.errorMessage, (String)":", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            search2 = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)":", (String)"", (boolean)false, (int)4, null), (String)"\"", (String)"", (boolean)false, (int)4, null), (String)"'", (String)"", (boolean)false, (int)4, null))).toString();
        }
        Path path = this.mavenConfig.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        OpenFileQuickFix.Companion.showFile(project, path, search2);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }
}

