/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.WslMavenDistribution;
import org.jetbrains.idea.maven.server.wsl.WslMavenServerRemoteProcessSupport;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/server/wsl/WslMavenRemoteProcessSupportFactory;", "Lorg/jetbrains/idea/maven/server/MavenRemoteProcessSupportFactory;", "<init>", "()V", "create", "Lorg/jetbrains/idea/maven/server/MavenRemoteProcessSupportFactory$MavenRemoteProcessSupport;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "project", "Lcom/intellij/openapi/project/Project;", "debugPort", "", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/MavenDistribution;Lcom/intellij/openapi/project/Project;Ljava/lang/Integer;)Lorg/jetbrains/idea/maven/server/MavenRemoteProcessSupportFactory$MavenRemoteProcessSupport;", "toWslMavenDistribution", "Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "isApplicable", "", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nWslMavenRemoteProcessSupportFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslMavenRemoteProcessSupportFactory.kt\norg/jetbrains/idea/maven/server/wsl/WslMavenRemoteProcessSupportFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class WslMavenRemoteProcessSupportFactory
implements MavenRemoteProcessSupportFactory {
    @Override
    @NotNull
    public MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport create(@NotNull Sdk jdk, @Nullable String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull Project project, @Nullable Integer debugPort) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                string = project.getBasePath();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(it);
                string = wSLDistribution;
                if (wSLDistribution != null) break block3;
            }
            throw new IllegalArgumentException("Project " + project + " is not WSL based!");
        }
        String wslDistribution = string;
        MavenLog.LOG.info("Use WSL maven distribution at " + mavenDistribution);
        MavenActionsUsagesCollector.trigger(project, MavenActionsUsagesCollector.START_WSL_MAVEN_SERVER);
        WslMavenDistribution wslMavenDistribution = this.toWslMavenDistribution(mavenDistribution, (WSLDistribution)wslDistribution);
        return new WslMavenServerRemoteProcessSupport((WSLDistribution)wslDistribution, jdk, vmOptions, wslMavenDistribution, project, debugPort);
    }

    private final WslMavenDistribution toWslMavenDistribution(MavenDistribution mavenDistribution, WSLDistribution wslDistribution) {
        if (mavenDistribution instanceof WslMavenDistribution) {
            return (WslMavenDistribution)mavenDistribution;
        }
        if (mavenDistribution instanceof LocalMavenDistribution) {
            String string = wslDistribution.getWslPath(((LocalMavenDistribution)mavenDistribution).getMavenHome().toAbsolutePath());
            if (string == null) {
                throw new IllegalArgumentException("Cannot use mavenDistribution " + mavenDistribution);
            }
            String it = string;
            boolean bl = false;
            return new WslMavenDistribution(wslDistribution, it, it);
        }
        throw new IllegalArgumentException("Cannot use mavenDistribution " + mavenDistribution);
    }

    @Override
    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MavenWslUtil.useWslMaven(project);
    }
}

