/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.ui.NamedColorUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenTreeStructureProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "MavenPomFileNode", "intellij.maven"})
public final class MavenTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<? extends AbstractTreeNode<?>> children, @NotNull ViewSettings settings) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Project project = parent.getProject();
        if (project == null) {
            return children;
        }
        Project project2 = project;
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        if (!manager.isMavenizedProject()) {
            return children;
        }
        if (parent instanceof ProjectViewProjectNode || parent instanceof PsiDirectoryNode) {
            Collection modifiedChildren = (Collection)new SmartList();
            for (AbstractTreeNode<?> child : children) {
                Object childToAdd = null;
                childToAdd = child;
                if (child instanceof PsiFileNode && ((PsiFileNode)child).getVirtualFile() != null) {
                    VirtualFile virtualFile = ((PsiFileNode)child).getVirtualFile();
                    Intrinsics.checkNotNull((Object)virtualFile);
                    if (MavenUtil.isPotentialPomFile(virtualFile.getName())) {
                        VirtualFile virtualFile2 = ((PsiFileNode)child).getVirtualFile();
                        Intrinsics.checkNotNull((Object)virtualFile2);
                        if (manager.findProject(virtualFile2) != null) {
                            MavenProject mavenProject;
                            boolean bl = false;
                            Object object = ((PsiFileNode)child).getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                            childToAdd = new MavenPomFileNode(project2, (PsiFile)object, settings, manager.isIgnored(mavenProject));
                        }
                    }
                }
                modifiedChildren.add(childToAdd);
            }
            return modifiedChildren;
        }
        return children;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenTreeStructureProvider$MavenPomFileNode;", "Lcom/intellij/ide/projectView/impl/nodes/PsiFileNode;", "project", "Lcom/intellij/openapi/project/Project;", "value", "Lcom/intellij/psi/PsiFile;", "viewSettings", "Lcom/intellij/ide/projectView/ViewSettings;", "isIgnored", "", "<init>", "(Lorg/jetbrains/idea/maven/utils/MavenTreeStructureProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/ide/projectView/ViewSettings;Z)V", "()Z", "strikeAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getStrikeAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "updateImpl", "", "data", "Lcom/intellij/ide/projectView/PresentationData;", "getTestPresentation", "", "intellij.maven"})
    private final class MavenPomFileNode
    extends PsiFileNode {
        private final boolean isIgnored;
        @NotNull
        private final SimpleTextAttributes strikeAttributes;

        public MavenPomFileNode(@NotNull Project project, @Nullable PsiFile value, ViewSettings viewSettings, boolean isIgnored) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(project, value, viewSettings);
            this.isIgnored = isIgnored;
            this.strikeAttributes = new SimpleTextAttributes(4, NamedColorUtil.getInactiveTextColor());
        }

        public final boolean isIgnored() {
            return this.isIgnored;
        }

        @NotNull
        public final SimpleTextAttributes getStrikeAttributes() {
            return this.strikeAttributes;
        }

        protected void updateImpl(@NotNull PresentationData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (this.isIgnored) {
                Object object = this.getValue();
                Intrinsics.checkNotNull((Object)object);
                data.addText(((PsiFile)object).getName(), this.strikeAttributes);
            }
            super.updateImpl(data);
        }

        @NotNull
        public String getTestPresentation() {
            if (this.isIgnored) {
                return "-MavenPomFileNode:" + super.getTestPresentation() + " (ignored)";
            }
            return "-MavenPomFileNode:" + super.getTestPresentation();
        }
    }
}

