/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.DelimitedLinkNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class AutoLink
extends DelimitedLinkNode {
    public AutoLink() {
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.pageRef, this.anchorMarker, this.anchorRef, this.closingMarker};
    }

    @Override
    @NotNull
    public BasedSequence[] getSegmentsForChars() {
        return new BasedSequence[]{this.openingMarker, this.pageRef, this.anchorMarker, this.anchorRef, this.closingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        AutoLink.segmentSpanChars(out, this.openingMarker, "open");
        AutoLink.segmentSpanChars(out, this.text, "text");
        if (this.pageRef.isNotNull()) {
            AutoLink.segmentSpanChars(out, this.pageRef, "pageRef");
        }
        if (this.anchorMarker.isNotNull()) {
            AutoLink.segmentSpanChars(out, this.anchorMarker, "anchorMarker");
        }
        if (this.anchorRef.isNotNull()) {
            AutoLink.segmentSpanChars(out, this.anchorRef, "anchorRef");
        }
        AutoLink.segmentSpanChars(out, this.closingMarker, "close");
    }

    public AutoLink(BasedSequence chars) {
        super(chars);
    }

    public AutoLink(BasedSequence openingMarker, BasedSequence text2, BasedSequence closingMarker) {
        super(openingMarker, text2, closingMarker);
        this.setUrlChars(text2);
    }
}

