/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHRepository;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "sharedProjectSettings", "Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "currentUser", "repo", "Lorg/jetbrains/plugins/github/api/data/GHRepository;", "<init>", "(Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;Lorg/jetbrains/plugins/github/api/data/GHUser;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lorg/jetbrains/plugins/github/api/data/GHUser;Lorg/jetbrains/plugins/github/api/data/GHRepository;)V", "getGhostUser", "()Lorg/jetbrains/plugins/github/api/data/GHUser;", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getCurrentUser", "isCurrentUser", "", "user", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "currentUserHasPermissionLevel", "level", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermissionLevel;", "isMergeAllowed", "isRebaseMergeAllowed", "isSquashMergeAllowed", "isMergeForbiddenForProject", "intellij.vcs.github"})
public final class GHPRSecurityServiceImpl
implements GHPRSecurityService {
    @NotNull
    private final GithubSharedProjectSettings sharedProjectSettings;
    @NotNull
    private final GHUser ghostUser;
    @NotNull
    private final GithubAccount account;
    @NotNull
    private final GHUser currentUser;
    @NotNull
    private final GHRepository repo;

    public GHPRSecurityServiceImpl(@NotNull GithubSharedProjectSettings sharedProjectSettings, @NotNull GHUser ghostUser, @NotNull GithubAccount account, @NotNull GHUser currentUser, @NotNull GHRepository repo) {
        Intrinsics.checkNotNullParameter((Object)sharedProjectSettings, (String)"sharedProjectSettings");
        Intrinsics.checkNotNullParameter((Object)ghostUser, (String)"ghostUser");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        this.sharedProjectSettings = sharedProjectSettings;
        this.ghostUser = ghostUser;
        this.account = account;
        this.currentUser = currentUser;
        this.repo = repo;
    }

    @Override
    @NotNull
    public GHUser getGhostUser() {
        return this.ghostUser;
    }

    @Override
    @NotNull
    public GithubAccount getAccount() {
        return this.account;
    }

    @Override
    @NotNull
    public GHUser getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public boolean isCurrentUser(@NotNull GithubUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return Intrinsics.areEqual((Object)user.getNodeId(), (Object)this.getCurrentUser().getId());
    }

    @Override
    public boolean currentUserHasPermissionLevel(@NotNull GHRepositoryPermissionLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        GHRepositoryPermissionLevel gHRepositoryPermissionLevel = this.repo.getViewerPermission();
        return (gHRepositoryPermissionLevel != null ? gHRepositoryPermissionLevel.ordinal() : -1) >= level.ordinal();
    }

    @Override
    public boolean isMergeAllowed() {
        return this.repo.getMergeCommitAllowed();
    }

    @Override
    public boolean isRebaseMergeAllowed() {
        return this.repo.getRebaseMergeAllowed();
    }

    @Override
    public boolean isSquashMergeAllowed() {
        return this.repo.getSquashMergeAllowed();
    }

    @Override
    public boolean isMergeForbiddenForProject() {
        return this.sharedProjectSettings.getPullRequestMergeForbidden();
    }
}

