/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlock;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.SyntheticKotlinBlock;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u0012JN\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH$J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H$J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000fH$J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH$J\b\u0010\u001f\u001a\u00020 H$J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020 H$J\n\u0010#\u001a\u0004\u0018\u00010$H$J\u001a\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010$H$J\b\u0010(\u001a\u00020\tH$J\u0006\u0010)\u001a\u00020 J\u0006\u0010*\u001a\u00020 J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000fJ\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001e\u0010.\u001a\u00020\u0010*\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020 H\u0002J*\u00100\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00101\u001a\u00020\u00102\b\b\u0002\u00102\u001a\u00020\u001eH\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00107\u001a\u00020\u00152\u0006\u0010/\u001a\u00020 H\u0002J&\u00108\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u00109\u001a\u0004\u0018\u00010\u00032\b\u0010:\u001a\u0004\u0018\u00010\u0010H\u0002JL\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00102\u001a\u00020\u001e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0010H\u0002J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\u00152\u0006\u0010>\u001a\u00020\u0003H\u0002J\u0010\u0010?\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010@\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010A\u001a\u00020\tH\u0002JS\u0010B\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2'\u0010C\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0006\u0012\u0004\u0018\u00010\u00170Dj\u0002`H2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH\u0002J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002JG\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010K\u001a\u00020\t2'\u0010C\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0006\u0012\u0004\u0018\u00010\u00170Dj\u0002`HH\u0002J\u001e\u0010L\u001a\u00020M2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00030OH\u0002J)\u0010P\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0006\u0012\u0004\u0018\u00010\u00170Dj\u0002`HH\u0002J9\u0010Q\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0006\u0012\u0004\u0018\u00010\u00170Dj\u0002`H2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020SH\u0002J&\u0010W\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010X\u001a\u00020 2\u0006\u0010Y\u001a\u00020S2\u0006\u0010Z\u001a\u00020SH\u0002J$\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020 0D2\u0006\u0010\\\u001a\u00020S2\u0006\u0010Z\u001a\u00020SH\u0002J9\u0010]\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0006\u0012\u0004\u0018\u00010\u00170Dj\u0002`H2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020SH\u0002Jw\u0010^\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0006\u0012\u0004\u0018\u00010\u00170Dj\u0002`H2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010S2\n\b\u0002\u0010T\u001a\u0004\u0018\u00010S2\b\b\u0002\u0010_\u001a\u00020 2\u0014\b\u0002\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020 0D2\u0014\b\u0002\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020 0DH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00103\u001a\u00020 *\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0018\u0010U\u001a\u00020 *\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u00105\u00a8\u0006b"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock;", "", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "alignmentStrategy", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "overrideChildren", "Lkotlin/sequences/Sequence;", "<init>", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;Lkotlin/sequences/Sequence;)V", "mySubBlocks", "", "Lcom/intellij/formatting/ASTBlock;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "createBlock", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "Lcom/intellij/formatting/Wrap;", "createSyntheticSpacingNodeBlock", "getSubBlocks", "Lcom/intellij/formatting/Block;", "getSuperChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "isIncompleteInSuper", "", "getAlignmentForCaseBranch", "shouldAlignInColumns", "getAlignment", "Lcom/intellij/formatting/Alignment;", "createAlignmentStrategy", "alignOption", "defaultAlignment", "getNullAlignmentStrategy", "isLeaf", "isIncomplete", "buildChildren", "splitSubBlocksOnDot", "nodeSubBlocks", "processBlock", "enforceIndentToChildren", "replaceBlock", "block", "index", "wrapForFirstCallInChainIsAllowed", "getWrapForFirstCallInChainIsAllowed", "(Lcom/intellij/lang/ASTNode;)Z", "createWrapForQualifierExpression", "createIndentForQualifierExpression", "wrapToBlock", "anchor", "parentBlock", "splitAtIndex", "splitSubBlocksOnElvis", "createChildIndent", "child", "isInCodeChunk", "getChildAttributes", "getChildrenAlignmentStrategy", "buildSubBlock", "wrappingStrategy", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "childElement", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "buildSubBlocks", "buildSubBlocksForChildNode", "childrenAlignmentStrategy", "collectBinaryExpressionChildren", "", "result", "", "getWrappingStrategy", "defaultTrailingCommaWrappingStrategy", "leftAnchor", "Lcom/intellij/psi/tree/IElementType;", "rightAnchor", "addTrailingComma", "getAddTrailingComma", "notDelimiterSiblingNodeInSequence", "forward", "delimiterType", "typeOfLastElement", "thisOrPrevIsMultiLineElement", "typeOfFirstElement", "trailingCommaWrappingStrategyWithMultiLineCheck", "trailingCommaWrappingStrategy", "checkTrailingComma", "filter", "additionalCheck", "kotlin.formatter.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinCommonBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCommonBlock.kt\norg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,1230:1\n1#2:1231\n1557#3:1232\n1628#3,3:1233\n150#4:1236\n*S KotlinDebug\n*F\n+ 1 KotlinCommonBlock.kt\norg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock\n*L\n524#1:1232\n524#1:1233,3\n700#1:1236\n*E\n"})
public abstract class KotlinCommonBlock {
    @NotNull
    private final ASTNode node;
    @NotNull
    private final CodeStyleSettings settings;
    @NotNull
    private final KotlinSpacingBuilder spacingBuilder;
    @NotNull
    private final CommonAlignmentStrategy alignmentStrategy;
    @Nullable
    private final Sequence<ASTNode> overrideChildren;
    @Nullable
    private volatile List<? extends ASTBlock> mySubBlocks;

    public KotlinCommonBlock(@NotNull ASTNode node, @NotNull CodeStyleSettings settings, @NotNull KotlinSpacingBuilder spacingBuilder, @NotNull CommonAlignmentStrategy alignmentStrategy, @Nullable Sequence<? extends ASTNode> overrideChildren) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacingBuilder, (String)"spacingBuilder");
        Intrinsics.checkNotNullParameter((Object)alignmentStrategy, (String)"alignmentStrategy");
        this.node = node;
        this.settings = settings;
        this.spacingBuilder = spacingBuilder;
        this.alignmentStrategy = alignmentStrategy;
        this.overrideChildren = overrideChildren;
    }

    public /* synthetic */ KotlinCommonBlock(ASTNode aSTNode, CodeStyleSettings codeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, CommonAlignmentStrategy commonAlignmentStrategy, Sequence sequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            sequence = null;
        }
        this(aSTNode, codeStyleSettings, kotlinSpacingBuilder, commonAlignmentStrategy, (Sequence<? extends ASTNode>)sequence);
    }

    @NotNull
    public final TextRange getTextRange() {
        if (this.overrideChildren != null) {
            return new TextRange(((ASTNode)SequencesKt.first(this.overrideChildren)).getStartOffset(), ((ASTNode)SequencesKt.last(this.overrideChildren)).getTextRange().getEndOffset());
        }
        TextRange textRange = this.node.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    @NotNull
    protected abstract ASTBlock createBlock(@NotNull ASTNode var1, @NotNull CommonAlignmentStrategy var2, @Nullable Indent var3, @Nullable Wrap var4, @NotNull CodeStyleSettings var5, @NotNull KotlinSpacingBuilder var6, @Nullable Sequence<? extends ASTNode> var7);

    public static /* synthetic */ ASTBlock createBlock$default(KotlinCommonBlock kotlinCommonBlock, ASTNode aSTNode, CommonAlignmentStrategy commonAlignmentStrategy, Indent indent, Wrap wrap, CodeStyleSettings codeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, Sequence sequence, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBlock");
        }
        if ((n & 0x40) != 0) {
            sequence = null;
        }
        return kotlinCommonBlock.createBlock(aSTNode, commonAlignmentStrategy, indent, wrap, codeStyleSettings, kotlinSpacingBuilder, (Sequence<? extends ASTNode>)sequence);
    }

    @NotNull
    protected abstract ASTBlock createSyntheticSpacingNodeBlock(@NotNull ASTNode var1);

    @NotNull
    protected abstract List<Block> getSubBlocks();

    @NotNull
    protected abstract ChildAttributes getSuperChildAttributes(int var1);

    protected abstract boolean isIncompleteInSuper();

    @NotNull
    protected abstract CommonAlignmentStrategy getAlignmentForCaseBranch(boolean var1);

    @Nullable
    protected abstract Alignment getAlignment();

    @NotNull
    protected abstract CommonAlignmentStrategy createAlignmentStrategy(boolean var1, @Nullable Alignment var2);

    @NotNull
    protected abstract CommonAlignmentStrategy getNullAlignmentStrategy();

    public final boolean isLeaf() {
        return this.node.getFirstChildNode() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isIncomplete() {
        if (this.isIncompleteInSuper()) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.node.getElementType(), (Object)KtNodeTypes.MODIFIER_LIST)) return false;
        ASTNode aSTNode = this.node.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.CLASS_BODY)) return false;
        return true;
    }

    @NotNull
    public final List<Block> buildChildren() {
        if (this.mySubBlocks != null) {
            List<? extends ASTBlock> list = this.mySubBlocks;
            Intrinsics.checkNotNull(list);
            return list;
        }
        List<ASTBlock> nodeSubBlocks = this.buildSubBlocks();
        if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(this.node.getElementType())) {
            nodeSubBlocks = this.splitSubBlocksOnDot(nodeSubBlocks);
        } else {
            PsiElement psi = this.node.getPsi();
            if (psi instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)psi).getOperationToken(), (Object)KtTokens.ELVIS)) {
                nodeSubBlocks = this.splitSubBlocksOnElvis(nodeSubBlocks);
            }
        }
        this.mySubBlocks = nodeSubBlocks;
        return nodeSubBlocks;
    }

    private final List<ASTBlock> splitSubBlocksOnDot(List<? extends ASTBlock> nodeSubBlocks) {
        ASTNode aSTNode = this.node.getTreeParent();
        boolean bl = aSTNode != null ? KotlinCommonBlockKt.access$isQualifier(aSTNode) : false;
        if (bl || KotlinCommonBlockKt.access$isCallChainWithoutWrap(this.node)) {
            return nodeSubBlocks;
        }
        int operationBlockIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p());
        if (operationBlockIndex == -1) {
            return nodeSubBlocks;
        }
        ASTBlock block = (ASTBlock)CollectionsKt.first(nodeSubBlocks);
        Wrap wrap = this.createWrapForQualifierExpression(this.node);
        boolean enforceIndentToChildren = KotlinCommonBlockKt.access$anyCallInCallChainIsWrapped(this.node);
        Indent indent = this.createIndentForQualifierExpression(enforceIndentToChildren);
        ASTBlock newBlock = this.processBlock(block, wrap, enforceIndentToChildren);
        return KotlinCommonBlock.splitAtIndex$default(this, this.replaceBlock(nodeSubBlocks, newBlock, 0), operationBlockIndex, indent, wrap, null, null, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ASTBlock processBlock(ASTBlock $this$processBlock, Wrap wrap, boolean enforceIndentToChildren) {
        void it;
        Wrap wrap2;
        ASTNode currentNode = FormatterUtilKt.requireNode($this$processBlock);
        boolean enforceIndent = enforceIndentToChildren && KotlinCommonBlockKt.access$anyCallInCallChainIsWrapped(currentNode);
        Indent indent = this.createIndentForQualifierExpression(enforceIndent);
        List list = $this$processBlock.getSubBlocks();
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.formatting.ASTBlock>");
        List subBlocks = list;
        IElementType iElementType = currentNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (!Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.POSTFIX_EXPRESSION) && !KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(elementType)) {
            return $this$processBlock;
        }
        int index = 0;
        if (this.getWrapForFirstCallInChainIsAllowed(currentNode)) {
            wrap2 = wrap;
            if (wrap2 == null) {
                wrap2 = this.createWrapForQualifierExpression(currentNode);
            }
        } else {
            wrap2 = null;
        }
        Wrap resultWrap = wrap2;
        ASTBlock newBlock = this.processBlock((ASTBlock)subBlocks.get(index), resultWrap, enforceIndent);
        List<ASTBlock> list2 = this.replaceBlock(subBlocks, newBlock, index);
        KotlinCommonBlock kotlinCommonBlock = this;
        boolean bl = false;
        int operationIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(subBlocks, KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p());
        return kotlinCommonBlock.wrapToBlock((List<? extends ASTBlock>)(operationIndex != -1 ? KotlinCommonBlock.splitAtIndex$default(this, (List)it, operationIndex, indent, resultWrap, null, null, 24, null) : it), currentNode, $this$processBlock);
    }

    private final List<ASTBlock> replaceBlock(List<? extends ASTBlock> $this$replaceBlock, ASTBlock block, int index) {
        List list;
        List $this$replaceBlock_u24lambda_u241 = list = CollectionsKt.toMutableList((Collection)$this$replaceBlock);
        boolean bl = false;
        $this$replaceBlock_u24lambda_u241.set(index, block);
        return list;
    }

    static /* synthetic */ List replaceBlock$default(KotlinCommonBlock kotlinCommonBlock, List list, ASTBlock aSTBlock, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replaceBlock");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return kotlinCommonBlock.replaceBlock(list, aSTBlock, n);
    }

    private final boolean getWrapForFirstCallInChainIsAllowed(ASTNode $this$wrapForFirstCallInChainIsAllowed) {
        ASTNode aSTNode = KotlinCommonBlockKt.access$unwrapQualifier($this$wrapForFirstCallInChainIsAllowed);
        if (!(aSTNode != null ? KotlinCommonBlockKt.access$isCall(aSTNode) : false)) {
            return false;
        }
        return CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).WRAP_FIRST_METHOD_IN_CALL_CHAIN || KotlinCommonBlockKt.access$receiverIsCall($this$wrapForFirstCallInChainIsAllowed);
    }

    private final Wrap createWrapForQualifierExpression(ASTNode node) {
        return this.getWrapForFirstCallInChainIsAllowed(node) && KotlinCommonBlockKt.access$receiverIsCall(node) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).METHOD_CALL_CHAIN_WRAP, (boolean)true) : null;
    }

    private final Indent createIndentForQualifierExpression(boolean enforceIndentToChildren) {
        Indent.Type indentType = CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_FOR_CHAINED_CALLS ? (enforceIndentToChildren ? Indent.Type.CONTINUATION : Indent.Type.CONTINUATION_WITHOUT_FIRST) : Indent.Type.NORMAL;
        Indent indent = Indent.getIndent((Indent.Type)indentType, (boolean)false, (boolean)enforceIndentToChildren);
        Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getIndent(...)");
        return indent;
    }

    private final ASTBlock wrapToBlock(List<? extends ASTBlock> $this$wrapToBlock, ASTNode anchor, ASTBlock parentBlock) {
        return (ASTBlock)CollectionsKt.single(this.splitAtIndex($this$wrapToBlock, 0, null, null, anchor, parentBlock));
    }

    private final List<ASTBlock> splitAtIndex(List<? extends ASTBlock> $this$splitAtIndex, int index, Indent indent, Wrap wrap, ASTNode anchor, ASTBlock parentBlock) {
        ASTBlock operationBlock = $this$splitAtIndex.get(index);
        ASTBlock aSTBlock = parentBlock;
        Function1 createParentSyntheticSpacingBlock = aSTBlock != null ? arg_0 -> KotlinCommonBlock.splitAtIndex$lambda$2(aSTBlock, arg_0) : arg_0 -> KotlinCommonBlock.splitAtIndex$lambda$3(this, arg_0);
        ASTNode aSTNode = anchor;
        if (aSTNode == null) {
            aSTNode = FormatterUtilKt.requireNode(operationBlock);
        }
        SyntheticKotlinBlock operationSyntheticBlock = new SyntheticKotlinBlock(aSTNode, $this$splitAtIndex.subList(index, $this$splitAtIndex.size()), null, indent, wrap, this.spacingBuilder, (Function1<? super ASTNode, ? extends ASTBlock>)createParentSyntheticSpacingBlock);
        return CollectionsKt.plus((Collection)$this$splitAtIndex.subList(0, index), (Object)operationSyntheticBlock);
    }

    static /* synthetic */ List splitAtIndex$default(KotlinCommonBlock kotlinCommonBlock, List list, int n, Indent indent, Wrap wrap, ASTNode aSTNode, ASTBlock aSTBlock, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: splitAtIndex");
        }
        if ((n2 & 8) != 0) {
            aSTNode = null;
        }
        if ((n2 & 0x10) != 0) {
            aSTBlock = null;
        }
        return kotlinCommonBlock.splitAtIndex(list, n, indent, wrap, aSTNode, aSTBlock);
    }

    private final List<ASTBlock> splitSubBlocksOnElvis(List<? extends ASTBlock> nodeSubBlocks) {
        int elvisIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, KotlinCommonBlockKt.access$getELVIS_SET$p());
        if (elvisIndex >= 0) {
            Indent indent = CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ELVIS ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            return KotlinCommonBlock.splitAtIndex$default(this, nodeSubBlocks, elvisIndex, indent, null, null, null, 24, null);
        }
        return nodeSubBlocks;
    }

    private final Indent createChildIndent(ASTNode child) {
        ASTNode prev;
        ASTNode childParent = child.getTreeParent();
        IElementType iElementType = child.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType childType = iElementType;
        if (childParent != null && this.isInCodeChunk(childParent)) {
            return Indent.getNoneIndent();
        }
        if (childParent != null && childParent.getPsi() instanceof KtDeclaration && (prev = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child)) != null && KtTokens.COMMENTS.contains(prev.getElementType()) && KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(prev, false, 2, null) == null) {
            return Indent.getNoneIndent();
        }
        for (ASTNode strategy : KotlinCommonBlockKt.access$getINDENT_RULES$p()) {
            Indent indent = strategy.getIndent(child, this.settings);
            if (indent == null) continue;
            return indent;
        }
        if (childParent != null) {
            IElementType iElementType2 = childParent.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
            IElementType parentType = iElementType2;
            if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST || parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
                ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child);
                if (!(childType != KtTokens.RPAR || prev2 != null && prev2.getElementType() == KtTokens.COMMA && KotlinCommonBlockKt.access$hasDoubleLineBreakBefore(child))) {
                    return Indent.getNoneIndent();
                }
                return CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getContinuationWithoutFirstIndent() : Indent.getNormalIndent();
            }
            if (parentType == KtNodeTypes.TYPE_PARAMETER_LIST || parentType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    private final boolean isInCodeChunk(ASTNode node) {
        ASTNode aSTNode = node.getTreeParent();
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent = aSTNode;
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.BLOCK)) {
            return false;
        }
        IElementType iElementType = parent.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType parentType = iElementType;
        return Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.SCRIPT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.BLOCK_CODE_FRAGMENT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.EXPRESSION_CODE_FRAGMENT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.TYPE_CODE_FRAGMENT);
    }

    @NotNull
    public final ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (this.isInCodeChunk(this.node)) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.IF)) {
            ASTBlock elseBlock;
            List<? extends ASTBlock> list = this.mySubBlocks;
            ASTBlock aSTBlock = elseBlock = list != null ? (ASTBlock)CollectionsKt.getOrNull(list, (int)newChildIndex) : null;
            if (elseBlock != null && Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(elseBlock).getElementType(), (Object)KtTokens.ELSE_KEYWORD)) {
                ChildAttributes childAttributes2 = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
                Intrinsics.checkNotNullExpressionValue((Object)childAttributes2, (String)"DELEGATE_TO_NEXT_CHILD");
                return childAttributes2;
            }
        }
        if (newChildIndex > 0) {
            List<? extends ASTBlock> list = this.mySubBlocks;
            ASTBlock prevBlock = list != null ? list.get(newChildIndex - 1) : null;
            ASTBlock aSTBlock = prevBlock;
            if (Intrinsics.areEqual((Object)(aSTBlock != null && (aSTBlock = aSTBlock.getNode()) != null ? aSTBlock.getElementType() : null), (Object)KtNodeTypes.MODIFIER_LIST)) {
                return new ChildAttributes(Indent.getNoneIndent(), null);
            }
        }
        IElementType iElementType2 = type;
        if (KotlinCommonBlockKt.access$getCODE_BLOCKS$p().contains(iElementType2) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHEN) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.IF) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FOR) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHILE) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.DO_WHILE) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHEN_ENTRY)) {
            childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.TRY) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.CATCH) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FINALLY)) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        } else if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(iElementType2)) {
            childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.VALUE_ARGUMENT_LIST)) {
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex != 1 && newChildIndex != 0 && newChildIndex < subBlocks.size()) {
                Block block = subBlocks.get(newChildIndex);
                childAttributes = new ChildAttributes(block.getIndent(), block.getAlignment());
            } else {
                Indent indent = Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) && !CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_PARAMETER_LISTS || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.VALUE_ARGUMENT_LIST) && !CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getNormalIndent() : Indent.getContinuationIndent();
                childAttributes = new ChildAttributes(indent, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.DOC_COMMENT)) {
            childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.PARENTHESIZED)) {
            childAttributes = this.getSuperChildAttributes(newChildIndex);
        } else {
            List<Block> blocks = this.getSubBlocks();
            if (newChildIndex != 0) {
                boolean isIncomplete;
                boolean bl = isIncomplete = newChildIndex < blocks.size() ? blocks.get(newChildIndex - 1).isIncomplete() : this.isIncompleteInSuper();
                if (isIncomplete) {
                    Block lastInParent;
                    if (blocks.size() == newChildIndex && !CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_FOR_EXPRESSION_BODIES && (lastInParent = (Block)CollectionsKt.last(blocks)) instanceof ASTBlock) {
                        ASTNode aSTNode = ((ASTBlock)lastInParent).getNode();
                        if (KtTokens.ALL_ASSIGNMENTS.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                            return new ChildAttributes(Indent.getNormalIndent(), null);
                        }
                    }
                    return this.getSuperChildAttributes(newChildIndex);
                }
            }
            if (blocks.size() > newChildIndex) {
                Block block = blocks.get(newChildIndex);
                return new ChildAttributes(block.getIndent(), block.getAlignment());
            }
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        }
        return childAttributes;
    }

    private final CommonAlignmentStrategy getChildrenAlignmentStrategy() {
        CommonAlignmentStrategy commonAlignmentStrategy;
        KotlinCommonCodeStyleSettings kotlinCommonSettings = CodeStyleUtilsKt.getKotlinCommonSettings(this.settings);
        KotlinCodeStyleSettings kotlinCustomSettings = CodeStyleUtilsKt.getKotlinCustomSettings(this.settings);
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType parentType = iElementType;
        if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS;
            IElementType iElementType2 = KtNodeTypes.VALUE_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"VALUE_PARAMETER");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType2, kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS);
        } else if (parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
            IElementType iElementType3 = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"VALUE_ARGUMENT");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType3, kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS);
        } else {
            commonAlignmentStrategy = parentType == KtNodeTypes.WHEN ? this.getAlignmentForCaseBranch(kotlinCustomSettings.ALIGN_IN_COLUMNS_CASE_BRANCH) : (parentType == KtNodeTypes.WHEN_ENTRY ? this.alignmentStrategy : (KotlinCommonBlockKt.access$getBINARY_EXPRESSIONS$p().contains(parentType) && KotlinCommonBlockKt.access$getALIGN_FOR_BINARY_OPERATIONS$p().contains(KotlinCommonBlockKt.access$getOperationType(this.node)) ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION, this.getAlignment()) : (parentType == KtNodeTypes.SUPER_TYPE_LIST ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_EXTENDS_LIST, this.getAlignment()) : (parentType == KtNodeTypes.PARENTHESIZED ? (CommonAlignmentStrategy)new CommonAlignmentStrategy(kotlinCommonSettings){
                private Alignment bracketsAlignment;
                {
                    this.bracketsAlignment = $kotlinCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
                }

                public Alignment getAlignment(ASTNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    IElementType iElementType = node.getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                    IElementType childNodeType = iElementType;
                    ASTNode prev = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node);
                    if (prev != null && prev.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                        return this.bracketsAlignment;
                    }
                    if (childNodeType == KtTokens.LPAR || childNodeType == KtTokens.RPAR) {
                        return this.bracketsAlignment;
                    }
                    return null;
                }
            } : (Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.TYPE_CONSTRAINT_LIST) ? this.createAlignmentStrategy(true, this.getAlignment()) : this.getNullAlignmentStrategy())))));
        }
        return commonAlignmentStrategy;
    }

    private final ASTBlock buildSubBlock(ASTNode child, CommonAlignmentStrategy alignmentStrategy, Function1<? super ASTNode, ? extends Wrap> wrappingStrategy, Sequence<? extends ASTNode> overrideChildren) {
        ASTNode operationNode;
        Wrap childWrap = (Wrap)wrappingStrategy.invoke((Object)child);
        if (child.getElementType() == KtNodeTypes.OPERATION_REFERENCE && (operationNode = child.getFirstChildNode()) != null) {
            return this.createBlock(operationNode, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder, overrideChildren);
        }
        return this.createBlock(child, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder, overrideChildren);
    }

    static /* synthetic */ ASTBlock buildSubBlock$default(KotlinCommonBlock kotlinCommonBlock, ASTNode aSTNode, CommonAlignmentStrategy commonAlignmentStrategy, Function1 function1, Sequence sequence, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSubBlock");
        }
        if ((n & 8) != 0) {
            sequence = null;
        }
        return kotlinCommonBlock.buildSubBlock(aSTNode, commonAlignmentStrategy, (Function1<? super ASTNode, ? extends Wrap>)function1, (Sequence<? extends ASTNode>)sequence);
    }

    private final List<ASTBlock> buildSubBlocks() {
        Sequence sequence;
        CommonAlignmentStrategy childrenAlignmentStrategy = this.getChildrenAlignmentStrategy();
        Function1<ASTNode, Wrap> wrappingStrategy = this.getWrappingStrategy();
        if (this.overrideChildren != null) {
            sequence = this.overrideChildren;
        } else if (Intrinsics.areEqual((Object)this.node.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) {
            KtBinaryExpression binaryExpression;
            PsiElement psiElement = this.node.getPsi();
            KtBinaryExpression ktBinaryExpression = binaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
            if (binaryExpression != null && KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
                sequence = PsiUtilsKt.children((ASTNode)this.node);
            } else {
                List binaryExpressionChildren = new ArrayList();
                this.collectBinaryExpressionChildren(this.node, binaryExpressionChildren);
                sequence = CollectionsKt.asSequence((Iterable)binaryExpressionChildren);
            }
        } else {
            sequence = PsiUtilsKt.children((ASTNode)this.node);
        }
        Sequence childNodes = sequence;
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter(childNodes, KotlinCommonBlock::buildSubBlocks$lambda$4), arg_0 -> KotlinCommonBlock.buildSubBlocks$lambda$5(this, childrenAlignmentStrategy, wrappingStrategy, arg_0)));
    }

    private final Sequence<ASTBlock> buildSubBlocksForChildNode(ASTNode node, CommonAlignmentStrategy childrenAlignmentStrategy, Function1<? super ASTNode, ? extends Wrap> wrappingStrategy) {
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.FUN)) {
            // empty if block
        }
        Object[] objectArray = new ASTBlock[]{KotlinCommonBlock.buildSubBlock$default(this, node, childrenAlignmentStrategy, wrappingStrategy, null, 8, null)};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private final void collectBinaryExpressionChildren(ASTNode node, List<ASTNode> result) {
        for (ASTNode child : PsiUtilsKt.children((ASTNode)node)) {
            if (Intrinsics.areEqual((Object)child.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) {
                this.collectBinaryExpressionChildren(child, result);
                continue;
            }
            result.add(child);
        }
    }

    private final Function1<ASTNode, Wrap> getWrappingStrategy() {
        KotlinCommonCodeStyleSettings commonSettings = CodeStyleUtilsKt.getKotlinCommonSettings(this.settings);
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        ASTNode aSTNode = this.node.getTreeParent();
        IElementType parentElementType = aSTNode != null ? aSTNode.getElementType() : null;
        PsiElement nodePsi = this.node.getPsi();
        if (elementType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            int wrapSetting = commonSettings.CALL_PARAMETERS_WRAP;
            if (!(this.getAddTrailingComma(this.node) || wrapSetting != 1 && wrapSetting != 4)) {
                Intrinsics.checkNotNull((Object)nodePsi);
                if (!KotlinCommonBlockKt.needWrapArgumentList(nodePsi)) {
                    return getWrappingStrategy.1.INSTANCE;
                }
            }
            IElementType iElementType2 = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"VALUE_ARGUMENT");
            boolean bl = this.getAddTrailingComma(this.node);
            KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
            IElementType iElementType3 = (IElementType)ktSingleValueToken;
            KtSingleValueToken ktSingleValueToken2 = KtTokens.RPAR;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken2, (String)"RPAR");
            return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(wrapSetting, iElementType2, bl, this.trailingCommaWrappingStrategyWithMultiLineCheck(iElementType3, (IElementType)ktSingleValueToken2));
        }
        if (elementType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            IElementType wrapSetting = parentElementType;
            if (Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.FUN) || Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                int n = commonSettings.METHOD_PARAMETERS_WRAP;
                IElementType iElementType4 = KtNodeTypes.VALUE_PARAMETER;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"VALUE_PARAMETER");
                boolean bl = this.getAddTrailingComma(this.node);
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType5 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken3 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken3, (String)"RPAR");
                return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, iElementType4, bl, this.trailingCommaWrappingStrategyWithMultiLineCheck(iElementType5, (IElementType)ktSingleValueToken3));
            }
            if (Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.FUNCTION_TYPE)) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType6 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken4 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken4, (String)"RPAR");
                return this.defaultTrailingCommaWrappingStrategy(iElementType6, (IElementType)ktSingleValueToken4);
            }
            if (Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.FUNCTION_LITERAL)) {
                PsiElement psiElement = nodePsi.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(psiElement, this.settings)) {
                    KtSingleValueToken ktSingleValueToken = KtTokens.LBRACE;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACE");
                    IElementType iElementType7 = (IElementType)ktSingleValueToken;
                    KtSingleValueToken ktSingleValueToken5 = KtTokens.ARROW;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken5, (String)"ARROW");
                    Function1<ASTNode, Boolean> check = this.thisOrPrevIsMultiLineElement(iElementType7, (IElementType)ktSingleValueToken5);
                    return arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$10(check, arg_0);
                }
            }
        } else if (elementType == KtNodeTypes.FUNCTION_LITERAL) {
            Intrinsics.checkNotNull((Object)nodePsi);
            if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(nodePsi, this.settings)) {
                return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, (IElementType)KtTokens.LBRACE, (IElementType)KtTokens.ARROW, false, null, null, 28, null);
            }
        } else if (elementType == KtNodeTypes.WHEN_ENTRY) {
            Intrinsics.checkNotNull((Object)nodePsi);
            if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(nodePsi, this.settings)) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LBRACE;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACE");
                IElementType iElementType8 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken6 = KtTokens.ARROW;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken6, (String)"ARROW");
                Function1<ASTNode, Boolean> check = this.thisOrPrevIsMultiLineElement(iElementType8, (IElementType)ktSingleValueToken6);
                return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, null, (IElementType)KtTokens.ARROW, false, null, arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$11(check, arg_0), 13, null);
            }
        } else if (elementType == KtNodeTypes.DESTRUCTURING_DECLARATION) {
            Intrinsics.checkNotNull((Object)nodePsi, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
            KtDestructuringDeclaration cfr_ignored_0 = (KtDestructuringDeclaration)nodePsi;
            if (((KtDestructuringDeclaration)nodePsi).getValOrVarKeyword() == null) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType9 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken7 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken7, (String)"RPAR");
                return this.defaultTrailingCommaWrappingStrategy(iElementType9, (IElementType)ktSingleValueToken7);
            }
            if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(nodePsi, this.settings)) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType10 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken8 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken8, (String)"RPAR");
                Function1<ASTNode, Boolean> check = this.thisOrPrevIsMultiLineElement(iElementType10, (IElementType)ktSingleValueToken8);
                return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, (IElementType)KtTokens.LPAR, (IElementType)KtTokens.RPAR, false, KotlinCommonBlock::getWrappingStrategy$lambda$12, arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$13(check, arg_0), 4, null);
            }
        } else {
            if (elementType == KtNodeTypes.INDICES) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACKET");
                IElementType iElementType11 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken9 = KtTokens.RBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken9, (String)"RBRACKET");
                return this.defaultTrailingCommaWrappingStrategy(iElementType11, (IElementType)ktSingleValueToken9);
            }
            if (elementType == KtNodeTypes.TYPE_PARAMETER_LIST) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LT");
                IElementType iElementType12 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken10 = KtTokens.GT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken10, (String)"GT");
                return this.defaultTrailingCommaWrappingStrategy(iElementType12, (IElementType)ktSingleValueToken10);
            }
            if (elementType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LT");
                IElementType iElementType13 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken11 = KtTokens.GT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken11, (String)"GT");
                return this.defaultTrailingCommaWrappingStrategy(iElementType13, (IElementType)ktSingleValueToken11);
            }
            if (elementType == KtNodeTypes.COLLECTION_LITERAL_EXPRESSION) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACKET");
                IElementType iElementType14 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken12 = KtTokens.RBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken12, (String)"RBRACKET");
                return this.defaultTrailingCommaWrappingStrategy(iElementType14, (IElementType)ktSingleValueToken12);
            }
            if (elementType == KtNodeTypes.SUPER_TYPE_LIST) {
                Wrap wrap = Wrap.createWrap((int)commonSettings.EXTENDS_LIST_WRAP, (boolean)false);
                return arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$14(wrap, arg_0);
            }
            if (elementType == KtNodeTypes.CLASS_BODY) {
                int n = commonSettings.ENUM_CONSTANTS_WRAP;
                IElementType iElementType15 = KtNodeTypes.ENUM_ENTRY;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType15, (String)"ENUM_ENTRY");
                return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(n, iElementType15, false, null, 12, null);
            }
            if (elementType == KtNodeTypes.MODIFIER_LIST) {
                PsiElement parent = this.node.getTreeParent().getPsi();
                if (parent instanceof KtParameter) {
                    int n = commonSettings.PARAMETER_ANNOTATION_WRAP;
                    TokenSet tokenSet = KotlinCommonBlockKt.access$getANNOTATIONS$p();
                    ASTNode aSTNode2 = this.node.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getTreeParent(...)");
                    return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, tokenSet, !KotlinCommonBlockKt.access$isFirstParameter(aSTNode2));
                }
                if (parent instanceof KtClassOrObject || parent instanceof KtTypeAlias) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(commonSettings.CLASS_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
                if (parent instanceof KtNamedFunction || parent instanceof KtSecondaryConstructor) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(commonSettings.METHOD_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
                if (parent instanceof KtProperty) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(((KtProperty)parent).isLocal() ? commonSettings.VARIABLE_ANNOTATION_WRAP : commonSettings.FIELD_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
            } else {
                if (elementType == KtNodeTypes.VALUE_PARAMETER) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.PARAMETER_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtClassOrObject || nodePsi instanceof KtTypeAlias) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.CLASS_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtNamedFunction || nodePsi instanceof KtSecondaryConstructor) {
                    return arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$16(commonSettings, this, arg_0);
                }
                if (nodePsi instanceof KtProperty) {
                    return arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$18(nodePsi, commonSettings, this, arg_0);
                }
                if (nodePsi instanceof KtBinaryExpression) {
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)KtTokens.EQ)) {
                        return arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$19(this, arg_0);
                    }
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)KtTokens.ELVIS)) {
                        PsiElement $this$getStrictParentOfType$iv = nodePsi;
                        boolean $i$f$getStrictParentOfType = false;
                        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtStringTemplateExpression.class, (boolean)true) == null) {
                            return arg_0 -> KotlinCommonBlock.getWrappingStrategy$lambda$20(this, arg_0);
                        }
                    }
                    return getWrappingStrategy.11.INSTANCE;
                }
            }
        }
        return getWrappingStrategy.12.INSTANCE;
    }

    private final Function1<ASTNode, Wrap> defaultTrailingCommaWrappingStrategy(IElementType leftAnchor, IElementType rightAnchor) {
        return arg_0 -> KotlinCommonBlock.defaultTrailingCommaWrappingStrategy$lambda$21(this, leftAnchor, rightAnchor, arg_0);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean getAddTrailingComma(ASTNode $this$addTrailingComma) {
        block6: {
            if (UtilKt.addTrailingCommaIsAllowedFor(CodeStyleUtilsKt.getKotlinCustomSettings(this.settings), $this$addTrailingComma)) break block6;
            v0 = $this$addTrailingComma.getLastChildNode();
            if (v0 == null) ** GOTO lbl-1000
            it = v0;
            $i$a$-let-KotlinCommonBlock$addTrailingComma$1 = false;
            v1 = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(it, false, 2, null);
            v0 = v1;
            if (v1 != null) {
                v2 = v0.getElementType();
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            if (v2 != KtTokens.COMMA) ** GOTO lbl-1000
        }
        v3 = $this$addTrailingComma.getPsi();
        if (v3 != null) {
            p0 = v3;
            $i$f$_get_addTrailingComma_$stub_for_inlining = false;
            $i$a$-let-KotlinCommonBlock$addTrailingComma$2 = false;
            v4 = FormatterUtilKt.isMultiline(p0);
        } else {
            v4 = false;
        }
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        return v5;
    }

    private final ASTNode notDelimiterSiblingNodeInSequence(ASTNode $this$notDelimiterSiblingNodeInSequence, boolean forward, IElementType delimiterType, IElementType typeOfLastElement) {
        ASTNode sibling = null;
        for (ASTNode element : SequencesKt.takeWhile((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings((ASTNode)$this$notDelimiterSiblingNodeInSequence, (boolean)forward), KotlinCommonBlock::notDelimiterSiblingNodeInSequence$lambda$23), arg_0 -> KotlinCommonBlock.notDelimiterSiblingNodeInSequence$lambda$24(typeOfLastElement, arg_0))) {
            IElementType elementType;
            Intrinsics.checkNotNullExpressionValue((Object)element.getElementType(), (String)"getElementType(...)");
            if (!forward) {
                sibling = element;
                if (Intrinsics.areEqual((Object)elementType, (Object)delimiterType) || Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EOL_COMMENT)) continue;
                break;
            }
            if (!Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EOL_COMMENT)) break;
            sibling = element;
        }
        return sibling;
    }

    private final Function1<ASTNode, Boolean> thisOrPrevIsMultiLineElement(IElementType typeOfFirstElement, IElementType typeOfLastElement) {
        return arg_0 -> KotlinCommonBlock.thisOrPrevIsMultiLineElement$lambda$25(typeOfFirstElement, typeOfLastElement, this, arg_0);
    }

    private final Function1<ASTNode, Wrap> trailingCommaWrappingStrategyWithMultiLineCheck(IElementType leftAnchor, IElementType rightAnchor) {
        return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, leftAnchor, rightAnchor, true, null, this.thisOrPrevIsMultiLineElement(leftAnchor, rightAnchor), 8, null);
    }

    private final Function1<ASTNode, Wrap> trailingCommaWrappingStrategy(IElementType leftAnchor, IElementType rightAnchor, boolean checkTrailingComma, Function1<? super ASTNode, Boolean> filter, Function1<? super ASTNode, Boolean> additionalCheck) {
        return arg_0 -> KotlinCommonBlock.trailingCommaWrappingStrategy$lambda$28(filter, checkTrailingComma, this, rightAnchor, leftAnchor, additionalCheck, arg_0);
    }

    static /* synthetic */ Function1 trailingCommaWrappingStrategy$default(KotlinCommonBlock kotlinCommonBlock, IElementType iElementType, IElementType iElementType2, boolean bl, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: trailingCommaWrappingStrategy");
        }
        if ((n & 1) != 0) {
            iElementType = null;
        }
        if ((n & 2) != 0) {
            iElementType2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            function1 = KotlinCommonBlock::trailingCommaWrappingStrategy$lambda$26;
        }
        if ((n & 0x10) != 0) {
            function12 = KotlinCommonBlock::trailingCommaWrappingStrategy$lambda$27;
        }
        return kotlinCommonBlock.trailingCommaWrappingStrategy(iElementType, iElementType2, bl, (Function1<? super ASTNode, Boolean>)function1, (Function1<? super ASTNode, Boolean>)function12);
    }

    private static final ASTBlock splitAtIndex$lambda$2(ASTBlock $parentBlock, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $parentBlock;
    }

    private static final ASTBlock splitAtIndex$lambda$3(KotlinCommonBlock this$0, ASTNode it) {
        ASTNode aSTNode;
        ASTNode parent;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ASTNode aSTNode2 = it.getTreeParent();
        if (aSTNode2 == null) {
            aSTNode2 = this$0.node;
        }
        if ((parent = aSTNode2).getElementType() == KtNodeTypes.OPERATION_REFERENCE) {
            aSTNode = parent.getTreeParent();
            if (aSTNode == null) {
                aSTNode = parent;
            }
        } else {
            aSTNode = parent;
        }
        ASTNode skipOperationNodeParent = aSTNode;
        return this$0.createSyntheticSpacingNodeBlock(skipOperationNodeParent);
    }

    private static final boolean buildSubBlocks$lambda$4(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTextRange().getLength() > 0 && !Intrinsics.areEqual((Object)it.getElementType(), (Object)TokenType.WHITE_SPACE);
    }

    private static final Sequence buildSubBlocks$lambda$5(KotlinCommonBlock this$0, CommonAlignmentStrategy $childrenAlignmentStrategy, Function1 $wrappingStrategy, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.buildSubBlocksForChildNode(it, $childrenAlignmentStrategy, (Function1<? super ASTNode, ? extends Wrap>)$wrappingStrategy);
    }

    private static final boolean buildSubBlocksForChildNode$lambda$6(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTextRange().getLength() > 0 && !Intrinsics.areEqual((Object)it.getElementType(), (Object)TokenType.WHITE_SPACE);
    }

    private static final boolean buildSubBlocksForChildNode$lambda$7(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)KtTokens.EOL_COMMENT);
    }

    private static final boolean buildSubBlocksForChildNode$lambda$8(String $funIndent, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)KtTokens.EOL_COMMENT) && !Intrinsics.areEqual((Object)KotlinCommonBlockKt.access$extractIndent(it), (Object)$funIndent);
    }

    private static final Wrap getWrappingStrategy$lambda$10(Function1 $check, ASTNode childElement) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        return KotlinCommonBlockKt.access$createWrapAlwaysIf(KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null) == null || (Boolean)$check.invoke((Object)childElement) != false);
    }

    private static final boolean getWrappingStrategy$lambda$11(Function1 $check, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KotlinCommonBlockKt.access$getSiblingWithoutWhitespaceAndComments(it, true) != null && (Boolean)$check.invoke((Object)it) != false;
    }

    private static final boolean getWrappingStrategy$lambda$12(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getElementType() != KtTokens.EQ;
    }

    private static final boolean getWrappingStrategy$lambda$13(Function1 $check, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KotlinCommonBlockKt.access$getSiblingWithoutWhitespaceAndComments(it, true) != null && (Boolean)$check.invoke((Object)it) != false;
    }

    private static final Wrap getWrappingStrategy$lambda$14(Wrap $wrap, ASTNode childElement) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        return childElement.getPsi() instanceof KtSuperTypeListEntry ? $wrap : null;
    }

    private static final Wrap getWrappingStrategy$lambda$16(KotlinCommonCodeStyleSettings $commonSettings, KotlinCommonBlock this$0, ASTNode childElement) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        Wrap wrap = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, $commonSettings.METHOD_ANNOTATION_WRAP);
        if (wrap != null) {
            Wrap it = wrap;
            boolean bl = false;
            return it;
        }
        ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.EQ) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this$0.settings).WRAP_EXPRESSION_BODY_FUNCTIONS, (boolean)true) : null;
    }

    private static final Wrap getWrappingStrategy$lambda$18(PsiElement $nodePsi, KotlinCommonCodeStyleSettings $commonSettings, KotlinCommonBlock this$0, ASTNode childElement) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        int wrapSetting = ((KtProperty)$nodePsi).isLocal() ? $commonSettings.VARIABLE_ANNOTATION_WRAP : $commonSettings.FIELD_ANNOTATION_WRAP;
        Wrap wrap = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, wrapSetting);
        if (wrap != null) {
            Wrap it = wrap;
            boolean bl = false;
            return it;
        }
        ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.EQ) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this$0.settings).ASSIGNMENT_WRAP, (boolean)true) : null;
    }

    private static final Wrap getWrappingStrategy$lambda$19(KotlinCommonBlock this$0, ASTNode childElement) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.OPERATION_REFERENCE) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this$0.settings).ASSIGNMENT_WRAP, (boolean)true) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Wrap getWrappingStrategy$lambda$20(KotlinCommonBlock this$0, ASTNode childElement) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        if (!Intrinsics.areEqual((Object)childElement.getElementType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) return null;
        PsiElement psiElement = childElement.getPsi();
        KtOperationReferenceExpression ktOperationReferenceExpression = psiElement instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement : null;
        if (!Intrinsics.areEqual((Object)(ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getOperationSignTokenType() : null), (Object)KtTokens.ELVIS)) return null;
        Wrap wrap = Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this$0.settings).WRAP_ELVIS_EXPRESSIONS, (boolean)true);
        return wrap;
    }

    private static final Wrap defaultTrailingCommaWrappingStrategy$lambda$21(KotlinCommonBlock this$0, IElementType $leftAnchor, IElementType $rightAnchor, ASTNode childElement) {
        return (Wrap)this$0.trailingCommaWrappingStrategyWithMultiLineCheck($leftAnchor, $rightAnchor).invoke((Object)childElement);
    }

    private static final boolean notDelimiterSiblingNodeInSequence$lambda$23(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getElementType(), (Object)KtTokens.WHITE_SPACE);
    }

    private static final boolean notDelimiterSiblingNodeInSequence$lambda$24(IElementType $typeOfLastElement, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getElementType(), (Object)$typeOfLastElement);
    }

    private static final boolean thisOrPrevIsMultiLineElement$lambda$25(IElementType $typeOfFirstElement, IElementType $typeOfLastElement, KotlinCommonBlock this$0, ASTNode childElement) {
        KtSingleValueToken delimiterType = KtTokens.COMMA;
        IElementType iElementType = childElement.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)$typeOfFirstElement) || Intrinsics.areEqual((Object)iElementType, (Object)$typeOfLastElement) || Intrinsics.areEqual((Object)iElementType, (Object)delimiterType) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EOL_COMMENT) || KtTokens.WHITESPACES.contains(iElementType)) {
            return false;
        }
        PsiElement psiElement = childElement.getPsi();
        if (psiElement == null) {
            return false;
        }
        PsiElement psi = psiElement;
        if (FormatterUtilKt.isMultiline(psi)) {
            return true;
        }
        Intrinsics.checkNotNull((Object)delimiterType);
        ASTNode aSTNode = this$0.notDelimiterSiblingNodeInSequence(childElement, false, (IElementType)delimiterType, $typeOfFirstElement);
        int startOffset = aSTNode != null ? aSTNode.getStartOffset() : PsiUtilsKt.getStartOffset((PsiElement)psi);
        ASTNode aSTNode2 = this$0.notDelimiterSiblingNodeInSequence(childElement, true, (IElementType)delimiterType, $typeOfLastElement);
        int endOffset = aSTNode2 != null && (aSTNode2 = aSTNode2.getPsi()) != null ? PsiUtilsKt.getEndOffset((PsiElement)aSTNode2) : PsiUtilsKt.getEndOffset((PsiElement)psi);
        PsiElement psiElement2 = psi.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
        return FormatterUtilKt.containsLineBreakInChild(psiElement2, startOffset, endOffset);
    }

    private static final boolean trailingCommaWrappingStrategy$lambda$26(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean trailingCommaWrappingStrategy$lambda$27(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Wrap trailingCommaWrappingStrategy$lambda$28(Function1<? super ASTNode, Boolean> $filter, boolean $checkTrailingComma, KotlinCommonBlock this$0, IElementType $rightAnchor, IElementType $leftAnchor, Function1<? super ASTNode, Boolean> $additionalCheck, ASTNode childElement) {
        boolean bl;
        block5: {
            block6: {
                block7: {
                    IElementType childElementType;
                    block4: {
                        if (!((Boolean)$filter.invoke((Object)childElement)).booleanValue()) {
                            return null;
                        }
                        IElementType iElementType = childElement.getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                        childElementType = iElementType;
                        if (!$checkTrailingComma) break block4;
                        ASTNode aSTNode = childElement.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
                        if (!this$0.getAddTrailingComma(aSTNode)) break block5;
                    }
                    if ($rightAnchor != null && $rightAnchor == childElementType) break block6;
                    if ($leftAnchor == null) break block7;
                    ASTNode aSTNode = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(childElement);
                    if ($leftAnchor == (aSTNode != null ? aSTNode.getElementType() : null)) break block6;
                }
                if (!((Boolean)$additionalCheck.invoke((Object)childElement)).booleanValue()) break block5;
            }
            bl = true;
            return KotlinCommonBlockKt.access$createWrapAlwaysIf(bl);
        }
        bl = false;
        return KotlinCommonBlockKt.access$createWrapAlwaysIf(bl);
    }
}

