/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.debugger;

import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J0\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/debugger/GradleJvmDebuggerBackend;", "Lcom/intellij/openapi/externalSystem/debugger/DebuggerBackendExtension;", "<init>", "()V", "id", "", "isAlwaysAttached", "", "debugConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "processParameters", "initializationCode", "", "dispatchPort", "parameters", "executionEnvironmentVariables", "", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleJvmDebuggerBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleJvmDebuggerBackend.kt\norg/jetbrains/plugins/gradle/service/debugger/GradleJvmDebuggerBackend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n827#2:58\n855#2,2:59\n*S KotlinDebug\n*F\n+ 1 GradleJvmDebuggerBackend.kt\norg/jetbrains/plugins/gradle/service/debugger/GradleJvmDebuggerBackend\n*L\n50#1:58\n50#1:59,2\n*E\n"})
public final class GradleJvmDebuggerBackend
implements DebuggerBackendExtension {
    @NotNull
    public String id() {
        return "Gradle JVM";
    }

    public boolean isAlwaysAttached() {
        return true;
    }

    @NotNull
    public RunnerAndConfigurationSettings debugConfigurationSettings(@NotNull Project project, @NotNull String processName, @NotNull String processParameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        RunnerAndConfigurationSettings runSettings = RunManager.Companion.getInstance(project).createConfiguration(processName, RemoteConfigurationType.class);
        HashMap description = this.splitParameters(processParameters);
        RunConfiguration runConfiguration = runSettings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.execution.remote.RemoteConfiguration");
        RemoteConfiguration configuration = (RemoteConfiguration)runConfiguration;
        configuration.HOST = "localhost";
        configuration.PORT = (String)description.get("DEBUG_SERVER_PORT");
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = true;
        configuration.putUserData(DebuggerBackendExtension.RUNTIME_MODULE_DIR_KEY, description.get("MODULE_DIR"));
        return runSettings;
    }

    @NotNull
    public List<String> initializationCode(@Nullable Project project, @Nullable String dispatchPort, @NotNull String parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return CollectionsKt.listOf((Object)GradleInitScriptUtil.loadJvmDebugInitScript());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, String> executionEnvironmentVariables(@Nullable Project project, @Nullable String dispatchPort, @NotNull String parameters) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (dispatchPort == null) {
            return MapsKt.emptyMap();
        }
        JavaParameters javaParameters = new JavaParameters();
        RemoteConnectionBuilder.addDebuggerAgent((JavaParameters)javaParameters, (Project)project, (boolean)false);
        List list = javaParameters.getVMParametersList().getList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (StringsKt.startsWith$default((String)it, (String)"-agentlib:jdwp=", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jvmArgs = (List)destination$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEBUGGER_ID", (Object)this.id()), TuplesKt.to((Object)"PROCESS_PARAMETERS", (Object)parameters), TuplesKt.to((Object)"PROCESS_OPTIONS", (Object)CollectionsKt.joinToString$default((Iterable)jvmArgs, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null))};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

