/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\t\u001a\u0012\u0010\b\u001a\u00020\u0004*\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\f\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"write", "", "Lkotlinx/io/Sink;", "byteString", "Lkotlinx/io/bytestring/ByteString;", "startIndex", "", "endIndex", "readByteString", "Lkotlinx/io/Source;", "byteCount", "indexOf", "", "Lkotlinx/io/Buffer;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nByteStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n+ 6 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,166:1\n38#2:167\n356#3,3:168\n1#4:171\n35#5:172\n36#5:196\n713#6,23:173\n*S KotlinDebug\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n*L\n29#1:167\n34#1:168,3\n127#1:172\n127#1:196\n128#1:173,23\n*E\n"})
public final class ByteStringsKt {
    public static final void write(@NotNull Sink $this$write, @NotNull ByteString byteString, int startIndex, int endIndex) {
        int bytesToWrite;
        Segment tail;
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        int size$iv = byteString.getSize();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        if (endIndex == startIndex) {
            return;
        }
        Sink $this$writeToInternalBuffer$iv = $this$write;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer buffer = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        int offset = startIndex;
        Segment segment = buffer.getHead();
        Segment segment2 = tail = segment != null ? segment.getPrev() : null;
        if (tail != null) {
            bytesToWrite = Math.min(tail.data.length - tail.getLimit(), endIndex - offset);
            byteString.copyInto(tail.data, tail.getLimit(), offset, offset + bytesToWrite);
            offset += bytesToWrite;
            tail.setLimit(tail.getLimit() + bytesToWrite);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesToWrite);
        }
        while (offset < endIndex) {
            bytesToWrite = Math.min(endIndex - offset, 8192);
            Segment seg = buffer.writableSegment(bytesToWrite);
            byteString.copyInto(seg.data, seg.getLimit(), offset, offset + bytesToWrite);
            seg.setLimit(seg.getLimit() + bytesToWrite);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesToWrite);
            offset += bytesToWrite;
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void write$default(Sink sink, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.getSize();
        }
        ByteStringsKt.write(sink, byteString, n, n2);
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString));
    }

    @NotNull
    public static final ByteString readByteString(@NotNull Source $this$readByteString, int byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray($this$readByteString, byteCount));
    }

    public static final long indexOf(@NotNull Source $this$indexOf, @NotNull ByteString byteString, long startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        if (!(startIndex >= 0L)) {
            boolean bl = false;
            String string = "startIndex: " + startIndex;
            throw new IllegalArgumentException(string.toString());
        }
        if (ByteStringKt.isEmpty(byteString)) {
            return 0L;
        }
        long offset = startIndex;
        while ($this$indexOf.request(offset + (long)byteString.getSize())) {
            long idx = ByteStringsKt.indexOf($this$indexOf.getBuffer(), byteString, offset);
            if (idx < 0L) {
                offset = $this$indexOf.getBuffer().getSize() - (long)byteString.getSize() + 1L;
                continue;
            }
            return idx;
        }
        return -1L;
    }

    public static /* synthetic */ long indexOf$default(Source source, ByteString byteString, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return ByteStringsKt.indexOf(source, byteString, l);
    }

    /*
     * WARNING - void declaration
     */
    public static final long indexOf(@NotNull Buffer $this$indexOf, @NotNull ByteString byteString, long startIndex) {
        long nextOffset$iv;
        Segment s$iv;
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        if (!(startIndex <= $this$indexOf.getSize())) {
            boolean $i$a$-require-ByteStringsKt$indexOf$32 = false;
            String $i$a$-require-ByteStringsKt$indexOf$32 = "startIndex (" + startIndex + ") should not exceed size (" + $this$indexOf.getSize() + ')';
            throw new IllegalArgumentException($i$a$-require-ByteStringsKt$indexOf$32.toString());
        }
        if (ByteStringKt.isEmpty(byteString)) {
            return 0L;
        }
        if (startIndex > $this$indexOf.getSize() - (long)byteString.getSize()) {
            return -1L;
        }
        UnsafeByteStringOperations this_$iv = UnsafeByteStringOperations.INSTANCE;
        boolean $i$f$withByteArrayUnsafe = false;
        byte[] byteStringData = byteString.getBackingArrayReference();
        boolean bl = false;
        Buffer $this$seek$iv = $this$indexOf;
        boolean $i$f$seek = false;
        if ($this$seek$iv.getHead() == null) {
            void o;
            long l = -1L;
            Segment seg = null;
            boolean bl2 = false;
            if (o == -1L) {
                return -1L;
            }
            Segment segment = seg;
            void offset = o;
            do {
                Intrinsics.checkNotNull(segment);
                int startOffset = Math.max((int)(startIndex - offset), 0);
                int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
                if (idx != -1) {
                    return (long)(offset + (long)idx);
                }
                int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
                int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
                if (idx1 == -1) continue;
                return (long)(offset + (long)idx1);
            } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
            return -1L;
        }
        if ($this$seek$iv.getSize() - startIndex < startIndex) {
            Segment s$iv2;
            long offset$iv = $this$seek$iv.getSize();
            for (s$iv2 = $this$seek$iv.getTail(); s$iv2 != null && offset$iv > startIndex && (offset$iv -= (long)(s$iv2.getLimit() - s$iv2.getPos())) > startIndex; s$iv2 = s$iv2.getPrev()) {
            }
            long o = offset$iv;
            Segment seg = s$iv2;
            boolean bl3 = false;
            if (o == -1L) {
                return -1L;
            }
            Segment segment = seg;
            long offset = o;
            do {
                Intrinsics.checkNotNull((Object)segment);
                int startOffset = Math.max((int)(startIndex - offset), 0);
                int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
                if (idx != -1) {
                    return offset + (long)idx;
                }
                int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
                int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
                if (idx1 == -1) continue;
                return offset + (long)idx1;
            } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
            return -1L;
        }
        long offset$iv = 0L;
        for (s$iv = $this$seek$iv.getHead(); s$iv != null && (nextOffset$iv = offset$iv + (long)(s$iv.getLimit() - s$iv.getPos())) <= startIndex; s$iv = s$iv.getNext()) {
            offset$iv = nextOffset$iv;
        }
        long o = offset$iv;
        Segment seg = s$iv;
        boolean bl4 = false;
        if (o == -1L) {
            return -1L;
        }
        Segment segment = seg;
        long offset = o;
        do {
            Intrinsics.checkNotNull((Object)segment);
            int startOffset = Math.max((int)(startIndex - offset), 0);
            int idx = SegmentKt.indexOfBytesInbound(segment, byteStringData, startOffset);
            if (idx != -1) {
                return offset + (long)idx;
            }
            int firstOutboundOffset = Math.max(startOffset, segment.getSize() - byteStringData.length + 1);
            int idx1 = SegmentKt.indexOfBytesOutbound(segment, byteStringData, firstOutboundOffset);
            if (idx1 == -1) continue;
            return offset + (long)idx1;
        } while ((segment = segment.getNext()) != null && (offset += (long)segment.getSize()) + (long)byteString.getSize() <= $this$indexOf.getSize());
        return -1L;
    }

    public static /* synthetic */ long indexOf$default(Buffer buffer, ByteString byteString, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return ByteStringsKt.indexOf(buffer, byteString, l);
    }
}

