/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.JavaDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.calls.results.PlatformOverloadsSpecificityComparator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmPlatformOverloadsSpecificityComparator;", "Lorg/jetbrains/kotlin/resolve/calls/results/PlatformOverloadsSpecificityComparator;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isMoreSpecificShape", "", "specific", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "general", "frontend.java"})
public final class JvmPlatformOverloadsSpecificityComparator
implements PlatformOverloadsSpecificityComparator {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public JvmPlatformOverloadsSpecificityComparator(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public boolean isMoreSpecificShape(@NotNull CallableDescriptor specific, @NotNull CallableDescriptor general) {
        Intrinsics.checkNotNullParameter((Object)specific, (String)"specific");
        Intrinsics.checkNotNullParameter((Object)general, (String)"general");
        if (!(specific instanceof PropertyDescriptor) || !(general instanceof PropertyDescriptor)) {
            return false;
        }
        if (((PropertyDescriptor)specific).getDispatchReceiverParameter() == null || ((PropertyDescriptor)general).getDispatchReceiverParameter() == null) {
            return false;
        }
        if (!(((PropertyDescriptor)specific).getContainingDeclaration() instanceof ClassDescriptor)) {
            return false;
        }
        if (!DescriptorEquivalenceForOverrides.areEquivalent$default((DescriptorEquivalenceForOverrides)DescriptorEquivalenceForOverrides.INSTANCE, (DeclarationDescriptor)((PropertyDescriptor)specific).getContainingDeclaration(), (DeclarationDescriptor)((PropertyDescriptor)general).getContainingDeclaration(), (boolean)true, (boolean)false, (int)8, null)) {
            return false;
        }
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.PreferJavaFieldOverload)) {
            return false;
        }
        return JavaDescriptorUtilKt.isJavaField((PropertyDescriptor)((PropertyDescriptor)specific)) && !JavaDescriptorUtilKt.isJavaField((PropertyDescriptor)((PropertyDescriptor)general));
    }
}

