/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageSuite
implements CoverageSuite,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)BaseCoverageSuite.class.getName());
    @NonNls
    private static final String FILE_PATH = "FILE_PATH";
    @NonNls
    private static final String SOURCE_PROVIDER = "SOURCE_PROVIDER";
    @NonNls
    private static final String MODIFIED_STAMP = "MODIFIED";
    @NonNls
    private static final String NAME_ATTRIBUTE = "NAME";
    @NonNls
    private static final String COVERAGE_RUNNER = "RUNNER";
    @NonNls
    private static final String COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME = "COVERAGE_BY_TEST_ENABLED";
    @NonNls
    private static final String BRANCH_COVERAGE_ATTRIBUTE_NAME = "COVERAGE_TRACING_ENABLED";
    private SoftReference<ProjectData> myCoverageData;
    private String myName;
    private Project myProject;
    @ApiStatus.Internal
    protected CoverageRunner myRunner;
    private CoverageFileProvider myCoverageDataFileProvider;
    private long myTimestamp;
    private RunConfigurationBase<?> myConfiguration;
    @ApiStatus.Internal
    protected boolean myTrackTestFolders;
    @ApiStatus.Internal
    protected boolean myBranchCoverage;
    @ApiStatus.Internal
    protected boolean myCoverageByTestEnabled;

    protected BaseCoverageSuite() {
        this.myCoverageData = new SoftReference<Object>(null);
        this.myTrackTestFolders = false;
        this.myBranchCoverage = false;
        this.myCoverageByTestEnabled = false;
    }

    public BaseCoverageSuite(@NotNull String name, @Nullable Project project, @Nullable CoverageRunner runner, @Nullable CoverageFileProvider fileProvider, long timestamp) {
        if (name == null) {
            BaseCoverageSuite.$$$reportNull$$$0(0);
        }
        this.myCoverageData = new SoftReference<Object>(null);
        this.myTrackTestFolders = false;
        this.myBranchCoverage = false;
        this.myCoverageByTestEnabled = false;
        this.myName = name;
        this.myProject = project;
        this.myRunner = runner;
        this.myCoverageDataFileProvider = fileProvider;
        this.myTimestamp = timestamp;
    }

    @Deprecated
    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long timestamp, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, CoverageRunner coverageRunner, @Nullable Project project) {
        this(name, project, coverageRunner, fileProvider, timestamp);
        this.myTrackTestFolders = trackTestFolders;
        this.myBranchCoverage = branchCoverage;
        this.myCoverageByTestEnabled = coverageByTestEnabled;
    }

    @Deprecated(forRemoval=true)
    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long timestamp, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, CoverageRunner coverageRunner) {
        this(name, fileProvider, timestamp, coverageByTestEnabled, branchCoverage, trackTestFolders, coverageRunner, null);
    }

    @Override
    public boolean isValid() {
        return this.myCoverageDataFileProvider.isValid();
    }

    @Override
    public String getPresentableName() {
        return this.myName;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @ApiStatus.Internal
    public void setProject(Project project) {
        this.myProject = project;
    }

    @Override
    public CoverageRunner getRunner() {
        return this.myRunner;
    }

    @Override
    @NotNull
    public CoverageFileProvider getCoverageDataFileProvider() {
        CoverageFileProvider coverageFileProvider = this.myCoverageDataFileProvider;
        if (coverageFileProvider == null) {
            BaseCoverageSuite.$$$reportNull$$$0(1);
        }
        return coverageFileProvider;
    }

    @Override
    @NotNull
    public String getCoverageDataFileName() {
        String string = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        if (string == null) {
            BaseCoverageSuite.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public long getLastCoverageTimeStamp() {
        return this.myTimestamp;
    }

    @Override
    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    @Override
    public boolean isBranchCoverage() {
        return this.myBranchCoverage;
    }

    @Override
    @ApiStatus.Internal
    public boolean isCoverageByTestEnabled() {
        return this.myCoverageByTestEnabled;
    }

    @Nullable
    public RunConfigurationBase<?> getConfiguration() {
        return this.myConfiguration;
    }

    public void setConfiguration(RunConfigurationBase<?> configuration) {
        this.myConfiguration = configuration;
    }

    @Override
    @Nullable
    public ProjectData getCoverageData(CoverageDataManager coverageDataManager) {
        ProjectData data = this.getCoverageData();
        if (data == null) {
            data = this.loadProjectInfo();
            this.setCoverageData(data);
        }
        return data;
    }

    public ProjectData getCoverageData() {
        return this.myCoverageData.get();
    }

    @Override
    public void setCoverageData(ProjectData projectData) {
        this.myCoverageData = new SoftReference<ProjectData>(projectData);
    }

    @Override
    @ApiStatus.Internal
    public void restoreCoverageData() {
        this.setCoverageData(this.loadProjectInfo());
    }

    @Nullable
    protected ProjectData loadProjectInfo() {
        String sessionDataFileName = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        if (sessionDataFileName == null) {
            return null;
        }
        File sessionDataFile = new File(sessionDataFileName);
        if (!sessionDataFile.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Nonexistent file given +" + sessionDataFileName);
            }
            return null;
        }
        long startNs = System.nanoTime();
        ProjectData projectData = this.myRunner.loadCoverageData(sessionDataFile, this);
        long timeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        if (projectData != null) {
            CoverageLogger.logReportLoading(this.myProject, this.myRunner, timeMs, projectData.getClassesNumber());
        }
        return projectData;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myCoverageDataFileProvider = BaseCoverageSuite.readDataFileProviderAttribute(element);
        this.myName = element.getAttributeValue(NAME_ATTRIBUTE);
        if (this.myName == null) {
            this.myName = BaseCoverageSuite.generateName(this.myCoverageDataFileProvider.getCoverageDataFilePath());
        }
        this.myTimestamp = Long.parseLong(element.getAttributeValue(MODIFIED_STAMP));
        this.myRunner = BaseCoverageSuite.readRunnerAttribute(element);
        String collectedLineInfo = element.getAttributeValue(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME);
        this.myCoverageByTestEnabled = collectedLineInfo != null && Boolean.valueOf(collectedLineInfo) != false;
        String branchCoverage = element.getAttributeValue(BRANCH_COVERAGE_ATTRIBUTE_NAME);
        this.myBranchCoverage = branchCoverage != null && Boolean.valueOf(branchCoverage) != false;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String string;
        String absolutePath = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        String pathInSystemDir = FileUtil.getRelativePath((File)new File(PathManager.getSystemPath()), (File)new File(absolutePath));
        element.setAttribute(FILE_PATH, pathInSystemDir != null ? FileUtil.toSystemIndependentName((String)pathInSystemDir) : absolutePath);
        element.setAttribute(NAME_ATTRIBUTE, this.myName);
        element.setAttribute(MODIFIED_STAMP, String.valueOf(this.myTimestamp));
        CoverageFileProvider coverageFileProvider = this.myCoverageDataFileProvider;
        if (coverageFileProvider instanceof DefaultCoverageFileProvider) {
            DefaultCoverageFileProvider defaultProvider = (DefaultCoverageFileProvider)coverageFileProvider;
            string = defaultProvider.getSourceProvider();
        } else {
            string = this.myCoverageDataFileProvider.getClass().getName();
        }
        element.setAttribute(SOURCE_PROVIDER, string);
        if (this.myRunner != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myRunner.getId());
        }
        element.setAttribute(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myCoverageByTestEnabled));
        element.setAttribute(BRANCH_COVERAGE_ATTRIBUTE_NAME, String.valueOf(this.myBranchCoverage));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        String thisName = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        String thatName = ((BaseCoverageSuite)o).myCoverageDataFileProvider.getCoverageDataFilePath();
        return thisName.equals(thatName);
    }

    public int hashCode() {
        return this.myCoverageDataFileProvider.getCoverageDataFilePath().hashCode();
    }

    @ApiStatus.Internal
    public GlobalSearchScope getSearchScope(Project project) {
        ModuleBasedConfiguration moduleConfig;
        Module module;
        GlobalSearchScope scope;
        RunConfigurationBase<?> configuration = this.getConfiguration();
        GlobalSearchScope globalSearchScope = scope = this.isTrackTestFolders() ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScopesCore.projectProductionScope((Project)project);
        if (configuration instanceof ModuleBasedConfiguration && (module = (moduleConfig = (ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null) {
            return GlobalSearchScope.moduleWithDependenciesScope((Module)module).intersectWith(scope);
        }
        return scope;
    }

    private static String generateName(String path) {
        String text = path;
        int i = text.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            text = text.substring(i + 1);
        }
        if ((i = text.lastIndexOf(46)) >= 0) {
            text = text.substring(0, i);
        }
        return text;
    }

    @Nullable
    static CoverageRunner readRunnerAttribute(@NotNull Element element) {
        String runner;
        if (element == null) {
            BaseCoverageSuite.$$$reportNull$$$0(3);
        }
        return (runner = element.getAttributeValue(COVERAGE_RUNNER)) == null ? null : CoverageRunner.getInstanceById(runner);
    }

    @NotNull
    private static CoverageFileProvider readDataFileProviderAttribute(Element element) {
        String relativeOrAbsolutePath;
        File file;
        String sourceProvider = element.getAttributeValue(SOURCE_PROVIDER);
        if (sourceProvider == null) {
            sourceProvider = DefaultCoverageFileProvider.DEFAULT_LOCAL_PROVIDER_KEY;
        }
        if (!(file = new File(relativeOrAbsolutePath = FileUtil.toSystemDependentName((String)element.getAttributeValue(FILE_PATH)))).exists()) {
            file = new File(PathManager.getSystemPath(), relativeOrAbsolutePath);
        }
        return new DefaultCoverageFileProvider(file, sourceProvider);
    }

    @Deprecated(forRemoval=true)
    protected void setRunner(CoverageRunner runner) {
        this.myRunner = runner;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/BaseCoverageSuite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/BaseCoverageSuite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readRunnerAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

