/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class XmlWrongRootElementInspection
extends HtmlLocalInspectionTool {
    @NonNls
    @NotNull
    public String getShortName() {
        return "XmlWrongRootElement";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            XmlWrongRootElementInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            XmlWrongRootElementInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            XmlWrongRootElementInspection.$$$reportNull$$$0(2);
        }
        if (!(tag.getParent() instanceof XmlTag)) {
            PsiFile psiFile = tag.getContainingFile();
            if (!(psiFile instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)psiFile;
            XmlDocument document = xmlFile.getDocument();
            if (document == null) {
                return;
            }
            XmlProlog prolog = document.getProlog();
            if (prolog == null || XmlHighlightVisitor.skipValidation(prolog)) {
                return;
            }
            XmlDoctype doctype = prolog.getDoctype();
            if (doctype == null) {
                return;
            }
            XmlElement nameElement = doctype.getNameElement();
            if (nameElement == null) {
                return;
            }
            String name = tag.getName();
            String text2 = nameElement.getText();
            if (tag instanceof HtmlTag) {
                name = StringUtil.toLowerCase((String)name);
                text2 = StringUtil.toLowerCase((String)text2);
            }
            if (!name.equals(text2) && !(name = XmlUtil.findLocalNameByQualifiedName(name)).equals(text2)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                MyLocalQuickFix localQuickFix = new MyLocalQuickFix(doctype.getNameElement().getText());
                holder.registerProblem(XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode()).getPsi(), XmlAnalysisBundle.message("xml.inspections.wrong.root.element", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                ASTNode astNode = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag.getNode());
                if (astNode != null) {
                    holder.registerProblem(astNode.getPsi(), XmlAnalysisBundle.message("xml.inspections.wrong.root.element", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private final String myText;

        MyLocalQuickFix(String text2) {
            this.myText = text2;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = XmlAnalysisBundle.message("xml.quickfix.change.root.element.to", this.myText);
            if (string2 == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            XmlTag myTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class);
            myTag.setName(this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$MyLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }
}

