/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.patterns;

import com.intellij.util.containers.Stack;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.patterns.ComplexPatternOptions;
import com.intellij.webSymbols.patterns.WebSymbolsPattern;
import com.intellij.webSymbols.patterns.impl.CompletionAutoPopupPattern;
import com.intellij.webSymbols.patterns.impl.ComplexPattern;
import com.intellij.webSymbols.patterns.impl.ComplexPatternConfigProvider;
import com.intellij.webSymbols.patterns.impl.RegExpPattern;
import com.intellij.webSymbols.patterns.impl.SequencePattern;
import com.intellij.webSymbols.patterns.impl.SingleSymbolReferencePattern;
import com.intellij.webSymbols.patterns.impl.StaticPattern;
import com.intellij.webSymbols.patterns.impl.SymbolReferencePattern;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jf\u0010\u0004\u001a\u00020\u00052<\u0010\u0006\u001a8\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u0011J/\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00122\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0018\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00052\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0018\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001a\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u0011J\u0012\u0010\u001c\u001a\u00020\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001eJ\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u001e2\b\b\u0002\u0010#\u001a\u00020\u0012J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0012J\u0014\u0010&\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/webSymbols/patterns/WebSymbolsPatternFactory;", "", "<init>", "()V", "createComplexPattern", "Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "optionsProvider", "Lkotlin/Function2;", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "Lkotlin/ParameterName;", "name", "queryExecutor", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "contextStack", "Lcom/intellij/webSymbols/patterns/ComplexPatternOptions;", "isStaticAndRequiredProvider", "Lkotlin/Function0;", "", "patternsProvider", "", "options", "isStaticAndRequired", "patterns", "", "(Lcom/intellij/webSymbols/patterns/ComplexPatternOptions;Z[Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;)Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "createPatternSequence", "([Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;)Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "createSymbolReferencePlaceholder", "displayName", "", "createStringMatch", "content", "createRegExMatch", "regex", "caseSensitive", "createCompletionAutoPopup", "isSticky", "createSingleSymbolReferencePattern", "path", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "intellij.platform.webSymbols"})
@ApiStatus.Internal
public final class WebSymbolsPatternFactory {
    @NotNull
    public static final WebSymbolsPatternFactory INSTANCE = new WebSymbolsPatternFactory();

    private WebSymbolsPatternFactory() {
    }

    @NotNull
    public final WebSymbolsPattern createComplexPattern(@NotNull Function2<? super WebSymbolsQueryExecutor, ? super Stack<WebSymbolsScope>, ComplexPatternOptions> optionsProvider, @NotNull Function0<Boolean> isStaticAndRequiredProvider, @NotNull Function0<? extends List<? extends WebSymbolsPattern>> patternsProvider) {
        Intrinsics.checkNotNullParameter(optionsProvider, (String)"optionsProvider");
        Intrinsics.checkNotNullParameter(isStaticAndRequiredProvider, (String)"isStaticAndRequiredProvider");
        Intrinsics.checkNotNullParameter(patternsProvider, (String)"patternsProvider");
        return new ComplexPattern(new ComplexPatternConfigProvider(patternsProvider, optionsProvider, isStaticAndRequiredProvider){
            final /* synthetic */ Function0<List<WebSymbolsPattern>> $patternsProvider;
            final /* synthetic */ Function2<WebSymbolsQueryExecutor, Stack<WebSymbolsScope>, ComplexPatternOptions> $optionsProvider;
            final /* synthetic */ Function0<Boolean> $isStaticAndRequiredProvider;
            {
                this.$patternsProvider = $patternsProvider;
                this.$optionsProvider = $optionsProvider;
                this.$isStaticAndRequiredProvider = $isStaticAndRequiredProvider;
            }

            public List<WebSymbolsPattern> getPatterns() {
                return (List)this.$patternsProvider.invoke();
            }

            public ComplexPatternOptions getOptions(WebSymbolsQueryExecutor queryExecutor, Stack<WebSymbolsScope> scopeStack) {
                Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
                Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
                return (ComplexPatternOptions)this.$optionsProvider.invoke((Object)queryExecutor, scopeStack);
            }

            public boolean isStaticAndRequired() {
                return (Boolean)this.$isStaticAndRequiredProvider.invoke();
            }
        });
    }

    @NotNull
    public final WebSymbolsPattern createComplexPattern(@NotNull ComplexPatternOptions options, boolean isStaticAndRequired, WebSymbolsPattern ... patterns) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)patterns, (String)"patterns");
        return new ComplexPattern(new ComplexPatternConfigProvider(patterns, options, isStaticAndRequired){
            final /* synthetic */ WebSymbolsPattern[] $patterns;
            final /* synthetic */ ComplexPatternOptions $options;
            final /* synthetic */ boolean $isStaticAndRequired;
            {
                this.$patterns = $patterns;
                this.$options = $options;
                this.$isStaticAndRequired = $isStaticAndRequired;
            }

            public List<WebSymbolsPattern> getPatterns() {
                return ArraysKt.toList((Object[])this.$patterns);
            }

            public ComplexPatternOptions getOptions(WebSymbolsQueryExecutor queryExecutor, Stack<WebSymbolsScope> scopeStack) {
                Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
                Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
                return this.$options;
            }

            public boolean isStaticAndRequired() {
                return this.$isStaticAndRequired;
            }
        });
    }

    @NotNull
    public final WebSymbolsPattern createPatternSequence(WebSymbolsPattern ... patterns) {
        Intrinsics.checkNotNullParameter((Object)patterns, (String)"patterns");
        return new SequencePattern((Function0<? extends List<? extends WebSymbolsPattern>>)((Function0)() -> WebSymbolsPatternFactory.createPatternSequence$lambda$0(patterns)));
    }

    @NotNull
    public final WebSymbolsPattern createPatternSequence(@NotNull Function0<? extends List<? extends WebSymbolsPattern>> patternsProvider) {
        Intrinsics.checkNotNullParameter(patternsProvider, (String)"patternsProvider");
        return new SequencePattern(patternsProvider);
    }

    @NotNull
    public final WebSymbolsPattern createSymbolReferencePlaceholder(@Nullable String displayName) {
        return new SymbolReferencePattern(displayName);
    }

    public static /* synthetic */ WebSymbolsPattern createSymbolReferencePlaceholder$default(WebSymbolsPatternFactory webSymbolsPatternFactory, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return webSymbolsPatternFactory.createSymbolReferencePlaceholder(string2);
    }

    @NotNull
    public final WebSymbolsPattern createStringMatch(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return new StaticPattern(content);
    }

    @NotNull
    public final WebSymbolsPattern createRegExMatch(@NotNull String regex, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new RegExpPattern(regex, caseSensitive);
    }

    public static /* synthetic */ WebSymbolsPattern createRegExMatch$default(WebSymbolsPatternFactory webSymbolsPatternFactory, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return webSymbolsPatternFactory.createRegExMatch(string2, bl);
    }

    @NotNull
    public final WebSymbolsPattern createCompletionAutoPopup(boolean isSticky) {
        return new CompletionAutoPopupPattern(isSticky);
    }

    @NotNull
    public final WebSymbolsPattern createSingleSymbolReferencePattern(@NotNull List<WebSymbolQualifiedName> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return new SingleSymbolReferencePattern(CollectionsKt.toList((Iterable)path), false, false, 6, null);
    }

    private static final List createPatternSequence$lambda$0(WebSymbolsPattern[] $patterns) {
        return ArraysKt.toList((Object[])$patterns);
    }
}

