/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.MessageManager;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.MessageManagerBaseKt;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.ResultReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0004\b\u0001\u0010\u0003*\b\b\u0002\u0010\u0004*\u00020\u0005*\u0004\b\u0003\u0010\u00062\u00020\u0007:\u0001 B'\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00030\u000e\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00030\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00030\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0013\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00030\u000e2\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0012R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00030\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/rpc/MessageManager;", "REQUEST", "Lorg/jetbrains/jsonProtocol/Request;", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "Lorg/jetbrains/rpc/MessageManagerBase;", "handler", "Lorg/jetbrains/rpc/MessageManager$Handler;", "<init>", "(Lorg/jetbrains/rpc/MessageManager$Handler;)V", "callbackMap", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/rpc/RequestCallback;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "send", "", "message", "callback", "(Lorg/jetbrains/jsonProtocol/Request;Lorg/jetbrains/rpc/RequestCallback;)V", "decorateCallback", "failedToSend", "sequence", "", "processIncoming", "incomingParsed", "(Ljava/lang/Object;)V", "getCallbackAndRemove", "id", "cancelWaitingRequests", "Handler", "intellij.platform.scriptDebugger.backend"})
public final class MessageManager<REQUEST extends Request<?>, INCOMING, INCOMING_WITH_SEQ, SUCCESS>
extends MessageManagerBase {
    @NotNull
    private final Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler;
    @NotNull
    private final ConcurrentIntObjectMap<RequestCallback<SUCCESS>> callbackMap;

    public MessageManager(@NotNull Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.handler = handler2;
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.callbackMap = concurrentIntObjectMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(@NotNull REQUEST message, @NotNull RequestCallback<SUCCESS> callback) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (this.rejectIfClosed(callback)) {
            message.getBuffer().release();
            return;
        }
        int sequence = this.handler.getUpdatedSequence(message);
        this.callbackMap.put(sequence, this.decorateCallback(callback));
        boolean success = false;
        try {
            success = this.handler.write(message);
        }
        catch (Throwable e) {
            try {
                this.failedToSend(sequence);
            }
            finally {
                CommandProcessorKt.getLOG().error("Failed to send", e);
            }
            return;
        }
        if (!success) {
            this.failedToSend(sequence);
        }
    }

    private final RequestCallback<SUCCESS> decorateCallback(RequestCallback<SUCCESS> callback) {
        ClientId currentId = ClientId.Companion.getCurrent();
        return new RequestCallback<SUCCESS>(currentId, callback){
            final /* synthetic */ ClientId $currentId;
            final /* synthetic */ RequestCallback<SUCCESS> $callback;
            {
                this.$currentId = $currentId;
                this.$callback = $callback;
            }

            public void onSuccess(SUCCESS response, ResultReader<? super SUCCESS> resultReader) {
                ClientId.Companion.withClientId(this.$currentId, () -> decorateCallback.1.onSuccess$lambda$0(this.$callback, response, resultReader));
            }

            public void onError(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                ClientId.Companion.withClientId(this.$currentId, () -> decorateCallback.1.onError$lambda$1(this.$callback, error));
            }

            private static final Unit onSuccess$lambda$0(RequestCallback $callback, Object $response, ResultReader $resultReader) {
                $callback.onSuccess($response, $resultReader);
                return Unit.INSTANCE;
            }

            private static final Unit onError$lambda$1(RequestCallback $callback, Throwable $error) {
                $callback.onError($error);
                return Unit.INSTANCE;
            }
        };
    }

    private final void failedToSend(int sequence) {
        block0: {
            RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(sequence);
            if (requestCallback == null) break block0;
            requestCallback.onError("Failed to send");
        }
    }

    public final void processIncoming(INCOMING incomingParsed) {
        INCOMING_WITH_SEQ commandResponse = this.handler.readIfHasSequence(incomingParsed);
        if (commandResponse == null) {
            if (this.getClosed()) {
                CommandProcessorKt.getLOG().info("Connection closed, ignore incoming");
            } else {
                this.handler.acceptNonSequence(incomingParsed);
            }
            return;
        }
        RequestCallback<SUCCESS> callback = this.getCallbackAndRemove(this.handler.getSequence(commandResponse, incomingParsed));
        if (this.rejectIfClosed(callback)) {
            return;
        }
        try {
            this.handler.call(commandResponse, callback);
        }
        catch (Throwable e) {
            callback.onError(e);
            CommandProcessorKt.getLOG().error("Failed to dispatch response to callback", e);
        }
    }

    @NotNull
    public final RequestCallback<SUCCESS> getCallbackAndRemove(int id) {
        RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(id);
        if (requestCallback == null) {
            throw new IllegalArgumentException("Cannot find callback with id " + id);
        }
        return requestCallback;
    }

    public final void cancelWaitingRequests() {
        ConcurrentIntObjectMap<RequestCallback<SUCCESS>> map = this.callbackMap;
        int[] nArray = map.keys();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"keys(...)");
        int[] keys = nArray;
        Arrays.sort(keys);
        for (int key2 : keys) {
            RequestCallback requestCallback = (RequestCallback)map.get(key2);
            if (requestCallback == null) continue;
            MessageManagerBaseKt.reject(requestCallback);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0004\u0010\u0001*\u0004\b\u0005\u0010\u0002*\b\b\u0006\u0010\u0003*\u00020\u0004*\u0004\b\u0007\u0010\u00052\u00020\u0004J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0004H&\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00028\u0004H&\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00018\u00062\u0006\u0010\u000e\u001a\u00028\u0005H&\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00028\u0006H\u0016\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00028\u00062\u0006\u0010\u000e\u001a\u00028\u0005H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00028\u0005H&\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00028\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00070\u0019H&\u00a2\u0006\u0002\u0010\u001a\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/rpc/MessageManager$Handler;", "OUTGOING", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "getUpdatedSequence", "", "message", "(Ljava/lang/Object;)I", "write", "", "(Ljava/lang/Object;)Z", "readIfHasSequence", "incoming", "(Ljava/lang/Object;)Ljava/lang/Object;", "getSequence", "incomingWithSeq", "(Ljava/lang/Object;Ljava/lang/Object;)I", "acceptNonSequence", "", "(Ljava/lang/Object;)V", "call", "response", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "(Ljava/lang/Object;Lorg/jetbrains/rpc/RequestCallback;)V", "intellij.platform.scriptDebugger.backend"})
    public static interface Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> {
        public int getUpdatedSequence(OUTGOING var1);

        public boolean write(OUTGOING var1) throws IOException;

        @Nullable
        public INCOMING_WITH_SEQ readIfHasSequence(INCOMING var1);

        default public int getSequence(@NotNull INCOMING_WITH_SEQ incomingWithSeq) {
            Intrinsics.checkNotNullParameter(incomingWithSeq, (String)"incomingWithSeq");
            throw new AbstractMethodError();
        }

        default public int getSequence(@NotNull INCOMING_WITH_SEQ incomingWithSeq, INCOMING incoming) {
            Intrinsics.checkNotNullParameter(incomingWithSeq, (String)"incomingWithSeq");
            return this.getSequence(incomingWithSeq);
        }

        public void acceptNonSequence(INCOMING var1);

        public void call(@NotNull INCOMING_WITH_SEQ var1, @NotNull RequestCallback<SUCCESS> var2);
    }
}

