/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstrWithLocation;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilderKt;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0018J1\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0018\u0010\"\u001a\u00020#*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder;", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "expression", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "<init>", "(Ljava/util/List;)V", "getExpression", "()Ljava/util/List;", "eatEverythingUntilLevel", "", "Ljava/lang/Integer;", "lastInstructionIndex", "addInstruction", "", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "getCurrentEatLevel", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;)Ljava/lang/Integer;", "buildInstr", "trimInstructionsUntil", "index", "value", "numberOfNestedBlocks", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "isPseudoInstruction", "", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;)Z", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmIrExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmIrExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n388#2,7:119\n1#3:126\n*S KotlinDebug\n*F\n+ 1 WasmIrExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder\n*L\n35#1:119,7\n*E\n"})
public final class WasmIrExpressionBuilder
extends WasmExpressionBuilder {
    @NotNull
    private final List<WasmInstr> expression;
    @Nullable
    private Integer eatEverythingUntilLevel;
    private int lastInstructionIndex;
    private int numberOfNestedBlocks;

    /*
     * WARNING - void declaration
     */
    public WasmIrExpressionBuilder(@NotNull List<WasmInstr> expression2) {
        int n;
        int n2;
        block1: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            List<WasmInstr> list = this.expression = expression2;
            WasmIrExpressionBuilder wasmIrExpressionBuilder = this;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                WasmInstr it = (WasmInstr)iterator$iv.previous();
                boolean bl = false;
                if (!(!this.isPseudoInstruction(it.getOperator()))) continue;
                n2 = iterator$iv.nextIndex();
                break block1;
            }
            n2 = -1;
        }
        wasmIrExpressionBuilder.lastInstructionIndex = n = n2;
    }

    @NotNull
    public final List<WasmInstr> getExpression() {
        return this.expression;
    }

    private final void addInstruction(WasmOp op, SourceLocation location, WasmImmediate[] immediates) {
        ((Collection)this.expression).add(new WasmInstrWithLocation(op, ArraysKt.toList(immediates), location));
        if (!this.isPseudoInstruction(op)) {
            this.lastInstructionIndex = CollectionsKt.getLastIndex(this.expression);
        }
    }

    private final Integer getCurrentEatLevel(WasmOp op) {
        Integer n = this.eatEverythingUntilLevel;
        if (n == null) {
            return null;
        }
        int eatLevel = n;
        if (this.getNumberOfNestedBlocks() == eatLevel && WasmIrExpressionBuilderKt.access$isInCfgNode(op)) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        if (this.getNumberOfNestedBlocks() < eatLevel) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        return eatLevel;
    }

    @Override
    public void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, WasmImmediate ... immediates) {
        Intrinsics.checkNotNullParameter((Object)op, "op");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(immediates, "immediates");
        Integer currentEatUntil = this.getCurrentEatLevel(op);
        if (currentEatUntil != null) {
            if (currentEatUntil <= this.getNumberOfNestedBlocks()) {
                return;
            }
        } else if (WasmIrExpressionBuilderKt.access$isOutCfgNode(op)) {
            this.eatEverythingUntilLevel = this.getNumberOfNestedBlocks();
            this.addInstruction(op, location, immediates);
            return;
        }
        if (this.lastInstructionIndex == -1) {
            this.addInstruction(op, location, immediates);
            return;
        }
        WasmInstr lastInstruction = this.expression.get(this.lastInstructionIndex);
        WasmOp lastOperator = lastInstruction.getOperator();
        if ((op == WasmOp.DROP || op == WasmOp.UNREACHABLE) && WasmIrExpressionBuilderKt.access$pureStacklessInstruction(lastOperator)) {
            this.trimInstructionsUntil(this.lastInstructionIndex);
            SourceLocation sourceLocation = lastInstruction.getLocation();
            SourceLocation.Location location2 = sourceLocation instanceof SourceLocation.Location ? (SourceLocation.Location)sourceLocation : null;
            if (location2 != null) {
                SourceLocation p0 = location2;
                boolean bl = false;
                this.buildNop(p0);
            }
            return;
        }
        if (lastOperator == WasmOp.LOCAL_SET && op == WasmOp.LOCAL_GET) {
            WasmSymbol<WasmLocal> localSetNumber;
            WasmImmediate wasmImmediate = CollectionsKt.firstOrNull(lastInstruction.getImmediates());
            WasmImmediate.LocalIdx localIdx = wasmImmediate instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)wasmImmediate : null;
            WasmSymbol<WasmLocal> wasmSymbol = localSetNumber = localIdx != null ? localIdx.getValue() : null;
            if (localSetNumber != null) {
                WasmSymbol<WasmLocal> localGetNumber;
                WasmImmediate wasmImmediate2 = ArraysKt.firstOrNull(immediates);
                WasmImmediate.LocalIdx localIdx2 = wasmImmediate2 instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)wasmImmediate2 : null;
                WasmSymbol<WasmLocal> wasmSymbol2 = localGetNumber = localIdx2 != null ? localIdx2.getValue() : null;
                if (Intrinsics.areEqual(localGetNumber, localSetNumber)) {
                    this.trimInstructionsUntil(this.lastInstructionIndex);
                    this.addInstruction(WasmOp.LOCAL_TEE, location, immediates);
                    return;
                }
            }
        }
        this.addInstruction(op, location, immediates);
    }

    private final void trimInstructionsUntil(int index) {
        AddToStdlibKt.trimToSize(this.expression, index);
        this.lastInstructionIndex = index - 1;
    }

    @Override
    public int getNumberOfNestedBlocks() {
        return this.numberOfNestedBlocks;
    }

    @Override
    public void setNumberOfNestedBlocks(int value2) {
        boolean bl;
        boolean bl2 = bl = value2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "end without matching block";
            throw new AssertionError((Object)string2);
        }
        this.numberOfNestedBlocks = value2;
    }

    private final boolean isPseudoInstruction(WasmOp $this$isPseudoInstruction) {
        return $this$isPseudoInstruction.getOpcode() == 65535;
    }
}

