/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhenImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="JvmLateinitLowering")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Transformer", "backend.jvm.lower"})
public final class JvmLateinitLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmLateinitLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Transformer transformer2 = new Transformer(this.context);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)transformer2);
        for (IrVariable variable : transformer2.getLateinitVariables()) {
            variable.setLateinit(false);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u000eH\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u0013*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lateinitVariables", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getLateinitVariables", "()Ljava/util/List;", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitVariable", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "isLateinitBackingField", "", "isRealLateinit", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "transformGetter", "", "backingField", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n+ 2 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLoweringKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n225#2,12:174\n1#3:186\n*S KotlinDebug\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n*L\n124#1:174,12\n*E\n"})
    private static final class Transformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JvmBackendContext backendContext;
        @NotNull
        private final List<IrVariable> lateinitVariables;

        public Transformer(@NotNull JvmBackendContext backendContext) {
            Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
            this.backendContext = backendContext;
            this.lateinitVariables = new ArrayList();
        }

        @NotNull
        public final List<IrVariable> getLateinitVariables() {
            return this.lateinitVariables;
        }

        @NotNull
        public IrStatement visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (this.isLateinitBackingField(declaration)) {
                boolean bl;
                boolean bl2 = bl = declaration.getInitializer() == null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "lateinit property backing field should not have an initializer:\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)declaration), null, (int)1, null);
                    throw new AssertionError((Object)string);
                }
                declaration.setType(IrTypesKt.makeNullable((IrType)declaration.getType()));
                IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
                Intrinsics.checkNotNull((Object)irPropertySymbol);
                IrProperty property2 = (IrProperty)irPropertySymbol.getOwner();
                Object object = property2.getSetter();
                if (object == null || (object = object.getVisibility()) == null) {
                    object = property2.getVisibility();
                }
                declaration.setVisibility((DescriptorVisibility)object);
            }
            this.transformChildrenVoid((IrElement)declaration);
            return (IrStatement)declaration;
        }

        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)declaration), (IrElementTransformerVoid)this);
            if (declaration.isLateinit()) {
                declaration.setType(IrTypesKt.makeNullable((IrType)declaration.getType()));
                declaration.setVar(true);
                declaration.setInitializer((IrExpression)IrConstImpl.Companion.constNull(declaration.getStartOffset(), declaration.getEndOffset(), this.backendContext.getIrBuiltIns().getNothingNType()));
                ((Collection)this.lateinitVariables).add(declaration);
            }
            return (IrStatement)declaration;
        }

        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            IrProperty property2;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
            Object object = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property2 != null && this.isRealLateinit(property2) && Intrinsics.areEqual((Object)declaration, (Object)property2.getGetter())) {
                IrField irField = property2.getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                this.transformGetter(irField, (IrFunction)declaration);
                return (IrStatement)declaration;
            }
            this.transformChildrenVoid((IrElement)declaration);
            return (IrStatement)declaration;
        }

        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration irValue = expression2.getSymbol().getOwner();
            if (!(irValue instanceof IrVariable) || !((IrVariable)irValue).isLateinit()) {
                return (IrExpression)expression2;
            }
            BackendContext backendContext = (BackendContext)this.backendContext;
            IrDeclarationParent irDeclarationParent = ((IrVariable)irValue).getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            DeclarationIrBuilder $this$visitGetValue_u24lambda_u241 = LowerUtilsKt.createIrBuilder((BackendContext)backendContext, (IrSymbol)((IrSymbolOwner)irDeclarationParent).getSymbol(), (int)expression2.getStartOffset(), (int)expression2.getEndOffset());
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitGetValue_u24lambda_u241;
            IrType irType = expression2.getType();
            IrExpression irExpression = ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)((IrBuilderWithScope)$this$visitGetValue_u24lambda_u241), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$visitGetValue_u24lambda_u241), (IrValueDeclaration)irValue)));
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$visitGetValue_u24lambda_u241;
            String string = irValue.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return (IrExpression)ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)irBuilderWithScope, (IrType)irType, (IrExpression)irExpression, (IrExpression)this.backendContext.throwUninitializedPropertyAccessException(irBuilderWithScope2, string), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$visitGetValue_u24lambda_u241), (IrValueDeclaration)irValue)), null, (int)16, null);
        }

        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)this);
            IrField irField = (IrField)expression2.getSymbol().getOwner();
            if (this.isLateinitBackingField(irField)) {
                expression2.setType(IrTypesKt.makeNullable((IrType)expression2.getType()));
            }
            return (IrExpression)expression2;
        }

        private final boolean isLateinitBackingField(IrField $this$isLateinitBackingField) {
            IrPropertySymbol irPropertySymbol = $this$isLateinitBackingField.getCorrespondingPropertySymbol();
            IrProperty property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            return property2 != null && this.isRealLateinit(property2);
        }

        private final boolean isRealLateinit(IrProperty $this$isRealLateinit) {
            return $this$isRealLateinit.isLateinit() && !$this$isRealLateinit.isFakeOverride();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)this);
            if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter((IrFunctionSymbol)expression2.getSymbol())) {
                return (IrExpression)expression2;
            }
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            Intrinsics.checkNotNull((Object)irExpression2);
            IrExpression $this$replaceTailExpression$iv = irExpression2;
            boolean $i$f$replaceTailExpression = false;
            IrExpression current$iv = $this$replaceTailExpression$iv;
            IrContainerExpression block$iv = null;
            while (current$iv instanceof IrContainerExpression) {
                block$iv = (IrContainerExpression)current$iv;
                Object object = CollectionsKt.last((List)((IrContainerExpression)current$iv).getStatements());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                current$iv = (IrExpression)object;
            }
            IrExpression it = current$iv;
            boolean bl = false;
            IrPropertyReference irPropertyReference = it instanceof IrPropertyReference ? (IrPropertyReference)it : null;
            if (irPropertyReference == null) {
                throw new AssertionError((Object)("Property reference expected: " + RenderIrElementKt.render$default((IrElement)((IrElement)it), null, (int)1, null)));
            }
            IrPropertyReference irPropertyRef = irPropertyReference;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = irPropertyRef.getGetter();
            if (irSimpleFunctionSymbol == null || (irSimpleFunctionSymbol = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner()) == null || (irSimpleFunctionSymbol = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)((IrOverridableDeclaration)irSimpleFunctionSymbol), null, (int)1, null)) == null || (irSimpleFunctionSymbol = irSimpleFunctionSymbol.getCorrespondingPropertySymbol()) == null || (irSimpleFunctionSymbol = (IrProperty)irSimpleFunctionSymbol.getOwner()) == null) {
                throw new AssertionError((Object)("isInitialized cannot be invoked on " + RenderIrElementKt.render$default((IrElement)((IrElement)it), null, (int)1, null)));
            }
            IrSimpleFunctionSymbol property2 = irSimpleFunctionSymbol;
            if (!property2.isLateinit()) {
                boolean bl2 = false;
                String string = "isInitialized invoked on non-lateinit property " + RenderIrElementKt.render$default((IrElement)((IrElement)property2), null, (int)1, null);
                throw new IllegalArgumentException(string.toString());
            }
            IrField irField = property2.getBackingField();
            if (irField == null) {
                throw new AssertionError((Object)"Lateinit property is supposed to have a backing field");
            }
            IrField backingField = irField;
            DeclarationIrBuilder $this$visitCall_u24lambda_u244_u24lambda_u243 = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)this.backendContext), (IrSymbol)((IrPropertyReference)it).getSymbol(), (int)expression2.getStartOffset(), (int)expression2.getEndOffset());
            boolean bl3 = false;
            current$iv = ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u244_u24lambda_u243), (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u244_u24lambda_u243), (IrExpression)((IrPropertyReference)it).getDispatchReceiver(), (IrField)backingField, null, (int)4, null)), (IrExpression)((IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u244_u24lambda_u243))));
            if (block$iv == null) {
                irExpression = current$iv;
            } else {
                void var2_2;
                block$iv.getStatements().set(block$iv.getStatements().size() - 1, current$iv);
                irExpression = var2_2;
            }
            return irExpression;
        }

        private final void transformGetter(IrField backingField, IrFunction getter) {
            boolean bl;
            IrType type = backingField.getType();
            boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default((IrType)type, (boolean)false, (int)1, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = false;
                String $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = "'lateinit' property type should not be primitive:\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)backingField), null, (int)1, null);
                throw new AssertionError((Object)$i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22);
            }
            int startOffset = getter.getStartOffset();
            int endOffset = getter.getEndOffset();
            getter.setBody((IrBody)IrFactoryHelpersKt.createBlockBody((IrFactory)this.backendContext.getIrFactory(), (int)startOffset, (int)endOffset, arg_0 -> Transformer.transformGetter$lambda$8(this, getter, startOffset, endOffset, backingField, arg_0)));
        }

        private final IrExpression throwUninitializedPropertyAccessException(IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name) {
            return this.backendContext.throwUninitializedPropertyAccessException($this$throwUninitializedPropertyAccessException, name);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit transformGetter$lambda$8(Transformer this$0, IrFunction $getter, int $startOffset, int $endOffset, IrField $backingField, IrBlockBody $this$createBlockBody) {
            IrGetValueImpl irGetValueImpl;
            DeclarationIrBuilder irBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
            DeclarationIrBuilder $this$transformGetter_u24lambda_u248_u24lambda_u247 = irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)this$0.backendContext), (IrSymbol)((IrSymbol)$getter.getSymbol()), (int)$startOffset, (int)$endOffset);
            boolean bl = false;
            Scope scope = $this$transformGetter_u24lambda_u248_u24lambda_u247.getScope();
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247;
            IrValueParameter irValueParameter = $getter.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                void it;
                IrValueParameter irValueParameter2 = irValueParameter;
                IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                Scope scope2 = scope;
                boolean bl2 = false;
                IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247), (IrValueDeclaration)((IrValueDeclaration)it));
                scope = scope2;
                irBuilderWithScope = irBuilderWithScope2;
                irGetValueImpl = irGetValueImpl2;
            } else {
                irGetValueImpl = null;
            }
            IrVariable resultVar = IrBuilderKt.createTmpVariable$default((Scope)scope, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irGetValueImpl), (IrField)$backingField, (IrType)IrTypesKt.makeNullable((IrType)$backingField.getType()))), null, (boolean)false, null, null, (int)30, null);
            resultVar.setParent((IrDeclarationParent)$getter);
            $this$createBlockBody.getStatements().add(resultVar);
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247;
            IrType irType = $this$transformGetter_u24lambda_u248_u24lambda_u247.getContext().getIrBuiltIns().getNothingType();
            IrExpression irExpression = ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)((IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247), (IrValueDeclaration)((IrValueDeclaration)resultVar))), (IrExpression)((IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247))));
            IrExpression irExpression2 = (IrExpression)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247), (IrValueDeclaration)((IrValueDeclaration)resultVar))));
            IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$transformGetter_u24lambda_u248_u24lambda_u247;
            String string = $backingField.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            IrWhenImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)irBuilderWithScope3, (IrType)irType, (IrExpression)irExpression, (IrExpression)irExpression2, (IrExpression)this$0.throwUninitializedPropertyAccessException(irBuilderWithScope4, string), null, (int)16, null);
            $this$createBlockBody.getStatements().add(throwIfNull);
            return Unit.INSTANCE;
        }
    }
}

