/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticMarker;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2Marker;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3Marker;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.multiplatform.K1ExpectActualCompatibility;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/ClassicPositioningStrategies;", "", "<init>", "()V", "ACTUAL_DECLARATION_NAME", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "firstIncompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/K1ExpectActualCompatibility$Incompatible;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;", "getFirstIncompatibility", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;)Lorg/jetbrains/kotlin/resolve/multiplatform/K1ExpectActualCompatibility$Incompatible;", "INCOMPATIBLE_DECLARATION", "UNREACHABLE_CODE", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class ClassicPositioningStrategies {
    @NotNull
    public static final ClassicPositioningStrategies INSTANCE = new ClassicPositioningStrategies();
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> ACTUAL_DECLARATION_NAME = (PositioningStrategy)new PositioningStrategies.DeclarationHeader<KtNamedDeclaration>(){

        public List<TextRange> mark(KtNamedDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement nameIdentifier = element.getNameIdentifier();
            PsiElement psiElement = nameIdentifier;
            return psiElement != null ? PositioningStrategyKt.markElement((PsiElement)psiElement) : (element instanceof KtNamedFunction ? PositioningStrategies.DECLARATION_SIGNATURE.mark((PsiElement)element) : PositioningStrategies.DEFAULT.mark((PsiElement)element));
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> INCOMPATIBLE_DECLARATION = (PositioningStrategy)new PositioningStrategies.DeclarationHeader<KtNamedDeclaration>(){

        /*
         * Enabled aggressive block sorting
         */
        public List<TextRange> markDiagnostic(DiagnosticMarker diagnostic) {
            Object object;
            PsiElement psiElement;
            PsiElement it;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            KtNamedDeclaration element = (KtNamedDeclaration)psiElement2;
            KtCallableDeclaration callableDeclaration = element instanceof KtCallableDeclaration ? (KtCallableDeclaration)element : null;
            K1ExpectActualCompatibility.Incompatible incompatibility = ClassicPositioningStrategies.access$getFirstIncompatibility(ClassicPositioningStrategies.INSTANCE, diagnostic);
            Object object3 = incompatibility;
            if (object3 == null || object3 instanceof K1ExpectActualCompatibility.Incompatible.ClassScopes || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.EnumEntries.INSTANCE)) {
                object2 = null;
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ClassKind.INSTANCE)) {
                ASTNode endElement;
                ASTNode aSTNode;
                KtModifierList startElement;
                Object object4 = element.getModifierList();
                if (object4 == null || (object4 = object4.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                    KtModifierList ktModifierList = element.getModifierList();
                    object4 = startElement = ktModifierList != null ? ktModifierList.getModifier(KtTokens.ANNOTATION_KEYWORD) : null;
                }
                if ((aSTNode = element.getNode().findChildByType(PositioningStrategies.INSTANCE.getClassKindTokens())) == null || (aSTNode = aSTNode.getPsi()) == null) {
                    aSTNode = endElement = element.getNameIdentifier();
                }
                if (startElement != null && endElement != null) {
                    return PositioningStrategyKt.markRange((PsiElement)startElement, (PsiElement)endElement);
                }
                object2 = endElement;
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.TypeParameterNames.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.FunctionTypeParameterCount.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ClassTypeParameterCount.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.FunctionTypeParameterUpperBounds.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ClassTypeParameterUpperBounds.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.TypeParameterVariance.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.TypeParameterReified.INSTANCE)) {
                KtTypeParameterListOwner ktTypeParameterListOwner = element instanceof KtTypeParameterListOwner ? (KtTypeParameterListOwner)element : null;
                object2 = (PsiElement)(ktTypeParameterListOwner != null ? ktTypeParameterListOwner.getTypeParameterList() : null);
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.CallableKind.INSTANCE)) {
                object2 = callableDeclaration instanceof KtNamedFunction ? (KtNamedFunction)callableDeclaration : null;
                if (object2 == null || (object2 = object2.getFunKeyword()) == null) {
                    KtProperty ktProperty = callableDeclaration instanceof KtProperty ? (KtProperty)callableDeclaration : null;
                    object2 = ktProperty != null ? ktProperty.getValOrVarKeyword() : null;
                }
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ParameterShape.INSTANCE)) {
                KtElementImplStub ktElementImplStub;
                KtCallableDeclaration ktCallableDeclaration = callableDeclaration;
                if (ktCallableDeclaration != null) {
                    it = ktCallableDeclaration;
                    boolean bl = false;
                    KtTypeReference ktTypeReference = it.getReceiverTypeReference();
                    ktElementImplStub = ktTypeReference != null ? (KtElementImplStub)ktTypeReference : (KtElementImplStub)it.getValueParameterList();
                } else {
                    ktElementImplStub = null;
                }
                object2 = (PsiElement)ktElementImplStub;
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ParameterCount.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ParameterTypes.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ParameterNames.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ValueParameterVararg.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ActualFunctionWithDefaultParameters.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ValueParameterNoinline.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ValueParameterCrossinline.INSTANCE)) {
                KtCallableDeclaration ktCallableDeclaration = callableDeclaration;
                object2 = (PsiElement)(ktCallableDeclaration != null ? ktCallableDeclaration.getValueParameterList() : null);
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ReturnType.INSTANCE)) {
                KtCallableDeclaration ktCallableDeclaration = callableDeclaration;
                object2 = (PsiElement)(ktCallableDeclaration != null ? ktCallableDeclaration.getTypeReference() : null);
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.FunctionModifiersDifferent.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.FunctionModifiersNotSubset.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.PropertyLateinitModifier.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.PropertyConstModifier.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.ClassModifiers.INSTANCE) || Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.FunInterfaceModifier.INSTANCE)) {
                object2 = (PsiElement)element.getModifierList();
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.PropertyKind.INSTANCE)) {
                ASTNode aSTNode = element.getNode().findChildByType(PositioningStrategies.INSTANCE.getPropertyKindTokens());
                object2 = aSTNode != null ? aSTNode.getPsi() : null;
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.Supertypes.INSTANCE)) {
                KtClassOrObject ktClassOrObject = element instanceof KtClassOrObject ? (KtClassOrObject)element : null;
                object2 = (PsiElement)(ktClassOrObject != null ? ktClassOrObject.getSuperTypeList() : null);
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.Modality.INSTANCE)) {
                object2 = KtPsiUtilKt.modalityModifier((KtDeclaration)((KtDeclaration)element));
            } else if (Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.Visibility.INSTANCE)) {
                object2 = KtPsiUtilKt.visibilityModifier((KtModifierListOwner)((KtModifierListOwner)element));
            } else {
                if (!Intrinsics.areEqual((Object)object3, (Object)K1ExpectActualCompatibility.Incompatible.PropertySetterVisibility.INSTANCE)) throw new NoWhenBranchMatchedException();
                KtProperty ktProperty = element instanceof KtProperty ? (KtProperty)element : null;
                object2 = psiElement = (PsiElement)(ktProperty != null && (ktProperty = ktProperty.getSetter()) != null ? ktProperty.getModifierList() : null);
            }
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                object3 = PositioningStrategyKt.markElement(it);
                if (object3 != null) {
                    object = object3;
                    return object;
                }
            }
            object = ClassicPositioningStrategies.ACTUAL_DECLARATION_NAME.mark((PsiElement)element);
            return object;
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE = (PositioningStrategy)new PositioningStrategy<PsiElement>(){

        public List<TextRange> markDiagnostic(DiagnosticMarker diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters2Marker unreachableCode = (DiagnosticWithParameters2Marker)diagnostic;
            PsiElement psiElement = unreachableCode.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            return UnreachableCode.Companion.getUnreachableTextRanges((KtElement)psiElement, (Set)unreachableCode.getA(), (Set)unreachableCode.getB());
        }
    };

    private ClassicPositioningStrategies() {
    }

    private final K1ExpectActualCompatibility.Incompatible<MemberDescriptor> getFirstIncompatibility(DiagnosticMarker $this$firstIncompatibility) {
        Object object;
        String string = $this$firstIncompatibility.getFactoryName();
        if (Intrinsics.areEqual((Object)string, (Object)Errors.NO_ACTUAL_FOR_EXPECT.getName())) {
            Intrinsics.checkNotNull((Object)$this$firstIncompatibility, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3Marker<*, *, *>");
            object = ((DiagnosticWithParameters3Marker)$this$firstIncompatibility).getC();
        } else if (Intrinsics.areEqual((Object)string, (Object)Errors.ACTUAL_WITHOUT_EXPECT.getName())) {
            Intrinsics.checkNotNull((Object)$this$firstIncompatibility, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2Marker<*, *>");
            object = ((DiagnosticWithParameters2Marker)$this$firstIncompatibility).getB();
        } else {
            object = null;
        }
        Object object2 = object;
        Map map = object2 instanceof Map ? (Map)object2 : null;
        if (map == null) {
            return null;
        }
        Map map2 = map;
        return (K1ExpectActualCompatibility.Incompatible)CollectionsKt.firstOrNull((Iterable)map2.keySet());
    }

    public static final /* synthetic */ K1ExpectActualCompatibility.Incompatible access$getFirstIncompatibility(ClassicPositioningStrategies $this, DiagnosticMarker $receiver) {
        return $this.getFirstIncompatibility($receiver);
    }
}

