/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonString;", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "write", "", "writer", "Ljava/io/Writer;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "js.parser"})
public final class JsonString
extends JsonNode {
    @NotNull
    private final String value;

    public JsonString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(null);
        this.value = value;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.append('\"');
        String string = this.value;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            Writer writer2;
            char c = string.charAt(i);
            char c2 = c;
            if (c2 == '\\') {
                writer2 = writer.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                writer2 = writer.append("\\\"");
                continue;
            }
            if (c2 == '\r') {
                writer2 = writer.append("\\r");
                continue;
            }
            if (c2 == '\n') {
                writer2 = writer.append("\\n");
                continue;
            }
            if (c2 == '\t') {
                writer2 = writer.append("\\t");
                continue;
            }
            if (c2 == '\b') {
                writer2 = writer.append("\\b");
                continue;
            }
            if (c2 == '\f') {
                writer2 = writer.append("\\f");
                continue;
            }
            boolean bl = ' ' <= c2 ? c2 < '\u007f' : false;
            if (bl) {
                writer2 = writer.append(c);
                continue;
            }
            writer.append("\\u");
            int shift = 0;
            shift = 16;
            int n2 = 4;
            for (int j = 0; j < n2; ++j) {
                int it = j;
                boolean bl2 = false;
                int digit = c >>> (shift -= 4) & 0xF;
                writer.append(digit < 10 ? (char)(digit + 48) : (char)(digit - 10 + 97));
            }
            writer2 = Unit.INSTANCE;
        }
        writer.append('\"');
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString();
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final JsonString copy(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new JsonString(value);
    }

    public static /* synthetic */ JsonString copy$default(JsonString jsonString, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = jsonString.value;
        }
        return jsonString.copy(string);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonString)) {
            return false;
        }
        JsonString jsonString = (JsonString)other;
        return Intrinsics.areEqual((Object)this.value, (Object)jsonString.value);
    }
}

